/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.value;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.internal.databinding.observable.Util;

public class SelectObservableValue<T>
extends AbstractObservableValue<T> {
    private final Object valueType;
    private List<Option> options;
    private int selectionIndex = -1;
    private boolean updating = false;
    private IValueChangeListener<Boolean> listener = event -> {
        IObservableValue observable;
        if (!this.updating && Boolean.TRUE.equals((observable = event.getObservableValue()).getValue())) {
            this.notifyIfChanged(this.indexOfObservable(observable));
        }
    };

    public SelectObservableValue() {
        this(Realm.getDefault(), null);
    }

    public SelectObservableValue(Realm realm) {
        this(realm, null);
    }

    public SelectObservableValue(Object valueType) {
        this(Realm.getDefault(), valueType);
    }

    public SelectObservableValue(Realm realm, Object valueType) {
        super(realm);
        this.valueType = valueType;
        this.options = new ArrayList<Option>();
    }

    @Override
    protected void firstListenerAdded() {
        super.firstListenerAdded();
        this.selectionIndex = this.indexOfValue(this.getLiveValue());
        for (Option option : this.options) {
            option.observable.addValueChangeListener(this.listener);
        }
    }

    @Override
    protected void lastListenerRemoved() {
        for (Option option : this.options) {
            option.observable.removeValueChangeListener(this.listener);
        }
        this.selectionIndex = -1;
        super.lastListenerRemoved();
    }

    @Override
    public Object getValueType() {
        return this.valueType;
    }

    private void notifyIfChanged(int index) {
        if (this.hasListeners() && this.selectionIndex != index) {
            T oldValue = this.valueAtIndex(this.selectionIndex);
            T newValue = this.valueAtIndex(index);
            this.selectionIndex = index;
            this.fireValueChange(Diffs.createValueDiff(oldValue, newValue));
        }
    }

    public void addOption(T value, IObservableValue<Boolean> observable) {
        this.checkRealm();
        Option option = new Option(value, observable);
        this.options.add(option);
        if (this.hasListeners()) {
            observable.addValueChangeListener(this.listener);
            if (Boolean.TRUE.equals(observable.getValue())) {
                this.notifyIfChanged(this.indexOfObservable(observable));
            }
        }
    }

    @Override
    protected T doGetValue() {
        return this.hasListeners() ? this.valueAtIndex(this.selectionIndex) : this.getLiveValue();
    }

    private T getLiveValue() {
        for (Option option : this.options) {
            if (!((Boolean)option.observable.getValue()).booleanValue()) continue;
            return (T)option.value;
        }
        return null;
    }

    @Override
    protected void doSetValue(Object value) {
        int index = this.indexOfValue(value);
        try {
            this.updating = true;
            int i = 0;
            while (i < this.options.size()) {
                this.options.get(i).observable.setValue(i == index);
                ++i;
            }
        }
        finally {
            this.updating = false;
        }
        this.notifyIfChanged(index);
    }

    private T valueAtIndex(int index) {
        if (index == -1) {
            return null;
        }
        return (T)this.options.get(index).value;
    }

    private int indexOfValue(Object value) {
        int i = 0;
        while (i < this.options.size()) {
            if (Util.equals(this.options.get(i).value, value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int indexOfObservable(IObservableValue<? extends Boolean> observable) {
        int i = 0;
        while (i < this.options.size()) {
            if (this.options.get(i).observable == observable) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private class Option {
        private final T value;
        private final IObservableValue<Boolean> observable;

        public Option(T value, IObservableValue<Boolean> observable) {
            this.value = value;
            this.observable = observable;
        }
    }
}

