/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.common;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class QuickFixTestHelper {
    public static List<Issue> extractAllIssuesInLine(int offStartLine, Multimap<Integer, Issue> offset2issue) {
        Functions.Function1 _function = it -> {
            Integer _lineNumber = it.getLineNumber();
            return _lineNumber == offStartLine;
        };
        ArrayList result = CollectionLiterals.newArrayList((Object[])((Issue[])Conversions.unwrapArray((Object)IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)offset2issue.values(), (Functions.Function1)_function)), Issue.class)));
        Comparator _function_1 = (a, b) -> {
            int _xblockexpression = 0;
            Integer _offset = b.getOffset();
            Integer _offset_1 = a.getOffset();
            int first = _offset - _offset_1;
            int _xifexpression = 0;
            _xifexpression = first != 0 ? first : a.getMessage().compareToIgnoreCase(b.getMessage());
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        };
        ListExtensions.sortInplace((List)result, (Comparator)_function_1);
        return result;
    }

    public static List<EObject> elementsInSameLine(ILeafNode offsetNode) {
        INode next;
        ArrayList result = CollectionLiterals.newArrayList();
        int line = offsetNode.getStartLine();
        INode firstNode = null;
        ArrayList nodesInLine = CollectionLiterals.newArrayList();
        BidiTreeIterator iter = offsetNode.getRootNode().getAsTreeIterable().iterator();
        while (firstNode == null && iter.hasNext()) {
            boolean _lessThan;
            next = (INode)iter.next();
            int _endLine = next.getEndLine();
            boolean bl = _lessThan = _endLine < line;
            if (_lessThan) {
                iter.prune();
                continue;
            }
            if (next.getStartLine() < line || !(next instanceof ILeafNode)) continue;
            firstNode = next;
            nodesInLine.add(firstNode);
        }
        while (iter.hasNext()) {
            boolean _greaterThan;
            next = (INode)iter.next();
            int _startLine = next.getStartLine();
            boolean bl = _greaterThan = _startLine > line;
            if (_greaterThan) {
                iter.prune();
                continue;
            }
            if (!(next instanceof ILeafNode)) continue;
            nodesInLine.add(next);
        }
        boolean _isEmpty = nodesInLine.isEmpty();
        if (_isEmpty) {
            return CollectionLiterals.emptyList();
        }
        for (INode ln : nodesInLine) {
            EObject eo = NodeModelUtils.findActualSemanticObjectFor((INode)ln);
            if (eo == null || result.contains(eo)) continue;
            result.add(eo);
        }
        return result;
    }

    public static List<String> separateOnCommaAndQuote(CharSequence line) {
        return QuickFixTestHelper.separateOnComma(line, true);
    }

    public static List<String> separateOnComma(CharSequence line, boolean removeQuote) {
        Functions.Function1 _function = it -> it.trim();
        List result = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)line.toString().split(","))), (Functions.Function1)_function);
        if (removeQuote) {
            Functions.Function1 _function_1 = it -> {
                String _xifexpression = null;
                if (it.startsWith("\"") && it.endsWith("\"") || it.startsWith("'") && it.endsWith("'")) {
                    int _length = it.length();
                    int _minus = _length - 1;
                    _xifexpression = it.substring(1, _minus);
                } else {
                    _xifexpression = it;
                }
                return _xifexpression;
            };
            result = ListExtensions.map((List)result, (Functions.Function1)_function_1);
        }
        return IterableExtensions.toList((Iterable)result);
    }

    public static String asString(List<IssueResolution> resolutions) {
        Functions.Function1 _function = it -> it.getLabel();
        Functions.Function2 _function_1 = (p1, p2) -> "'" + p1 + "', '" + p2 + "'";
        return (String)IterableExtensions.reduce((Iterable)ListExtensions.map(resolutions, (Functions.Function1)_function), (Functions.Function2)_function_1);
    }

    public static String asString2(List<ICompletionProposal> s) {
        Functions.Function1 _function = it -> {
            String _displayString = it.getDisplayString();
            String _plus = "'" + _displayString;
            return String.valueOf(_plus) + "'";
        };
        Functions.Function2 _function_1 = (p1, p2) -> String.valueOf(p1) + ", " + p2;
        return (String)IterableExtensions.reduce((Iterable)ListExtensions.map(s, (Functions.Function1)_function), (Functions.Function2)_function_1);
    }

    public static IssueResolution selectSingleOrFail(List<IssueResolution> resolutions, String labelPart) {
        boolean _lessThan;
        boolean _greaterThan;
        IssueResolution _xblockexpression = null;
        Functions.Function1 _function = it -> it.getLabel().contains(labelPart);
        List matched = IterableExtensions.toList((Iterable)IterableExtensions.filter(resolutions, (Functions.Function1)_function));
        int _size = matched.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            int _size_1 = matched.size();
            String _plus = "The selected issue resolution '" + labelPart + "' is matched by more then one (" + Integer.valueOf(_size_1);
            String _plus_1 = String.valueOf(_plus) + ") resolutions ";
            String _asString = QuickFixTestHelper.asString(matched);
            String _plus_2 = String.valueOf(_plus_1) + _asString;
            throw new AssertionFailedError(_plus_2);
        }
        int _size_2 = matched.size();
        boolean bl2 = _lessThan = _size_2 < 1;
        if (_lessThan) {
            throw new AssertionFailedError("No issue-resolution found with name containing '" + labelPart + "'");
        }
        _xblockexpression = (IssueResolution)IterableExtensions.head((Iterable)matched);
        return _xblockexpression;
    }

    public static ChangeInfo extractSingleChangedLine(String before, String after) {
        String delim = "\n";
        String[] bLines = before.split("\n");
        String[] aLines = after.split("\n");
        ChangeInfo ci = new ChangeInfo();
        int bo = 0;
        int ao = 0;
        int bi = 0;
        int ai = 0;
        boolean _while = bi < bLines.length && ai < aLines.length;
        while (_while) {
            boolean _not;
            String b = bLines[bi];
            String a = aLines[ai];
            boolean _equals = b.trim().equals(a.trim());
            boolean bl = _not = !_equals;
            if (_not) {
                if (ai + 1 < aLines.length && b.trim().equals(aLines[ai + 1].trim())) {
                    ci.add(bi, bo, "", ao, aLines[ai]);
                    int _ao = ao;
                    int _length = aLines[++ai].length();
                    int _length_1 = "\n".length();
                    int _plus = _length + _length_1;
                    ao = _ao + _plus;
                } else if (bi + 1 < bLines.length && bLines[bi + 1].trim().equals(a.trim())) {
                    ci.add(bi, bo, bLines[bi], ao, "");
                    int _bo = bo;
                    int _length_2 = aLines[++bi].length();
                    int _length_3 = "\n".length();
                    int _plus_1 = _length_2 + _length_3;
                    bo = _bo + _plus_1;
                } else {
                    ci.add(bi, bo, bLines[bi], ao, aLines[ai]);
                }
            }
            int _ao_1 = ao;
            int _length_4 = aLines[ai].length();
            int _length_5 = "\n".length();
            int _plus_2 = _length_4 + _length_5;
            ao = _ao_1 + _plus_2;
            int _bo_1 = bo;
            int _length_6 = bLines[bi].length();
            int _length_7 = "\n".length();
            int _plus_3 = _length_6 + _length_7;
            bo = _bo_1 + _plus_3;
            boolean bl2 = _while = ++bi < bLines.length && ++ai < aLines.length;
        }
        return ci;
    }

    public static class ChangeInfo {
        private final List<ChangedLine> changes = CollectionLiterals.newArrayList();

        public boolean add(int n, int beforeOffset, String b, int afterOffset, String a) {
            ChangedLine _changedLine = new ChangedLine(n, beforeOffset, b, afterOffset, a);
            return this.changes.add(_changedLine);
        }

        public String asString() {
            Functions.Function1 _function = it -> "L:" + Integer.valueOf(((ChangedLine)it).lineNumber) + " '" + ((ChangedLine)it).after + "'\n";
            Functions.Function2 _function_1 = (p1, p2) -> String.valueOf(p1) + p2;
            return (String)IterableExtensions.reduce((Iterable)ListExtensions.map(this.changes, (Functions.Function1)_function), (Functions.Function2)_function_1);
        }

        public boolean isMoreThanOne() {
            int _size = this.changes.size();
            return _size > 1;
        }

        public boolean isEmpty() {
            return this.changes.isEmpty();
        }

        public ChangedLine first() {
            return this.changes.get(0);
        }

        public ChangedLine get(int i) {
            return this.changes.get(i);
        }

        public int size() {
            return this.changes.size();
        }

        @Accessors
        public static class ChangedLine {
            private final int lineNumber;
            private final int beforeOffset;
            private final String before;
            private final int afterOffset;
            private final String after;

            public String toString() {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("L:");
                _builder.append((Object)this.lineNumber);
                _builder.append("[");
                _builder.append(this.before);
                _builder.append("|");
                _builder.append(this.after);
                _builder.append("]");
                return _builder.toString();
            }

            public ChangedLine(int lineNumber, int beforeOffset, String before, int afterOffset, String after) {
                this.lineNumber = lineNumber;
                this.beforeOffset = beforeOffset;
                this.before = before;
                this.afterOffset = afterOffset;
                this.after = after;
            }

            @Pure
            public int getLineNumber() {
                return this.lineNumber;
            }

            @Pure
            public int getBeforeOffset() {
                return this.beforeOffset;
            }

            @Pure
            public String getBefore() {
                return this.before;
            }

            @Pure
            public int getAfterOffset() {
                return this.afterOffset;
            }

            @Pure
            public String getAfter() {
                return this.after;
            }
        }
    }
}

