/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.quickfix.packagejson;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.n4js.external.ExternalIndexSynchronizer;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.LibraryManager;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.dependencies.ProjectDependenciesHelper;
import org.eclipse.n4js.semver.Semver.NPMVersionRequirement;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.semver.SemverHelper;
import org.eclipse.n4js.semver.SemverMatcher;
import org.eclipse.n4js.ui.changes.IAtomicChange;
import org.eclipse.n4js.ui.changes.IChange;
import org.eclipse.n4js.ui.changes.PackageJsonChangeProvider;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.n4js.ui.quickfix.AbstractN4JSQuickfixProvider;
import org.eclipse.n4js.ui.quickfix.N4Modification;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.n4js.utils.StatusHelper;
import org.eclipse.n4js.utils.StatusUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.Fixes;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

public class N4JSPackageJsonQuickfixProviderExtension
extends AbstractN4JSQuickfixProvider {
    @Inject
    private ExternalLibraryWorkspace extWS;
    @Inject
    private LibraryManager libraryManager;
    @Inject
    private ExternalIndexSynchronizer indexSynchronizer;
    @Inject
    private ProjectDependenciesHelper dependenciesHelper;
    @Inject
    private SemverHelper semverHelper;
    @Inject
    private StatusHelper statusHelper;

    @Fixes(value={@Fix(value="NON_EXISTING_PROJECT"), @Fix(value="NO_MATCHING_VERSION")})
    public void installMissingNPM(Issue issue, IssueResolutionAcceptor acceptor) {
        String[] userData = issue.getData();
        final String packageName = userData[0];
        final String versionRequirement = userData[1];
        String msgAtVersion = Strings.isNullOrEmpty((String)versionRequirement) ? "" : "@" + versionRequirement;
        final String label = "Install/update npm " + packageName + msgAtVersion;
        String description = "Calls npm to install the missing npm package into the workspace.";
        final String errMsg = "Error while uninstalling npm dependency: '" + packageName + "'.";
        N4Modification modification = new N4Modification(){

            @Override
            public boolean supportsMultiApply() {
                return true;
            }

            @Override
            public boolean isApplicableTo(IMarker marker) {
                return true;
            }

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                Function<IProgressMonitor, IStatus> registerFunction = new Function<IProgressMonitor, IStatus>(){

                    @Override
                    public IStatus apply(IProgressMonitor monitor) {
                        HashMap<String, NPMVersionRequirement> installedNpms = new HashMap<String, NPMVersionRequirement>();
                        NPMVersionRequirement versionReq = N4JSPackageJsonQuickfixProviderExtension.this.semverHelper.parse(versionRequirement);
                        installedNpms.put(packageName, versionReq);
                        N4JSPackageJsonQuickfixProviderExtension.this.dependenciesHelper.fixDependenciesToInstall(installedNpms);
                        return N4JSPackageJsonQuickfixProviderExtension.this.libraryManager.installNPM(packageName, versionRequirement, monitor);
                    }
                };
                N4JSPackageJsonQuickfixProviderExtension.this.wrapWithMonitor(label, errMsg, registerFunction);
                return Collections.emptyList();
            }
        };
        this.accept(acceptor, issue, label, "Calls npm to install the missing npm package into the workspace.", null, modification);
    }

    @Fixes(value={@Fix(value="NON_EXISTING_PROJECT"), @Fix(value="NO_MATCHING_VERSION")})
    public void installAllMissingNPMs(Issue issue, IssueResolutionAcceptor acceptor) {
        String label = "Install/update all missing npm(s)";
        String description = "Retrieves npms from all dependency sections of all projects and installs those that are not installed yet.";
        String errMsg = "Error while installing npms";
        N4Modification modification = new N4Modification(){

            @Override
            public boolean supportsMultiApply() {
                return false;
            }

            @Override
            public boolean isApplicableTo(IMarker marker) {
                return true;
            }

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                Function<IProgressMonitor, IStatus> registerFunction = new Function<IProgressMonitor, IStatus>(){

                    @Override
                    public IStatus apply(IProgressMonitor monitor) {
                        Map installedNpms = N4JSPackageJsonQuickfixProviderExtension.this.extWS.getProjectNameVersionMap();
                        Map reqNpms = N4JSPackageJsonQuickfixProviderExtension.this.dependenciesHelper.computeDependenciesOfWorkspace();
                        N4JSPackageJsonQuickfixProviderExtension.this.dependenciesHelper.fixDependenciesToInstall(reqNpms);
                        Iterator npmNameIter = reqNpms.keySet().iterator();
                        while (npmNameIter.hasNext()) {
                            String npmName = (String)npmNameIter.next();
                            if (!installedNpms.containsKey(npmName)) continue;
                            NPMVersionRequirement npmVersionRequirement = (NPMVersionRequirement)reqNpms.get(npmName);
                            VersionNumber installedVersion = (VersionNumber)installedNpms.get(npmName);
                            boolean matches = SemverMatcher.matches((VersionNumber)installedVersion, (NPMVersionRequirement)npmVersionRequirement);
                            if (!matches) continue;
                            npmNameIter.remove();
                        }
                        return N4JSPackageJsonQuickfixProviderExtension.this.libraryManager.installNPMs(reqNpms, false, monitor);
                    }
                };
                N4JSPackageJsonQuickfixProviderExtension.this.wrapWithMonitor("Install/update all missing npm(s)", "Error while installing npms", registerFunction);
                return Collections.emptyList();
            }
        };
        this.accept(acceptor, issue, "Install/update all missing npm(s)", "Retrieves npms from all dependency sections of all projects and installs those that are not installed yet.", null, modification);
    }

    @Fix(value="NON_REGISTERED_PROJECT")
    public void registerNPMs(Issue issue, IssueResolutionAcceptor acceptor) {
        String label = "Register npm(s)";
        String description = "Registers all not registered npms so that they can be imported by modules.";
        N4Modification modification = new N4Modification(){

            @Override
            public boolean supportsMultiApply() {
                return true;
            }

            @Override
            public boolean isApplicableTo(IMarker marker) {
                return true;
            }

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                Function<IProgressMonitor, IStatus> registerFunction = new Function<IProgressMonitor, IStatus>(){

                    @Override
                    public IStatus apply(IProgressMonitor monitor) {
                        N4JSPackageJsonQuickfixProviderExtension.this.indexSynchronizer.synchronizeNpms(monitor);
                        return N4JSPackageJsonQuickfixProviderExtension.this.statusHelper.OK();
                    }
                };
                N4JSPackageJsonQuickfixProviderExtension.this.wrapWithMonitor("Register npm(s)", "Error during registering of npm(s)", registerFunction);
                return Collections.emptyList();
            }
        };
        this.accept(acceptor, issue, "Register npm(s)", "Registers all not registered npms so that they can be imported by modules.", null, modification);
    }

    @Fix(value="OUTPUT_AND_SOURCES_FOLDER_NESTING")
    public void changeProjectTypeToValidation(Issue issue, IssueResolutionAcceptor acceptor) {
        String validationPT = ProjectType.VALIDATION.getName().toLowerCase();
        String title = "Change project type to '" + validationPT + "'";
        String descr = "The project type '" + validationPT + "' does not generate code. Hence, output and source folders can be nested.";
        this.accept(acceptor, issue, title, descr, null, new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                Resource resource = element.eResource();
                ProjectDescription prjDescr = (ProjectDescription)EcoreUtil2.getContainerOfType((EObject)element, ProjectDescription.class);
                LinkedList<IAtomicChange> changes = new LinkedList<IAtomicChange>();
                changes.add(PackageJsonChangeProvider.setProjectType(resource, ProjectType.VALIDATION, prjDescr));
                return changes;
            }

            @Override
            public boolean supportsMultiApply() {
                return false;
            }

            @Override
            public boolean isApplicableTo(IMarker marker) {
                return true;
            }
        });
    }

    private Collection<? extends IChange> wrapWithMonitor(final String msg, final String errMsg, final Function<IProgressMonitor, IStatus> f) throws Exception {
        final MultiStatus multiStatus = this.statusHelper.createMultiStatus(msg);
        new ProgressMonitorDialog(UIUtils.getShell()).run(true, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IStatus status = (IStatus)f.apply(monitor);
                    multiStatus.merge(status);
                }
                catch (Exception e) {
                    multiStatus.merge(N4JSPackageJsonQuickfixProviderExtension.this.statusHelper.createError(errMsg, (Throwable)e));
                }
            }
        });
        if (!multiStatus.isOK()) {
            N4JSActivator.getInstance().getLog().log((IStatus)multiStatus);
            UIUtils.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    String title = "Failed: " + msg;
                    String descr = StatusUtils.getErrorMessage((IStatus)multiStatus, (boolean)true);
                    ErrorDialog.openError((Shell)UIUtils.getShell(), (String)title, (String)descr, (IStatus)multiStatus);
                }
            });
        }
        return Collections.emptyList();
    }
}

