/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.registry;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.LinkedKeyBinding;
import java.lang.annotation.Annotation;
import org.eclipse.xpect.registry.DefaultBinding;

public abstract class AbstractDelegatingModule
implements Module {
    @Inject
    private Injector original;

    public Injector getOriginal() {
        return this.original;
    }

    protected <T> void overrideAndBackup(Binder binder, Class<T> key, Class<? extends T> impl) {
        binder.bind(key).to(impl);
        Class<T> original = this.getOriginalType(Key.get(key));
        if (original != null) {
            binder.bind(key).annotatedWith(DefaultBinding.class).to(original);
        }
    }

    protected <T> void overrideAndBackup(Binder binder, Class<T> key, Class<? extends Annotation> annotation, Class<? extends T> impl) {
        binder.bind(key).annotatedWith(annotation).to(impl);
        Class<T> original = this.getOriginalType(Key.get(key, annotation));
        if (original != null) {
            binder.bind(key).annotatedWith(DefaultBinding.class).to(original);
        }
    }

    protected <T> Class<? extends T> getOriginalType(Key<T> type) {
        try {
            Binding binding = this.original.getBinding(type);
            if (binding instanceof LinkedKeyBinding) {
                return ((LinkedKeyBinding)binding).getLinkedKey().getTypeLiteral().getRawType();
            }
            if (binding instanceof ConstructorBinding) {
                return ((ConstructorBinding)binding).getConstructor().getDeclaringType().getRawType();
            }
        }
        catch (ConfigurationException configurationException) {}
        return null;
    }
}

