/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec.adoc;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.n4js.jsdoc2spec.CopyrightHeader;
import org.eclipse.n4js.jsdoc2spec.SpecFile;
import org.eclipse.n4js.jsdoc2spec.adoc.IndexEntry;
import org.eclipse.n4js.jsdoc2spec.adoc.IndexFileWriter;
import org.eclipse.n4js.jsdoc2spec.adoc.PDFContentFileWriter;
import org.eclipse.n4js.jsdoc2spec.adoc.SourceEntry;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecIdentifiableElementSection;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecModuleFile;
import org.eclipse.n4js.jsdoc2spec.adoc.WebContentFileWriter;

class IndicesCreator {
    IndicesCreator() {
    }

    static List<SpecFile> createIndexFiles(File rootDir, Collection<SpecFile> specChangeSet) throws UnsupportedEncodingException {
        String crh = CopyrightHeader.readDefault(rootDir.toPath());
        CopyrightHeader.set(crh);
        ArrayList<IndexEntry> entries = IndicesCreator.getIndexEntries(specChangeSet);
        Collections.sort(entries);
        ArrayList<SpecFile> indexFiles = new ArrayList<SpecFile>();
        IndexFileWriter iFW = new IndexFileWriter();
        iFW.serialize((ArrayList)entries);
        indexFiles.add(iFW.getSpecFile(rootDir));
        PDFContentFileWriter pdfFW = new PDFContentFileWriter();
        pdfFW.serialize(entries);
        indexFiles.add(pdfFW.getSpecFile(rootDir));
        WebContentFileWriter webFW = new WebContentFileWriter();
        webFW.serialize(entries);
        indexFiles.addAll(webFW.getSpecFiles(rootDir));
        return indexFiles;
    }

    private static ArrayList<IndexEntry> getIndexEntries(Collection<SpecFile> specFiles) {
        ArrayList<IndexEntry> entries = new ArrayList<IndexEntry>();
        for (SpecFile specFile : specFiles) {
            if (!(specFile instanceof SpecModuleFile)) continue;
            SpecModuleFile smf = (SpecModuleFile)specFile;
            for (SpecIdentifiableElementSection specIE : smf.getSpecSections()) {
                SourceEntry pc = specIE.getSourceEntry();
                int offsetStart = specFile.getOffsetStart(specIE);
                int offsetEnd = specFile.getOffsetEnd(specIE);
                if (pc == null) {
                    pc = specIE.getSourceEntry();
                }
                IndexEntry ie = new IndexEntry(pc, offsetStart, offsetEnd);
                entries.add(ie);
            }
        }
        return entries;
    }
}

