/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.internal;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.n4js.ui.resource.IResourceDescriptionPersisterContribution;
import org.eclipse.xtext.builder.builderState.EMFBasedPersister;

@Singleton
public class ContributingResourceDescriptionPersister
extends EMFBasedPersister {
    private static final Logger LOGGER = Logger.getLogger(ContributingResourceDescriptionPersister.class);
    private final Supplier<Iterable<IResourceDescriptionPersisterContribution>> contributionsSupplier = Suppliers.memoize(() -> this.getContributions());
    private final AtomicBoolean requiresRecoveryBuild = new AtomicBoolean(false);

    protected void scheduleRecoveryBuild() {
        this.requiresRecoveryBuild.compareAndSet(false, true);
    }

    public void scheduleRecoveryBuildOnContributions() {
        for (IResourceDescriptionPersisterContribution contribution : (Iterable)this.contributionsSupplier.get()) {
            contribution.scheduleRecoveryBuild();
        }
    }

    public boolean isRecoveryBuildRequired() {
        return this.requiresRecoveryBuild.get();
    }

    private Iterable<IResourceDescriptionPersisterContribution> getContributions() {
        return FluentIterable.from(Arrays.asList(Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.n4js.ui.resourceDescriptionsPersisterContribution"))).transform(config -> this.createInstance((IConfigurationElement)config)).filter(elem -> elem != null);
    }

    private IResourceDescriptionPersisterContribution createInstance(IConfigurationElement config) {
        try {
            Object extension = config.createExecutableExtension("class");
            if (extension instanceof IResourceDescriptionPersisterContribution) {
                IResourceDescriptionPersisterContribution contribution = (IResourceDescriptionPersisterContribution)extension;
                return contribution;
            }
            String message = "Expected persister contribution type. Was: " + extension;
            LOGGER.error((Object)message);
            throw new IllegalStateException(message);
        }
        catch (CoreException e) {
            String message = "Error while instantiating contribution.";
            LOGGER.error((Object)"Error while instantiating contribution.", (Throwable)e);
            throw new RuntimeException("Error while instantiating contribution.", e);
        }
    }
}

