/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.resource;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.n4js.conversion.AbstractN4JSStringValueConverter;
import org.eclipse.n4js.conversion.N4JSValueConverterException;
import org.eclipse.n4js.conversion.N4JSValueConverterWithValueException;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.JSXPropertyAttribute;
import org.eclipse.n4js.n4JS.LabelRef;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.resource.N4JSPreProcessor;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.scoping.members.ComposedMemberScope;
import org.eclipse.n4js.validation.ASTStructureValidator;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.diagnostics.IDiagnosticProducer;
import org.eclipse.xtext.linking.impl.ImportedNamesAdapter;
import org.eclipse.xtext.linking.impl.LinkingDiagnosticProducer;
import org.eclipse.xtext.linking.lazy.LazyLinker;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class N4JSLinker
extends LazyLinker {
    public static final char N4JS_CROSSREF_DELIM = '|';
    @Inject
    private IValueConverterService valueConverterService;
    @Inject
    private ASTStructureValidator structureValidator;
    @Inject
    private N4JSPreProcessor preProcessor;

    protected void doLinkModel(final EObject model, final IDiagnosticConsumer consumer) {
        final LinkingDiagnosticProducer producer = new LinkingDiagnosticProducer(consumer);
        this.getCache().execWithoutCacheClear((Resource)((N4JSResource)model.eResource()), (IUnitOfWork)new IUnitOfWork.Void<N4JSResource>(){

            public void process(N4JSResource resource) throws Exception {
                resource.clearLazyProxyInformation();
                N4JSLinker.this.clearReferences(model);
                N4JSLinker.this.installProxies(resource, model, (IDiagnosticProducer)producer);
                TreeIterator iterator = model.eAllContents();
                while (iterator.hasNext()) {
                    EObject eObject = (EObject)iterator.next();
                    N4JSLinker.this.clearReferences(eObject);
                    N4JSLinker.this.installProxies(resource, eObject, (IDiagnosticProducer)producer);
                }
                N4JSLinker.this.preProcessor.process(resource.getScript(), resource);
                if (!resource.isValidationDisabled()) {
                    N4JSLinker.this.getStructureValidator().validate(model, consumer);
                }
            }
        });
    }

    private ASTStructureValidator getStructureValidator() {
        return this.structureValidator;
    }

    private void installProxies(N4JSResource resource, EObject obj, IDiagnosticProducer producer) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)obj);
        if (node == null) {
            return;
        }
        this.installProxies(resource, obj, producer, node, false);
    }

    private void installProxies(N4JSResource resource, EObject obj, IDiagnosticProducer producer, ICompositeNode parentNode, boolean dontCheckParent) {
        EClass eClass = obj.eClass();
        if (eClass.getEAllReferences().size() - eClass.getEAllContainments().size() == 0) {
            return;
        }
        INode node = parentNode.getFirstChild();
        while (node != null) {
            RuleCall ruleCall;
            AbstractRule calledRule;
            EObject grammarElement = node.getGrammarElement();
            if (grammarElement instanceof CrossReference && this.hasLeafNodes(node)) {
                producer.setNode(node);
                CrossReference crossReference = (CrossReference)grammarElement;
                EReference eRef = GrammarUtil.getReference((CrossReference)crossReference, (EClass)eClass);
                if (eRef == null) {
                    ParserRule parserRule = GrammarUtil.containingParserRule((EObject)crossReference);
                    String feature = GrammarUtil.containingAssignment((EObject)crossReference).getFeature();
                    throw new IllegalStateException("Couldn't find EReference for crossreference '" + eClass.getName() + "::" + feature + "' in parser rule '" + parserRule.getName() + "'.");
                }
                this.createAndSetProxy(resource, obj, node, eRef, crossReference, producer);
                this.afterCreateAndSetProxy(obj, node, eRef, crossReference, producer);
            } else if (grammarElement instanceof RuleCall && node instanceof ICompositeNode && (calledRule = (ruleCall = (RuleCall)grammarElement).getRule()) instanceof ParserRule && ((ParserRule)calledRule).isFragment()) {
                this.installProxies(resource, obj, producer, (ICompositeNode)node, true);
            }
            node = node.getNextSibling();
        }
        if (!dontCheckParent && this.shouldCheckParentNode((INode)parentNode)) {
            this.installProxies(resource, obj, producer, parentNode.getParent(), dontCheckParent);
        }
    }

    protected boolean shouldCheckParentNode(INode node) {
        ICompositeNode parent;
        EObject grammarElement = node.getGrammarElement();
        if (grammarElement instanceof AbstractElement && (parent = node.getParent()) != null) {
            ParserRule rule;
            Assignment assignment;
            if (!parent.hasDirectSemanticElement() && (assignment = GrammarUtil.containingAssignment((EObject)grammarElement)) == null) {
                ParserRule rule2 = (ParserRule)GrammarUtil.containingRule((EObject)grammarElement);
                return !rule2.isFragment();
            }
            if (grammarElement instanceof Action && (rule = (ParserRule)GrammarUtil.containingRule((EObject)grammarElement)).isFragment()) {
                return parent.getGrammarElement() instanceof RuleCall;
            }
        }
        return false;
    }

    private void createAndSetProxy(N4JSResource resource, EObject obj, INode node, EReference eRef, CrossReference xref, IDiagnosticProducer diagnosticProducer) {
        EObject proxy = this.createProxy(resource, obj, node, eRef, xref, diagnosticProducer);
        proxy.eSetDeliver(false);
        if (eRef.isMany()) {
            ((InternalEList)obj.eGet((EStructuralFeature)eRef, false)).addUnique((Object)proxy);
        } else {
            obj.eSet((EStructuralFeature)eRef, (Object)proxy);
        }
    }

    private EObject createProxy(N4JSResource resource, EObject obj, INode node, EReference eRef, CrossReference xref, IDiagnosticProducer diagnosticProducer) {
        URI uri = resource.getURI();
        int fragmentNumber = resource.addLazyProxyInformation(obj, eRef, node);
        URI encodedLink = uri.appendFragment("|" + fragmentNumber);
        EClass referenceType = this.findInstantiableCompatible(eRef.getEReferenceType());
        EObject proxy = EcoreUtil.create((EClass)referenceType);
        ((InternalEObject)proxy).eSetProxyURI(encodedLink);
        AbstractElement terminal = xref.getTerminal();
        if (!(terminal instanceof RuleCall)) {
            throw new IllegalArgumentException(String.valueOf(xref));
        }
        AbstractRule rule = ((RuleCall)terminal).getRule();
        try {
            String tokenText = NodeModelUtils.getTokenText((INode)node);
            Object value = this.valueConverterService.toValue(tokenText, rule.getName(), node);
            if (obj instanceof IdentifierRef && value instanceof String) {
                ((IdentifierRef)obj).setIdAsText((String)value);
            } else if (obj instanceof LabelRef && value instanceof String) {
                ((LabelRef)obj).setLabelAsText((String)value);
            } else if (obj instanceof ParameterizedPropertyAccessExpression && value instanceof String) {
                ((ParameterizedPropertyAccessExpression)obj).setPropertyAsText((String)value);
            } else if (obj instanceof NamedImportSpecifier && value instanceof String) {
                ((NamedImportSpecifier)obj).setImportedElementAsText((String)value);
            } else if (obj instanceof JSXPropertyAttribute && value instanceof String) {
                ((JSXPropertyAttribute)obj).setPropertyAsText((String)value);
            } else {
                this.setOtherElementAsText(tokenText, obj, value);
            }
        }
        catch (AbstractN4JSStringValueConverter.BadEscapementException e) {
            diagnosticProducer.addDiagnostic(new DiagnosticMessage(e.getMessage(), e.getSeverity(), e.getIssueCode(), Strings.EMPTY_ARRAY));
        }
        catch (N4JSValueConverterException vce) {
            diagnosticProducer.addDiagnostic(new DiagnosticMessage(vce.getMessage(), vce.getSeverity(), vce.getIssueCode(), Strings.EMPTY_ARRAY));
        }
        catch (N4JSValueConverterWithValueException vcwve) {
            diagnosticProducer.addDiagnostic(new DiagnosticMessage(vcwve.getMessage(), vcwve.getSeverity(), vcwve.getIssueCode(), Strings.EMPTY_ARRAY));
        }
        return proxy;
    }

    protected void setOtherElementAsText(String tokenText, EObject obj, Object value) {
    }

    protected void clearReferences(EObject obj) {
        super.clearReferences(obj);
        if (obj instanceof Script) {
            ((Script)obj).setFlaggedUsageMarkingFinished(false);
        } else if (obj instanceof ImportSpecifier) {
            ImportSpecifier specifier = (ImportSpecifier)obj;
            specifier.setFlaggedUsedInCode(false);
        } else if (obj instanceof NamedImportSpecifier) {
            ((NamedImportSpecifier)obj).setImportedElementAsText(null);
        } else if (obj instanceof IdentifierRef) {
            ((IdentifierRef)obj).setIdAsText(null);
        } else if (obj instanceof LabelRef) {
            ((LabelRef)obj).setLabelAsText(null);
        } else if (obj instanceof ParameterizedPropertyAccessExpression) {
            ((ParameterizedPropertyAccessExpression)obj).setPropertyAsText(null);
        }
    }

    protected void beforeModelLinked(EObject model, IDiagnosticConsumer diagnosticsConsumer) {
        ImportedNamesAdapter adapter = ImportedNamesAdapter.find((Resource)model.eResource());
        if (adapter != null) {
            adapter.clear();
        }
        ComposedMemberScope.clearCachedComposedMembers(model);
    }

    protected boolean hasLeafNodes(INode node) {
        if (node.getTotalLength() > 0) {
            return true;
        }
        if (node instanceof ICompositeNode) {
            return ((ICompositeNode)node).getLastChild() instanceof ILeafNode;
        }
        return false;
    }

    protected EClass findInstantiableCompatible(EClass eType) {
        if (!this.isInstantiatableSubType(eType, eType)) {
            throw new IllegalStateException(String.valueOf(eType));
        }
        return eType;
    }

    private boolean isInstantiatableSubType(EClass c, EClass superType) {
        return !c.isAbstract() && !c.isInterface() && EcoreUtil2.isAssignableFrom((EClass)superType, (EClass)c);
    }
}

