/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.dataflow.guards;

import java.math.BigDecimal;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.dataflow.FlowAssertionFactory;
import org.eclipse.n4js.flowgraphs.dataflow.guards.Guard;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardAssertion;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardType;
import org.eclipse.n4js.flowgraphs.dataflow.guards.InstanceofGuard;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.SymbolFactory;
import org.eclipse.n4js.n4JS.BinaryLogicalExpression;
import org.eclipse.n4js.n4JS.ConditionalExpression;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.EqualityExpression;
import org.eclipse.n4js.n4JS.EqualityOperator;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.IntLiteral;
import org.eclipse.n4js.n4JS.NullLiteral;
import org.eclipse.n4js.n4JS.NumericLiteral;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.RelationalExpression;
import org.eclipse.n4js.n4JS.RelationalOperator;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.UnaryOperator;
import org.eclipse.n4js.ts.types.IdentifiableElement;

public class GuardFactory {
    static Guard create(EObject topContainer, Expression expr, boolean negateTree) {
        if (expr instanceof EqualityExpression) {
            boolean sameEqualNot;
            EqualityExpression eqe = (EqualityExpression)expr;
            EqualityOperator operation = eqe.getOp();
            boolean sameEqual = operation == EqualityOperator.EQ || operation == EqualityOperator.SAME;
            boolean bl = sameEqualNot = operation == EqualityOperator.NEQ || operation == EqualityOperator.NSAME;
            if (sameEqual || sameEqualNot) {
                return GuardFactory.createGuardForEquality(topContainer, negateTree, eqe, sameEqualNot);
            }
        } else if (expr instanceof RelationalExpression) {
            RelationalExpression re = (RelationalExpression)expr;
            if (re.getOp() == RelationalOperator.INSTANCEOF) {
                return GuardFactory.createGuardForInstanceof(topContainer, negateTree, re);
            }
        } else if (!(expr instanceof ParameterizedCallExpression)) {
            return GuardFactory.createGuardForTruthy(topContainer, expr, negateTree);
        }
        return null;
    }

    private static Guard createGuardForInstanceof(EObject topContainer, boolean negateTree, RelationalExpression re) {
        Expression lhs = re.getLhs();
        Expression rhs = re.getRhs();
        if (SymbolFactory.canCreate((ControlFlowElement)lhs)) {
            GuardAssertion asserts = FlowAssertionFactory.getGuard(topContainer, (EObject)re, negateTree, false);
            Guard guard = GuardFactory.createIsZeroGuard((Expression)re, asserts, lhs, rhs);
            return guard;
        }
        return null;
    }

    private static Guard createGuardForTruthy(EObject topContainer, Expression expr, boolean negateTree) {
        if (SymbolFactory.canCreate((ControlFlowElement)expr)) {
            EObject parent = expr.eContainer();
            boolean isTruthy = false;
            isTruthy |= parent instanceof Statement;
            isTruthy |= parent instanceof ParenExpression;
            isTruthy |= parent instanceof ConditionalExpression;
            isTruthy |= parent instanceof BinaryLogicalExpression;
            if (isTruthy |= parent instanceof UnaryExpression && ((UnaryExpression)parent).getOp() == UnaryOperator.NOT) {
                GuardAssertion asserts = FlowAssertionFactory.getGuard(topContainer, (EObject)expr, negateTree, false);
                Guard guard = GuardFactory.createIsTruthyGuard(expr, asserts);
                return guard;
            }
        }
        return null;
    }

    private static Guard createGuardForEquality(EObject topContainer, boolean negateTree, EqualityExpression eqe, boolean sameEqualNot) {
        UnaryOperator ruo;
        Expression lhs = eqe.getLhs();
        Expression rhs = eqe.getRhs();
        UnaryOperator luo = lhs instanceof UnaryExpression ? ((UnaryExpression)lhs).getOp() : null;
        UnaryOperator unaryOperator = ruo = rhs instanceof UnaryExpression ? ((UnaryExpression)rhs).getOp() : null;
        if (luo == UnaryOperator.TYPEOF) {
            return GuardFactory.createGuardForTypeof(topContainer, (UnaryExpression)lhs, negateTree, sameEqualNot, rhs);
        }
        if (ruo == UnaryOperator.TYPEOF) {
            return GuardFactory.createGuardForTypeof(topContainer, (UnaryExpression)rhs, negateTree, sameEqualNot, lhs);
        }
        if (luo == UnaryOperator.VOID && SymbolFactory.canCreate((ControlFlowElement)rhs)) {
            return GuardFactory.createGuardForVoid(topContainer, (UnaryExpression)lhs, negateTree, sameEqualNot, rhs);
        }
        if (ruo == UnaryOperator.VOID && SymbolFactory.canCreate((ControlFlowElement)lhs)) {
            return GuardFactory.createGuardForVoid(topContainer, (UnaryExpression)rhs, negateTree, sameEqualNot, lhs);
        }
        if (SymbolFactory.canCreate((ControlFlowElement)lhs) && SymbolFactory.canCreate((ControlFlowElement)rhs)) {
            GuardType guardType = GuardFactory.getGuardType(lhs);
            Expression symbolExpr = rhs;
            if (guardType == null) {
                guardType = GuardFactory.getGuardType(rhs);
                symbolExpr = lhs;
            }
            if (guardType != null) {
                return GuardFactory.createGuardForNUZ(topContainer, (Expression)eqe, negateTree, sameEqualNot, guardType, symbolExpr);
            }
        }
        return null;
    }

    private static Guard createGuardForNUZ(EObject topContainer, Expression eqe, boolean negateTree, boolean negateEqe, GuardType guardType, Expression symbolExpr) {
        GuardAssertion asserts = FlowAssertionFactory.getGuard(topContainer, (EObject)eqe, negateTree, negateEqe);
        switch (guardType) {
            case IsNull: {
                return GuardFactory.createIsNullGuard(eqe, asserts, symbolExpr);
            }
            case IsUndefined: {
                return GuardFactory.createIsUndefinedGuard(eqe, asserts, symbolExpr);
            }
            case IsZero: {
                return GuardFactory.createIsZeroGuard(eqe, asserts, symbolExpr);
            }
        }
        return null;
    }

    private static GuardType getGuardType(Expression nuz) {
        IdentifiableElement id;
        if (nuz instanceof NullLiteral) {
            return GuardType.IsNull;
        }
        if (nuz instanceof IdentifierRef && (id = ((IdentifierRef)nuz).getId()) != null && "undefined".equals(id.getName())) {
            return GuardType.IsUndefined;
        }
        if (nuz instanceof IntLiteral && new BigDecimal(0).equals(((NumericLiteral)nuz).getValue())) {
            return GuardType.IsZero;
        }
        return null;
    }

    private static Guard createGuardForTypeof(EObject topContainer, UnaryExpression ue, boolean negateTree, boolean negateEqe, Expression rhs) {
        StringLiteral rhsStringLit;
        String lit;
        if (rhs instanceof StringLiteral && !"undefined".equals(lit = (rhsStringLit = (StringLiteral)rhs).getValue())) {
            return null;
        }
        Expression typeofExpr = ue.getExpression();
        if (SymbolFactory.canCreate((ControlFlowElement)typeofExpr)) {
            GuardAssertion asserts = FlowAssertionFactory.getGuard(topContainer, ue.eContainer(), negateTree, negateEqe);
            Guard guard = GuardFactory.createIsUndefinedGuard((Expression)ue, asserts, typeofExpr);
            return guard;
        }
        return null;
    }

    private static Guard createGuardForVoid(EObject topContainer, UnaryExpression ue, boolean negateTree, boolean negateEqe, Expression symbolExpr) {
        NumericLiteral nl;
        String numVal;
        Expression voidExpr = ue.getExpression();
        if (voidExpr instanceof NumericLiteral && !"0".equals(numVal = (nl = (NumericLiteral)voidExpr).getValueAsString())) {
            return null;
        }
        GuardAssertion asserts = FlowAssertionFactory.getGuard(topContainer, ue.eContainer(), negateTree, negateEqe);
        Guard guard = GuardFactory.createIsUndefinedGuard((Expression)ue, asserts, symbolExpr);
        return guard;
    }

    private static Guard createIsNullGuard(Expression expr, GuardAssertion asserts, Expression symoblExpr) {
        return new Guard(expr, GuardType.IsNull, asserts, (ControlFlowElement)symoblExpr);
    }

    private static Guard createIsTruthyGuard(Expression expr, GuardAssertion asserts) {
        return new Guard(expr, GuardType.IsTruthy, asserts, (ControlFlowElement)expr);
    }

    private static Guard createIsUndefinedGuard(Expression expr, GuardAssertion asserts, Expression symoblExpr) {
        return new Guard(expr, GuardType.IsUndefined, asserts, (ControlFlowElement)symoblExpr);
    }

    private static Guard createIsZeroGuard(Expression expr, GuardAssertion asserts, Expression symoblExpr) {
        return new Guard(expr, GuardType.IsZero, asserts, (ControlFlowElement)symoblExpr);
    }

    private static Guard createIsZeroGuard(Expression expr, GuardAssertion asserts, Expression symoblExpr, Expression typeIdentifier) {
        return new InstanceofGuard(expr, asserts, (ControlFlowElement)symoblExpr, typeIdentifier);
    }
}

