/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.generator.headless;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.generator.headless.N4JSProjectComparator;
import org.eclipse.n4js.generator.headless.N4ProgressStateRecorder;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;

class MarkedProject {
    final IN4JSProject project;
    final Set<IN4JSProject> markers = new TreeSet<IN4JSProject>(N4JSProjectComparator.INSTANCE);
    final Set<Resource> resources = new LinkedHashSet<Resource>();
    final Set<Resource> externalResources = new HashSet<Resource>();
    final Set<Resource> testResources = new HashSet<Resource>();

    public MarkedProject(IN4JSProject project) {
        this.project = project;
    }

    public boolean isExternal(Resource resource) {
        return this.externalResources.contains(resource);
    }

    public boolean isTest(Resource resource) {
        return this.testResources.contains(resource);
    }

    public void markWith(IN4JSProject marker) {
        this.markers.add(marker);
    }

    public boolean hasMarker(IN4JSProject marker) {
        return this.markers.contains(marker);
    }

    public boolean hasMarkers() {
        return !this.markers.isEmpty();
    }

    public boolean remove(IN4JSProject marker) {
        return this.markers.remove(marker);
    }

    public void unload(ResourceSet resourceSet, N4ProgressStateRecorder recorder) {
        recorder.markStartUnloading(this);
        ResourceDescriptionsData index = ResourceDescriptionsData.ResourceSetAdapter.findResourceDescriptionsData((ResourceSet)resourceSet);
        this.unloadResources(resourceSet, index, recorder);
        this.unloadManifestResource(resourceSet, index, recorder);
        this.clearResources();
        recorder.markFinishedUnloading(this);
    }

    private void unloadResources(ResourceSet resourceSet, ResourceDescriptionsData index, N4ProgressStateRecorder recorder) {
        for (Resource res : this.resources) {
            this.unloadResource(res, resourceSet, index, recorder);
        }
    }

    private void unloadManifestResource(ResourceSet resourceSet, ResourceDescriptionsData index, N4ProgressStateRecorder recorder) {
        Resource resource;
        Optional manifestLocation = this.project.getProjectDescriptionLocation();
        if (manifestLocation.isPresent() && (resource = resourceSet.getResource((URI)manifestLocation.get(), false)) != null) {
            this.unloadResource(resource, resourceSet, index, recorder);
        }
    }

    private void unloadResource(Resource resource, ResourceSet resourceSet, ResourceDescriptionsData index, N4ProgressStateRecorder recorder) {
        recorder.markUnloadingOf(resource);
        if (index != null) {
            index.removeDescription(resource.getURI());
        }
        resource.unload();
        resourceSet.getResources().remove((Object)resource);
    }

    public void clearResources() {
        this.resources.clear();
        this.externalResources.clear();
        this.testResources.clear();
    }

    public void unloadASTAndClearCaches() {
        Iterables.filter(this.resources, resource -> resource.isLoaded()).forEach(resource -> {
            if (resource instanceof N4JSResource) {
                N4JSResource n4jsResource = (N4JSResource)resource;
                n4jsResource.unloadAST();
            }
        });
    }

    public String toString() {
        return this.project.toString();
    }
}

