/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.eclipse.help.internal.search.QueryWordsToken;

public class QueryWordsExactPhrase
extends QueryWordsToken {
    private List<String> words = new ArrayList<String>();

    public QueryWordsExactPhrase() {
        super(3, "");
    }

    public void addWord(String word) {
        this.words.add(word);
        this.value = this.words.size() <= 1 ? word : String.valueOf(this.value) + " " + word;
    }

    public List<String> getWords() {
        return this.words;
    }

    @Override
    public Query createLuceneQuery(String field, float boost) {
        PhraseQuery.Builder qBuilder = new PhraseQuery.Builder();
        BoostQuery boostQuery = null;
        for (String word : this.getWords()) {
            Term t = new Term("exact_" + field, word);
            qBuilder.add(t);
            boostQuery = new BoostQuery((Query)qBuilder.build(), boost);
        }
        return boostQuery;
    }
}

