/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.typesearch;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.n4js.ui.labeling.N4JSLabelProvider;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseCore;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseProject;
import org.eclipse.n4js.ui.typesearch.TypeSearchKind;
import org.eclipse.n4js.utils.ui.JDTUtils;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;

public class OpenTypeSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS_ID = OpenTypeSelectionDialog.class.getSimpleName();
    @Inject
    private IN4JSEclipseCore core;
    @Inject
    private N4JSLabelProvider labelProvider;
    @Inject
    private IURIEditorOpener uriEditorOpener;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    private final Supplier<IResourceDescriptions> indexSupplier = Suppliers.memoize((Supplier)new Supplier<IResourceDescriptions>(){

        public IResourceDescriptions get() {
            ResourceSet resourceSet = OpenTypeSelectionDialog.this.core.createResourceSet(Optional.absent());
            return OpenTypeSelectionDialog.this.core.getXtextIndex(resourceSet);
        }
    });
    private TypeSearchKind searchKind = TypeSearchKind.ALL_TYPES;
    private FilteredItemsSelectionDialog.ItemsFilter currentFilter;

    public OpenTypeSelectionDialog() {
        this(true);
    }

    protected OpenTypeSelectionDialog(boolean multiSelection) {
        super(Display.getCurrent().getActiveShell(), multiSelection);
        this.setTitle("Open N4JS types");
    }

    public int open(TypeSearchKind kind) {
        this.searchKind = kind;
        this.indexSupplier.get();
        return super.open();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        TypesListLabelProvider listLabelProvider = new TypesListLabelProvider();
        this.setListLabelProvider((ILabelProvider)listLabelProvider);
        this.setListSelectionLabelDecorator(listLabelProvider);
        this.setSelectionHistory(new TypesSelectionHistory());
        this.setDetailsLabelProvider((ILabelProvider)new TypesDetailsLabelProvider());
    }

    protected void okPressed() {
        Iterators.filter((Iterator)this.getSelectedItems().iterator(), IEObjectDescription.class).forEachRemaining(desc -> this.uriEditorOpener.open(desc.getEObjectURI(), true));
        super.okPressed();
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = N4JSActivator.getInstance().getDialogSettings().getSection(DIALOG_SETTINGS_ID);
        if (settings == null) {
            settings = N4JSActivator.getInstance().getDialogSettings().addNewSection(DIALOG_SETTINGS_ID);
        }
        return settings;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        this.setCurrentFilter(new TypesFilter());
        return this.getCurrentFilter();
    }

    protected Comparator getItemsComparator() {
        Ordering.natural().nullsLast();
        return Ordering.from((Comparator)new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof IEObjectDescription && o2 instanceof IEObjectDescription) {
                    IEObjectDescription d1 = (IEObjectDescription)o1;
                    IEObjectDescription d2 = (IEObjectDescription)o2;
                    QualifiedName fqn1 = d1.getQualifiedName();
                    QualifiedName fqn2 = d2.getQualifiedName();
                    if (fqn1 != null && fqn2 != null) {
                        return Strings.nullToEmpty((String)fqn1.getLastSegment()).compareToIgnoreCase(Strings.nullToEmpty((String)fqn2.getLastSegment()));
                    }
                }
                return Objects.hashCode((Object[])new Object[]{o1}) - Objects.hashCode((Object[])new Object[]{o2});
            }
        });
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Searching for N4JS types...", -1);
        Iterable types = Iterables.filter((Iterable)((IResourceDescriptions)this.indexSupplier.get()).getExportedObjects(), desc -> this.searchKind.matches(desc.getEClass()));
        monitor.beginTask("Searching for N4JS types...", Iterables.size((Iterable)types));
        types.forEach(desc -> {
            contentProvider.add(desc, itemsFilter);
            monitor.worked(1);
        });
        monitor.done();
    }

    public String getElementName(Object item) {
        return this.labelProvider.getText(item);
    }

    public FilteredItemsSelectionDialog.ItemsFilter getCurrentFilter() {
        return this.currentFilter;
    }

    public void setCurrentFilter(FilteredItemsSelectionDialog.ItemsFilter currentFilter) {
        this.currentFilter = currentFilter;
    }

    private final class TypesDetailsLabelProvider
    extends LabelProvider {
        private TypesDetailsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IEObjectDescription) {
                EObject container;
                IEObjectDescription description = (IEObjectDescription)element;
                StringBuilder sb = new StringBuilder(this.getFqn(description));
                if (description instanceof EObject && ((EObject)description).eContainer() != null && (container = ((EObject)description).eContainer()) instanceof IResourceDescription) {
                    URI uri = ((IResourceDescription)container).getURI();
                    IN4JSEclipseProject project = (IN4JSEclipseProject)OpenTypeSelectionDialog.this.core.findProject(uri).orNull();
                    if (project != null && project.exists()) {
                        sb.append(" [");
                        sb.append(project.getProjectName());
                        sb.append("]");
                        if (project.isExternal()) {
                            IProject resourceProject = project.getProject();
                            sb.append(" External library: ");
                            sb.append(resourceProject.getLocation().toFile().getAbsolutePath());
                        }
                    }
                }
                return sb.toString();
            }
            return "";
        }

        public Image getImage(Object element) {
            return OpenTypeSelectionDialog.this.labelProvider.getImage(element);
        }

        private String getFqn(IEObjectDescription description) {
            String name;
            String fqn = OpenTypeSelectionDialog.this.qualifiedNameConverter.toString(description.getQualifiedName());
            int lastIndexOf = fqn.lastIndexOf(name = Strings.nullToEmpty((String)description.getQualifiedName().getLastSegment()));
            return lastIndexOf > 0 ? fqn.substring(0, lastIndexOf - 1) : fqn;
        }
    }

    private final class TypesFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private TypesFilter() {
            super((FilteredItemsSelectionDialog)OpenTypeSelectionDialog.this);
        }

        public boolean matchItem(Object item) {
            QualifiedName fqn;
            if (item instanceof IEObjectDescription && (fqn = ((IEObjectDescription)item).getQualifiedName()) != null) {
                return this.matches(fqn.getLastSegment());
            }
            return false;
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }
    }

    private final class TypesListLabelProvider
    extends LabelProvider
    implements ILabelDecorator,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private static final String NAME_SEPARATOR = " - ";
        private final StyledString.Styler boldStyler;
        private final StyledString.Styler qualifierStyler;
        private final TypesDetailsLabelProvider delegate;
        private final Supplier<Font> boldFontSupplier = Suppliers.memoize((Supplier)new Supplier<Font>(){

            public Font get() {
                Font font = OpenTypeSelectionDialog.this.getDialogArea().getFont();
                FontData[] data = font.getFontData();
                int i = 0;
                while (i < data.length) {
                    data[i].setStyle(1);
                    ++i;
                }
                return new Font(font.getDevice(), data);
            }
        });

        private TypesListLabelProvider() {
            this.delegate = new TypesDetailsLabelProvider();
            this.qualifierStyler = new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    StyledString.QUALIFIER_STYLER.applyStyles(textStyle);
                }
            };
            this.boldStyler = new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    textStyle.font = (Font)TypesListLabelProvider.this.boldFontSupplier.get();
                }
            };
        }

        public void dispose() {
            Font font;
            super.dispose();
            if (this.boldFontSupplier != null && (font = (Font)this.boldFontSupplier.get()) != null && !font.isDisposed()) {
                font.dispose();
            }
        }

        public Image getImage(Object element) {
            return OpenTypeSelectionDialog.this.labelProvider.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof IEObjectDescription) {
                String text = OpenTypeSelectionDialog.this.labelProvider.getText(element);
                if (OpenTypeSelectionDialog.this.isDuplicateElement(element)) {
                    String fqn = this.delegate.getText(element);
                    return text + NAME_SEPARATOR + fqn;
                }
                return text;
            }
            return null;
        }

        public Image decorateImage(Image image, Object element) {
            return image;
        }

        public String decorateText(String text, Object element) {
            return text;
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof IEObjectDescription) {
                int indexOf;
                String text = this.getText(element);
                StyledString string = new StyledString(text);
                int[] matchingRegion = this.getMatchingRegions(text);
                if (matchingRegion != null) {
                    int i = 0;
                    while (i < matchingRegion.length) {
                        string.setStyle(matchingRegion[i], matchingRegion[i + 1], this.boldStyler);
                        i += 2;
                    }
                }
                if (-1 < (indexOf = text.indexOf(NAME_SEPARATOR))) {
                    string.setStyle(indexOf, text.length() - indexOf, this.qualifierStyler);
                }
                return string;
            }
            return new StyledString();
        }

        private int[] getMatchingRegions(String text) {
            return JDTUtils.getMatchingRegions((String)OpenTypeSelectionDialog.this.getCurrentFilter().getPattern(), (String)text, (int)OpenTypeSelectionDialog.this.getCurrentFilter().getMatchRule());
        }
    }

    private final class TypesSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private static final String MEMENTO_URI_KEY = "uri";

        private TypesSelectionHistory() {
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
            if (item instanceof IEObjectDescription) {
                URI uri = ((IEObjectDescription)item).getEObjectURI();
                memento.putString(MEMENTO_URI_KEY, uri.toString());
            }
        }

        protected Object restoreItemFromMemento(IMemento memento) {
            Optional result;
            String uri = memento.getString(MEMENTO_URI_KEY);
            if (!Strings.isNullOrEmpty((String)uri) && (result = Iterables.tryFind((Iterable)((IResourceDescriptions)OpenTypeSelectionDialog.this.indexSupplier.get()).getExportedObjects(), desc -> uri.equals(String.valueOf(desc.getEObjectURI())))).isPresent()) {
                return OpenTypeSelectionDialog.this.searchKind.matches(((IEObjectDescription)result.get()).getEClass()) ? result.get() : null;
            }
            return null;
        }
    }
}

