/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.json.ui.extension;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.n4js.json.ui.contentassist.IJSONProposalProvider;
import org.eclipse.n4js.json.ui.editor.hyperlinking.IJSONHyperlinkHelperExtension;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;

@Singleton
public class JSONUiExtensionRegistry {
    private static final String JSON_QUICKFIXPROVIDER_EXTENSIONS_POINT_ID = "org.eclipse.n4js.json.ui.quickfixProvider";
    private static final String JSON_PROPOSALPROVIDER_EXTENSIONS_POINT_ID = "org.eclipse.n4js.json.ui.proposalProvider";
    private static final String JSON_HYPERLINKHELPER_EXTENSIONS_POINT_ID = "org.eclipse.n4js.json.ui.hyperlinkHelper";
    private static final String JSON_EXTENSIONS_POINT_CLASS_PROPERTY = "class";
    private static final Logger LOGGER = Logger.getLogger(JSONUiExtensionRegistry.class);
    private boolean isInitialized = false;
    private Set<IssueResolutionProvider> quickfixProviderExtensions;
    private Set<IJSONProposalProvider> proposalProviderExtensions;
    private Set<IJSONHyperlinkHelperExtension> hyperlinkHelperExtensions;

    private void initialize() {
        if (this.isInitialized) {
            LOGGER.warn((Object)"JSONUiExtensionRegistry has already been initialized.");
            return;
        }
        this.quickfixProviderExtensions = new HashSet<IssueResolutionProvider>();
        this.proposalProviderExtensions = new HashSet<IJSONProposalProvider>();
        this.hyperlinkHelperExtensions = new HashSet<IJSONHyperlinkHelperExtension>();
        this.isInitialized = true;
        this.createExecutableExtensions(JSON_QUICKFIXPROVIDER_EXTENSIONS_POINT_ID, IssueResolutionProvider.class).forEach(this::register);
        this.createExecutableExtensions(JSON_PROPOSALPROVIDER_EXTENSIONS_POINT_ID, IJSONProposalProvider.class).forEach(this::register);
        this.createExecutableExtensions(JSON_HYPERLINKHELPER_EXTENSIONS_POINT_ID, IJSONHyperlinkHelperExtension.class).forEach(this::register);
    }

    private <T> List<T> createExecutableExtensions(String extensionPointId, Class<T> extensionClass) {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry == null) {
            return Collections.emptyList();
        }
        IExtension[] extensions = registry.getExtensionPoint(extensionPointId).getExtensions();
        ArrayList<T> executableExtensions = new ArrayList<T>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElems;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElems = extension.getConfigurationElements();
            int n3 = configElems.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement elem = iConfigurationElementArray[n4];
                try {
                    Object executableExtension = elem.createExecutableExtension(JSON_EXTENSIONS_POINT_CLASS_PROPERTY);
                    executableExtensions.add(extensionClass.cast(executableExtension));
                }
                catch (Exception ex) {
                    LOGGER.error((Object)"Error while reading extensions for extension point org.eclipse.n4js.json.ui.quickfixProvider", (Throwable)ex);
                }
                ++n4;
            }
            ++n2;
        }
        return executableExtensions;
    }

    public Collection<IssueResolutionProvider> getQuickfixProviderExtensions() {
        this.ensureInitialization();
        return this.quickfixProviderExtensions;
    }

    public Collection<IJSONProposalProvider> getProposalProviderExtensions() {
        this.ensureInitialization();
        return this.proposalProviderExtensions;
    }

    public Collection<IJSONHyperlinkHelperExtension> getHyperlinkHelperExtensions() {
        this.ensureInitialization();
        return this.hyperlinkHelperExtensions;
    }

    private void register(IssueResolutionProvider quickfixProviderExtension) {
        this.ensureInitialization();
        this.quickfixProviderExtensions.add(quickfixProviderExtension);
    }

    private void register(IJSONProposalProvider proposalProviderExtension) {
        this.ensureInitialization();
        this.proposalProviderExtensions.add(proposalProviderExtension);
    }

    private void register(IJSONHyperlinkHelperExtension hyperlinkHelperExtension) {
        this.ensureInitialization();
        this.hyperlinkHelperExtensions.add(hyperlinkHelperExtension);
    }

    private void ensureInitialization() {
        if (!this.isInitialized) {
            this.initialize();
        }
    }
}

