/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.CommitUtil;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.egit.ui.internal.rebase.RebaseInteractiveView;
import org.eclipse.egit.ui.internal.staging.StagingView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.UIJob;

public class EditHandler
extends AbstractHistoryCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(event);
        RevCommit commit = this.getSelectedCommit(event);
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        try {
            if (!CommitUtil.isCommitInCurrentBranch((RevCommit)commit, (Repository)repository)) {
                MessageDialog.openError((Shell)shell, (String)UIText.EditHandler_Error_Title, (String)UIText.EditHandler_CommitNotOnCurrentBranch);
                return null;
            }
        }
        catch (IOException e) {
            throw new ExecutionException(UIText.EditHandler_ErrorCheckingIfCommitIsOnCurrentBranch, (Throwable)e);
        }
        boolean success = org.eclipse.egit.ui.internal.commit.command.EditHandler.editCommit(commit, repository, shell);
        if (success) {
            this.openStagingAndRebaseInteractiveViews(repository);
        }
        return null;
    }

    private void openStagingAndRebaseInteractiveViews(final Repository repository) {
        UIJob job = new UIJob(UIText.EditHandler_OpenStagingAndRebaseInteractiveViews){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    StagingView stagingView = (StagingView)workbenchPage.showView("org.eclipse.egit.ui.StagingView");
                    stagingView.reload(repository);
                    stagingView.setAmending(true);
                    RebaseInteractiveView rebaseView = (RebaseInteractiveView)workbenchPage.showView("org.eclipse.egit.ui.InteractiveRebaseView");
                    rebaseView.setInput(repository);
                }
                catch (PartInitException e) {
                    Activator.logError(e.getMessage(), e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(RuleUtil.getRule((Repository)repository));
        job.setUser(true);
        job.schedule();
    }

    public boolean isEnabled() {
        GitHistoryPage page = this.getPage();
        if (page == null) {
            return false;
        }
        IStructuredSelection selection = this.getSelection(page);
        if (selection.size() != 1) {
            return false;
        }
        Repository repository = this.getRepository(page);
        if (repository.getRepositoryState() != RepositoryState.SAFE) {
            return false;
        }
        RevCommit commit = (RevCommit)selection.getFirstElement();
        return commit.getParentCount() == 1;
    }
}

