/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.navigator.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.n4js.ui.ImageDescriptorCache;
import org.eclipse.n4js.ui.navigator.internal.DropDownAction;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetDiffBuilder;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerBroker;
import org.eclipse.n4js.utils.Diff;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.xtext.util.Arrays;

public class ShowHiddenWorkingSetsDropDownAction
extends DropDownAction {
    @VisibleForTesting
    public static final String SHOW_ALL_HIDDEN_WORKING_SETS = "Show All Hidden Working Sets";
    @Inject
    private WorkingSetManagerBroker workingSetManagerBroker;

    public ShowHiddenWorkingSetsDropDownAction() {
        super((ImageDescriptor)ImageDescriptorCache.ImageRef.SHOW_HIDDEN_WORKING_SETS.asImageDescriptor().orNull());
        this.setToolTipText("Show Hidden Working Sets");
    }

    @Override
    protected void createMenuItems(Menu parent) {
        final WorkingSetManager manager = this.workingSetManagerBroker.getActiveManager();
        final WorkingSet[] allWorkingSets = manager.getAllWorkingSets();
        Object[] workingSets = manager.getWorkingSets();
        WorkingSet[] workingSetArray = allWorkingSets;
        int n = allWorkingSets.length;
        int n2 = 0;
        while (n2 < n) {
            final WorkingSet workingSet = workingSetArray[n2];
            if (!Arrays.contains((Object[])workingSets, (Object)workingSet)) {
                MenuItem item = new MenuItem(parent, 8);
                item.setText(workingSet.getName());
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ShowHiddenWorkingSetsDropDownAction.this.showWorkingSet(manager, new WorkingSet[]{workingSet});
                    }
                });
            }
            ++n2;
        }
        this.createSeparator(parent);
        MenuItem item = new MenuItem(parent, 32);
        item.setText(SHOW_ALL_HIDDEN_WORKING_SETS);
        item.addSelectionListener((SelectionListener)new SelectionAdapter((WorkingSet[])workingSets, manager){
            private final /* synthetic */ WorkingSet[] val$workingSets;
            private final /* synthetic */ WorkingSetManager val$manager;
            {
                this.val$workingSets = workingSetArray2;
                this.val$manager = workingSetManager;
            }

            public void widgetSelected(SelectionEvent e) {
                Sets.SetView difference = Sets.difference((Set)Sets.newHashSet((Object[])allWorkingSets), (Set)Sets.newHashSet((Object[])this.val$workingSets));
                WorkingSet[] toShow = (WorkingSet[])Iterables.toArray((Iterable)difference, WorkingSet.class);
                ShowHiddenWorkingSetsDropDownAction.this.showWorkingSet(this.val$manager, toShow);
            }
        });
    }

    private void showWorkingSet(WorkingSetManager manager, WorkingSet ... workingSets) {
        WorkingSetDiffBuilder builder = new WorkingSetDiffBuilder(manager);
        ArrayList visibleItems = Lists.newArrayList((Object[])manager.getWorkingSets());
        visibleItems.addAll(Lists.newArrayList((Object[])workingSets));
        Object[] newAllItems = manager.getAllWorkingSets();
        ArrayList newItems = Lists.newArrayList((Object[])manager.getAllWorkingSets());
        Iterator itr = newItems.iterator();
        while (itr.hasNext()) {
            WorkingSet next = (WorkingSet)itr.next();
            if (visibleItems.contains(next)) continue;
            itr.remove();
        }
        Diff diff = builder.build((WorkingSet[])Iterables.toArray((Iterable)newItems, WorkingSet.class), newAllItems);
        if (!diff.isEmpty()) {
            manager.updateState((Diff<WorkingSet>)diff);
            manager.saveState((IProgressMonitor)new NullProgressMonitor());
            manager.getWorkingSetManagerBroker().refreshNavigator();
        }
    }
}

