/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.domain;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import org.eclipse.n4js.tester.domain.ID;
import org.eclipse.n4js.tester.domain.TestCase;
import org.eclipse.n4js.tester.domain.TestElement;

@JsonAutoDetect
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TestSuite
implements TestElement,
Iterable<TestCase>,
Comparable<TestSuite> {
    @JsonProperty
    private String name;
    private List<TestCase> testCases = Lists.newArrayList();
    private List<TestSuite> children = Lists.newArrayList();
    private Map<ID, TestCase> testCaseIndex = Maps.newHashMap();

    static TestSuite copyOf(TestSuite suite) {
        TestSuite copy = new TestSuite(suite.name);
        copy.testCases = Lists.newArrayList((Iterable)Iterables.transform(suite.testCases, input -> TestCase.copyOf(input)));
        copy.children = Lists.newArrayList((Iterable)Iterables.transform(suite.children, input -> TestSuite.copyOf(input)));
        copy.testCaseIndex = Maps.newHashMap((Map)Maps.uniqueIndex(copy.testCases, testCase -> testCase.getId()));
        return copy;
    }

    private TestSuite() {
    }

    public TestSuite(String name) {
        this.name = name;
    }

    public List<TestCase> getTestCases() {
        return Collections.unmodifiableList(this.testCases);
    }

    public void add(TestCase testCaseToAdd) {
        this.testCases.add(testCaseToAdd);
        this.testCaseIndex.put(testCaseToAdd.getId(), testCaseToAdd);
    }

    public void addAll(Collection<? extends TestCase> testCasesToAdd) {
        this.testCases.addAll(testCasesToAdd);
        testCasesToAdd.forEach(t -> {
            TestCase testCase = this.testCaseIndex.put(t.getId(), (TestCase)t);
        });
    }

    public List<TestSuite> getChildren() {
        return this.children;
    }

    public void setTestCases(List<TestCase> testCases) {
        this.testCases = testCases == null ? Lists.newArrayList() : testCases;
        ImmutableMap mapping = Maps.uniqueIndex(this.testCases, testCase -> testCase.getId());
        this.testCaseIndex = mapping.isEmpty() ? Maps.newHashMap() : Maps.newHashMap((Map)mapping);
    }

    public String getName() {
        return this.name;
    }

    public TestSuite clone() throws CloneNotSupportedException {
        return TestSuite.copyOf(this);
    }

    @Override
    public Iterator<TestCase> iterator() {
        return Iterators.concat(this.testCases.iterator(), (Iterator)Iterators.concat((Iterator)Iterators.transform(this.children.iterator(), (Function)new Function<TestSuite, Iterator<TestCase>>(){

            public Iterator<TestCase> apply(TestSuite testSuite) {
                return testSuite.iterator();
            }
        })));
    }

    @Override
    public Spliterator<TestCase> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)Iterators.size(this.iterator()), 0);
    }

    public String toString() {
        return this.toString(1);
    }

    private String toString(int childIdentCount) {
        StringBuilder sb = new StringBuilder();
        int testCaseCount = this.getTestCases().size();
        int executedTestCaseCount = Iterables.size((Iterable)Iterables.filter(this.getTestCases(), tc -> tc.getResult() != null));
        sb.append(this.name);
        sb.append(" [").append(executedTestCaseCount).append("/").append(testCaseCount).append("]");
        if (Iterables.isEmpty(this.children)) {
            return sb.toString();
        }
        for (TestSuite suite : this.children) {
            sb.append("\n");
            int i = 0;
            while (i < childIdentCount) {
                sb.append("\t");
                ++i;
            }
            sb.append(suite.toString(childIdentCount + 1));
        }
        return sb.toString();
    }

    public TestCase getTestCase(ID testCaseId) {
        return this.getTestCase(this, this.testCaseIndex.get(testCaseId), testCaseId);
    }

    private TestCase getTestCase(TestSuite testSuite, TestCase testCase, ID testCaseId) {
        if (testCase != null) {
            return testCase;
        }
        testCase = testSuite.testCaseIndex.get(testCaseId);
        if (testCase != null) {
            return testCase;
        }
        for (TestSuite child : testSuite.children) {
            testCase = this.getTestCase(child, testCase, testCaseId);
            if (testCase == null) continue;
            return testCase;
        }
        return testCase;
    }

    @Override
    public int compareTo(TestSuite o) {
        return o == null ? -1 : Strings.nullToEmpty((String)this.name).compareTo(Strings.nullToEmpty((String)o.name));
    }

    public void sort() {
        Collections.sort(this.testCases);
    }
}

