/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.xpect.ui.common.ReadOutConfiguration;
import org.eclipse.xpect.xtext.lib.setup.FileSetupContext;
import org.eclipse.xpect.xtext.lib.setup.workspace.Workspace;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IResourceDescription;

public class ReadOutWorkspaceConfiguration
extends ReadOutConfiguration {
    private Workspace configuredWorkspace;
    private final FileExtensionProvider fileExtensionProvider;

    ReadOutWorkspaceConfiguration(FileSetupContext ctx, IN4JSCore core, FileExtensionProvider fileExtensionProvider) {
        super(ctx, core);
        this.fileExtensionProvider = fileExtensionProvider;
    }

    public void add(Workspace workspace) {
        this.configuredWorkspace = workspace;
    }

    public Workspace getXpectConfiguredWorkspace() {
        return this.configuredWorkspace;
    }

    @Override
    public List<Resource> getResources() {
        ArrayList configuredResources = Lists.newArrayList();
        if (this.configuredWorkspace != null && this.fileSetupCtx != null) {
            for (IResourceDescription res : this.index.getAllResourceDescriptions()) {
                if (!this.fileExtensionProvider.isValid(res.getURI().fileExtension())) continue;
                configuredResources.add(this.resourceSet.getResource(res.getURI(), true));
            }
        }
        return configuredResources;
    }
}

