/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.utils.RecursionGuard;
import org.eclipse.n4js.utils.collections.Arrays2;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.nodemodel.impl.LeafNodeWithSyntaxError;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.osgi.framework.Bundle;

public class UtilN4 {
    private static Logger logger = Logger.getLogger(UtilN4.class);
    private static final Iterable<Pair<String, String>> CHARS_TO_ESCAPED_CHARS = ImmutableList.builder().add((Object)Tuples.pair((Object)"&", (Object)"&amp;")).add((Object)Tuples.pair((Object)"<", (Object)"&lt;")).add((Object)Tuples.pair((Object)">", (Object)"&gt;")).build();
    private static final Function<String, String> ESCAPE_FUNC = new Function<String, String>(){

        @Override
        public String apply(String t) {
            AtomicReference<String> s = new AtomicReference<String>(Strings.nullToEmpty((String)t));
            CHARS_TO_ESCAPED_CHARS.forEach(input -> s.set(((String)s.get()).replace((CharSequence)input.getFirst(), (CharSequence)input.getSecond())));
            return s.get();
        }
    };
    private static final Function<String, String> UNESCAPE_FUNC = new Function<String, String>(){

        @Override
        public String apply(String t) {
            AtomicReference<String> s = new AtomicReference<String>(Strings.nullToEmpty((String)t));
            CHARS_TO_ESCAPED_CHARS.forEach(input -> s.set(((String)s.get()).replace((CharSequence)input.getSecond(), (CharSequence)input.getFirst())));
            return s.get();
        }
    };

    public static final <T> List<T> findCycleInDirectedGraph(T startNode, Function<T, Iterable<T>> getNextNodes) {
        RecursionGuard<T> guard = new RecursionGuard<T>();
        guard.tryNext(startNode);
        return UtilN4.findCycleInDirectedGraph(startNode, getNextNodes, guard);
    }

    private static final <T> List<T> findCycleInDirectedGraph(T node, Function<T, Iterable<T>> getNextNodes, RecursionGuard<T> guard) {
        for (T nextNode : getNextNodes.apply(node)) {
            if (guard.tryNext(nextNode)) {
                try {
                    List<T> cycle = UtilN4.findCycleInDirectedGraph(nextNode, getNextNodes, guard);
                    if (cycle == null) continue;
                    List<T> list = cycle;
                    return list;
                }
                finally {
                    guard.done(nextNode);
                }
            }
            Stack<T> path = guard.getElements();
            if (nextNode != path.firstElement()) continue;
            path.push(nextNode);
            return new ArrayList<T>(path);
        }
        return null;
    }

    public static final String sanitizeForHTML(String str) {
        return ESCAPE_FUNC.apply(UNESCAPE_FUNC.apply(str));
    }

    public static final void takeSnapshotInGraphView(String label, Object root) {
        String name;
        if (!(root instanceof ResourceSet || root instanceof Resource || root instanceof EObject)) {
            throw new IllegalArgumentException("root must be a ResourceSet, Resource, or EObject");
        }
        Resource resource = root instanceof Resource ? (Resource)root : (root instanceof EObject ? ((EObject)root).eResource() : null);
        URI uri = resource != null ? resource.getURI() : null;
        String string = name = uri != null ? uri.lastSegment() : null;
        if (name != null) {
            label = String.valueOf(label) + " (" + name + ")";
        }
        try {
            Bundle testViewBundle = Platform.getBundle((String)"org.eclipse.n4js.smith.graph");
            Class testViewClass = testViewBundle.loadClass("org.eclipse.n4js.smith.graph.ASTGraphView");
            Method m = testViewClass.getMethod("show", String.class, Object.class);
            m.invoke(null, label, root);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final String toUpperCaseFirst(String str) {
        char first;
        if (str != null && str.length() > 0 && Character.isLowerCase(first = str.charAt(0))) {
            return String.valueOf(Character.toUpperCase(first)) + str.substring(1);
        }
        return str;
    }

    public static final String toLowerCaseFirst(String str) {
        char first;
        if (str != null && str.length() > 0 && Character.isUpperCase(first = str.charAt(0))) {
            return String.valueOf(Character.toLowerCase(first)) + str.substring(1);
        }
        return str;
    }

    public static final String trimPrefix(String str, String ... prefix) {
        if (str == null) {
            return null;
        }
        String result = str;
        int idx = 0;
        while (idx < prefix.length) {
            if (prefix[idx] != null && prefix[idx].length() != 0 && result.startsWith(prefix[idx])) {
                result = result.substring(prefix[idx].length());
                idx = 0;
            }
            ++idx;
        }
        return result;
    }

    public static final String trimSuffix(String str, String ... suffix) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        String result = str;
        int idx = 0;
        while (idx < suffix.length) {
            if (suffix[idx] != null && suffix[idx].length() != 0 && result.endsWith(suffix[idx])) {
                result = result.substring(0, len - suffix[idx].length());
                idx = 0;
            }
            ++idx;
        }
        return result;
    }

    public static void fill(StringBuilder strb, int offset) {
        while (strb.length() < offset) {
            strb.append(' ');
        }
    }

    public static <T extends Throwable> T reportError(T exception) {
        return UtilN4.reportError(exception.getMessage(), exception);
    }

    public static <T extends Throwable> T reportError(String msg, T exception) {
        logger.error((Object)msg, exception);
        return exception;
    }

    public static boolean isIgnoredSyntaxErrorNode(INode leaf, String ... ignoredSyntaxErrorIssues) {
        SyntaxErrorMessage errorMessage;
        if (leaf instanceof LeafNodeWithSyntaxError && (errorMessage = leaf.getSyntaxErrorMessage()) != null) {
            return UtilN4.contains(errorMessage.getIssueCode(), ignoredSyntaxErrorIssues);
        }
        return false;
    }

    private static boolean contains(String elementToCheck, String ... elements) {
        if (Arrays2.isEmpty(elements)) {
            return false;
        }
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element == null && elementToCheck == null) {
                return true;
            }
            if (element != null && element.equals(elementToCheck)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Path findN4jsRepoRootPath() {
        Path rootPath = UtilN4.findN4jsRepoRootPathFailSafe();
        if (rootPath == null || !rootPath.toFile().exists() || !rootPath.toFile().isDirectory()) {
            throw new IllegalStateException("N4JS repository root path not found (does the current working directory lie inside an N4JS repository clone?) starting from working directory " + new File("").getAbsolutePath() + ".");
        }
        return rootPath;
    }

    public static Path findN4jsRepoRootPathFailSafe() {
        try {
            File curr = new File("").getCanonicalFile();
            while (curr != null && curr.isDirectory() && !UtilN4.isN4jsRepoRoot(curr)) {
                curr = curr.getParentFile();
            }
            return curr != null ? curr.toPath() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean isN4jsRepoRoot(File folder) {
        return folder.isDirectory() && new File(folder, "plugins/" + UtilN4.class.getPackage().getName()).isDirectory();
    }
}

