/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.organize.imports;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.n4js.documentation.N4JSDocumentationProvider;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.ts.services.TypeExpressionsGrammarAccess;
import org.eclipse.n4js.ui.changes.ChangeManager;
import org.eclipse.n4js.ui.changes.ChangeProvider;
import org.eclipse.n4js.ui.changes.IAtomicChange;
import org.eclipse.n4js.ui.changes.IChange;
import org.eclipse.n4js.ui.changes.Replacement;
import org.eclipse.n4js.ui.organize.imports.BreakException;
import org.eclipse.n4js.ui.organize.imports.ChangeAnalysis;
import org.eclipse.n4js.ui.organize.imports.ImportsComputer;
import org.eclipse.n4js.ui.organize.imports.ImportsRegionHelper;
import org.eclipse.n4js.ui.organize.imports.ImportsRemovalChangesComputer;
import org.eclipse.n4js.ui.organize.imports.InsertionPoint;
import org.eclipse.n4js.ui.organize.imports.Interaction;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentProvider;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

class DocumentImportsOrganizer {
    private static final Logger LOGGER = Logger.getLogger(DocumentImportsOrganizer.class);
    @Inject
    private ImportsComputer importsComputer;
    @Inject
    private ImportsRegionHelper hImportsRegion;
    @Inject
    private ChangeManager changeManager;
    @Inject
    private XtextDocumentProvider docProvider;
    @Inject
    private TypeExpressionsGrammarAccess typeExpressionsGrammarAccess;
    @Inject
    private N4JSDocumentationProvider n4JSDocumentationProvider;

    DocumentImportsOrganizer() {
    }

    void organizeFile(IFile file, Interaction interaction, IProgressMonitor mon) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)mon, (String)("Organizing " + file.getName()), (int)-1);
        FileEditorInput fei = new FileEditorInput(file);
        this.docProvider.connect((Object)fei);
        IXtextDocument document = (IXtextDocument)this.docProvider.getDocument((Object)fei);
        this.docProvider.aboutToChange((Object)fei);
        this.organizeDocument(document, interaction);
        subMon.setTaskName("Saving " + file.getName());
        this.docProvider.saveDocument((IProgressMonitor)subMon.split(0), (Object)fei, (IDocument)document, true);
        this.docProvider.changed((Object)fei);
        this.docProvider.disconnect((Object)fei);
    }

    void organizeDocument(IXtextDocument document, Interaction interaction) {
        document.readOnly(p -> {
            N4JSResource.postProcess((Resource)p);
            return null;
        });
        List result = (List)document.readOnly(this.prepareImportsChanges(document, interaction));
        this.applyChangesToDocument(document, result);
    }

    private void applyChangesToDocument(final IXtextDocument document, List<IChange> result) {
        if (result != null && !result.isEmpty()) {
            final ChangeAnalysis changeAnalysis = this.condense(result);
            if (changeAnalysis.noRealChanges) {
                String del = document.get().substring(changeAnalysis.deletion.getOffset(), changeAnalysis.deletion.getOffset() + changeAnalysis.deletion.getLength());
                if (changeAnalysis.newText.getText().equals(del)) {
                    return;
                }
            }
            document.modify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                public void process(XtextResource state) throws Exception {
                    try {
                        EcoreUtil.resolveAll((Resource)state);
                        DocumentImportsOrganizer.this.changeManager.applyAllInSameDocument(changeAnalysis.changes, (IDocument)document);
                    }
                    catch (BadLocationException e) {
                        LOGGER.error((Object)e);
                    }
                }
            });
        }
    }

    private IUnitOfWork<List<IChange>, XtextResource> prepareImportsChanges(final IXtextDocument document, final Interaction interaction) {
        return new IUnitOfWork<List<IChange>, XtextResource>(){

            public List<IChange> exec(XtextResource xtextResource) throws Exception {
                InsertionPoint insertionPoint = DocumentImportsOrganizer.this.hImportsRegion.getImportRegion(xtextResource);
                if (insertionPoint.offset != -1) {
                    ArrayList<IChange> changes = new ArrayList<IChange>();
                    try {
                        String NL = ChangeProvider.lineDelimiter(document, insertionPoint.offset);
                        String organizedImportSection = DocumentImportsOrganizer.this.importsComputer.getOrganizedImportSection(xtextResource, NL, interaction);
                        changes.addAll(ImportsRemovalChangesComputer.getImportDeletionChanges(xtextResource, document));
                        changes.addAll(DocumentImportsOrganizer.this.getImportInsertionChanges(document, xtextResource, insertionPoint, NL, organizedImportSection));
                        return changes;
                    }
                    catch (BreakException.UserCanceledBreakException e) {
                        return null;
                    }
                    catch (BreakException e) {
                        LOGGER.warn((Object)"Organize imports broke:", (Throwable)e);
                        throw e;
                    }
                }
                return null;
            }
        };
    }

    private List<IChange> getImportInsertionChanges(IXtextDocument document, XtextResource xtextResource, InsertionPoint insertionPoint, String NL, String organizedImportSection) throws BadLocationException {
        if (organizedImportSection.isEmpty()) {
            return Collections.emptyList();
        }
        int offset = insertionPoint.offset;
        if (offset != 0 && !insertionPoint.isBeforeJsdocDocumentation) {
            offset += NL.length();
        }
        IRegion lineRegion = document.getLineInformationOfOffset(offset);
        ILeafNode leafNodeAtBeginOfLine = NodeModelUtils.findLeafNodeAtOffset((INode)xtextResource.getParseResult().getRootNode(), (int)lineRegion.getOffset());
        if (leafNodeAtBeginOfLine.getGrammarElement() == this.typeExpressionsGrammarAccess.getML_COMMENTRule()) {
            int insertOffset = insertionPoint.offset;
            boolean atStartOfLine = insertionPoint.offset == lineRegion.getOffset();
            String finalText = String.valueOf(atStartOfLine ? "" : NL) + organizedImportSection + NL;
            return Lists.newArrayList((Object[])new IChange[]{new Replacement(xtextResource.getURI().trimFragment(), insertOffset, 0, finalText)});
        }
        if (UtilN4.isIgnoredSyntaxErrorNode((INode)leafNodeAtBeginOfLine, (String[])new String[]{"InternalSemicolonInjectingParser.ASI"}) && leafNodeAtBeginOfLine.getTotalOffset() < lineRegion.getOffset()) {
            int insertOffset = insertionPoint.offset;
            if (!insertionPoint.isBeforeJsdocDocumentation && this.n4JSDocumentationProvider.isDocumentationStyle(NodeModelUtils.getTokenText((INode)leafNodeAtBeginOfLine))) {
                insertOffset = leafNodeAtBeginOfLine.getTotalOffset();
            }
            String finalText = String.valueOf(NL) + organizedImportSection + NL;
            return Lists.newArrayList((Object[])new IChange[]{new Replacement(xtextResource.getURI().trimFragment(), insertOffset, 0, finalText)});
        }
        return Lists.newArrayList((Object[])new IChange[]{ChangeProvider.insertLineAbove(document, offset, organizedImportSection, false)});
    }

    private ChangeAnalysis condense(List<IChange> changes) {
        List<IAtomicChange> atomicResult = this.changeManager.flattenAndOrganized(changes);
        if (atomicResult.isEmpty()) {
            return new ChangeAnalysis(atomicResult, true);
        }
        URI uri = atomicResult.get(0).getURI();
        if (!(atomicResult.get(0) instanceof Replacement)) {
            return new ChangeAnalysis(atomicResult, false);
        }
        Replacement rText = null;
        for (IAtomicChange nxt : atomicResult) {
            if (!(nxt instanceof Replacement) || !uri.equals(nxt.getURI())) {
                return new ChangeAnalysis(atomicResult, false);
            }
            Replacement rplc = (Replacement)nxt;
            if (rplc.getText() == null || rplc.getText().length() <= 0) continue;
            if (rText == null) {
                rText = rplc;
                continue;
            }
            return new ChangeAnalysis(atomicResult, false);
        }
        IAtomicChange.AbstractAtomicChange current = null;
        int i = atomicResult.size() - 1;
        while (i >= 0) {
            IAtomicChange nxt = atomicResult.get(i);
            if (nxt != rText) {
                Replacement rplc = (Replacement)nxt;
                if (current == null) {
                    current = rplc;
                } else if (current.getOffset() + current.getLength() == rplc.getOffset()) {
                    current = new Replacement(uri, current.getOffset(), current.getLength() + rplc.getLength(), "");
                } else {
                    return new ChangeAnalysis(atomicResult, false);
                }
            }
            --i;
        }
        if (current == null || rText == null || current.getLength() != rText.getText().length()) {
            return new ChangeAnalysis(atomicResult, false);
        }
        List<IAtomicChange> orderedChanges = null;
        if (rText == atomicResult.get(0)) {
            orderedChanges = Arrays.asList(rText, current);
        } else if (rText == atomicResult.get(atomicResult.size() - 1)) {
            orderedChanges = Arrays.asList(current, rText);
        } else {
            return new ChangeAnalysis(atomicResult, false);
        }
        ChangeAnalysis result = new ChangeAnalysis(orderedChanges, true);
        result.deletion = current;
        result.newText = rText;
        return result;
    }
}

