/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.validation.ResourceValidatorImpl;

public class N4JSResourceValidator
extends ResourceValidatorImpl {
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public List<Issue> validate(Resource resource, CheckMode mode, CancelIndicator cancelIndicator) {
        if (resource instanceof N4JSResource) {
            N4JSResource resourceCasted = (N4JSResource)resource;
            try {
                resourceCasted.performPostProcessing(cancelIndicator);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (resourceCasted.isFullyProcessed() && resourceCasted.getPostProcessingThrowable() != null) {
                Throwable th = resourceCasted.getPostProcessingThrowable();
                if (this.operationCanceledManager.isOperationCanceledException(th)) {
                    return Collections.emptyList();
                }
                Issue issue = this.createPostProcessingFailedError(resourceCasted, th);
                return Collections.singletonList(issue);
            }
        }
        return super.validate(resource, mode, cancelIndicator);
    }

    protected void validate(Resource resource, CheckMode mode, CancelIndicator cancelIndicator, IAcceptor<Issue> acceptor) {
        this.operationCanceledManager.checkCanceled(cancelIndicator);
        if (this.n4jsCore.isNoValidate(resource.getURI())) {
            return;
        }
        EList contents = resource.getContents();
        if (!contents.isEmpty()) {
            EObject firstElement = (EObject)contents.get(0);
            this.validate(resource, firstElement, mode, cancelIndicator, acceptor);
        }
    }

    private Issue createPostProcessingFailedError(N4JSResource res, Throwable th) {
        String thKind = th instanceof Error ? "error" : (th instanceof Exception ? "exception" : "throwable");
        String thName = th.getClass().getSimpleName();
        String trace = "\n" + Stream.of(th.getStackTrace()).map(ste -> ste.toString()).collect(Collectors.joining("\n"));
        String msg = IssueCodes.getMessageForPOST_PROCESSING_FAILED(thKind, thName, String.valueOf(th.getMessage()) + trace);
        Issue.IssueImpl issue = new Issue.IssueImpl();
        issue.setCode("POST_PROCESSING_FAILED");
        issue.setSeverity(IssueCodes.getDefaultSeverity("POST_PROCESSING_FAILED"));
        issue.setMessage(msg);
        issue.setUriToProblem(EcoreUtil.getURI((EObject)res.getScript()));
        issue.setType(CheckType.FAST);
        issue.setOffset(Integer.valueOf(0));
        issue.setLength(Integer.valueOf(0));
        issue.setLineNumber(Integer.valueOf(0));
        issue.setColumn(Integer.valueOf(0));
        return issue;
    }
}

