/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.compare;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collections;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.events.IndexChangedEvent;
import org.eclipse.jgit.events.RepositoryEvent;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.team.internal.ui.synchronize.EditableSharedDocumentAdapter;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;

public class LocalNonWorkspaceTypedElement
extends LocalResourceTypedElement {
    @NonNull
    private final IPath path;
    @NonNull
    private final Repository repository;
    private boolean exists;
    private boolean fDirty;
    private long timestamp;
    private boolean useSharedDocument = true;
    private EditableSharedDocumentAdapter sharedDocumentAdapter;
    private EditableSharedDocumentAdapter.ISharedDocumentAdapterListener sharedDocumentListener;
    private static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();

    public LocalNonWorkspaceTypedElement(@NonNull Repository repository, @NonNull IPath path) {
        super((IResource)ROOT.getFile(path));
        this.path = path;
        this.repository = repository;
        File file = path.toFile();
        boolean bl = this.exists = file.exists() || Files.isSymbolicLink(file.toPath());
        if (this.exists) {
            this.timestamp = file.lastModified();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputStream getContents() throws CoreException {
        RevCommit headCommit;
        block4: {
            Repository sub;
            if (!this.exists) return null;
            File file = this.path.toFile();
            this.timestamp = file.lastModified();
            if (Files.isSymbolicLink(file.toPath())) {
                String symLink = FileUtils.readSymLink((File)file);
                return new ByteArrayInputStream(Constants.encode((String)symLink));
            }
            if (!file.isDirectory() || (sub = ResourceUtil.getRepository((IPath)this.path)) == null || sub == this.repository) return new FileInputStream(file);
            headCommit = Activator.getDefault().getRepositoryUtil().parseHeadCommit(sub);
            if (headCommit != null) break block4;
            return null;
        }
        try {
            return new ByteArrayInputStream(Constants.encode((String)headCommit.name()));
        }
        catch (IOException | UnsupportedOperationException e) {
            Activator.error(e.getMessage(), e);
        }
        return null;
    }

    public boolean isEditable() {
        IResource resource = this.getResource();
        return resource.getType() == 1 && this.exists;
    }

    public long getModificationDate() {
        return this.timestamp;
    }

    public boolean isSynchronized() {
        return this.path.toFile().lastModified() == this.timestamp;
    }

    public void update() {
        this.exists = this.path.toFile().exists();
    }

    public boolean exists() {
        return this.exists;
    }

    public boolean isSharedDocumentsEnable() {
        return this.useSharedDocument && this.getResource().getType() == 1 && this.exists;
    }

    public void enableSharedDocument(boolean enablement) {
        this.useSharedDocument = enablement;
    }

    public void setContent(byte[] contents) {
        this.fDirty = true;
        super.setContent(contents);
    }

    private void refreshTimestamp() {
        this.timestamp = this.path.toFile().lastModified();
    }

    public void commit(IProgressMonitor monitor) throws CoreException {
        if (this.isDirty()) {
            if (this.isConnected()) {
                super.commit(monitor);
            } else {
                File file = this.path.toFile();
                try {
                    try {
                        java.nio.file.Path fp = file.toPath();
                        if (Files.isSymbolicLink(fp)) {
                            String sp = new String(this.getContent(), Constants.CHARSET).trim();
                            if (sp.indexOf(10) > 0) {
                                sp = sp.substring(0, sp.indexOf(10)).trim();
                            }
                            if (!sp.isEmpty()) {
                                boolean wasBrokenLink = !file.exists();
                                java.nio.file.Path link = FileUtils.createSymLink((File)file, (String)sp);
                                this.updateLinkResource(wasBrokenLink, link);
                            }
                        } else {
                            if (!file.exists()) {
                                FileUtils.createNewFile((File)file);
                            }
                            Throwable throwable = null;
                            Object var5_9 = null;
                            try (FileOutputStream out = new FileOutputStream(file);){
                                out.write(this.getContent());
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        this.fDirty = false;
                    }
                    catch (IOException e) {
                        throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), UIText.LocalNonWorkspaceTypedElement_errorWritingContents, (Throwable)e));
                    }
                }
                finally {
                    this.fireChanges();
                }
            }
            this.refreshTimestamp();
        }
    }

    private void updateLinkResource(boolean wasBroken, java.nio.file.Path link) {
        boolean brokenNow;
        boolean bl = brokenNow = !Files.exists(link, new LinkOption[0]);
        if (brokenNow == wasBroken) {
            return;
        }
        IPath parentPath = this.path.removeLastSegments(1);
        final IContainer parent = ResourceUtil.getContainerForLocation((IPath)parentPath, (boolean)true);
        if (parent != null) {
            WorkspaceJob job = new WorkspaceJob("Refreshing " + parentPath){

                public IStatus runInWorkspace(IProgressMonitor m) throws CoreException {
                    parent.refreshLocal(1, m);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    private void fireChanges() {
        RepositoryMapping mapping;
        this.fireContentChanged();
        Repository myRepository = this.repository;
        boolean updated = false;
        if (!myRepository.isBare()) {
            updated = this.refreshRepositoryState(myRepository);
        }
        if (!updated && (mapping = RepositoryMapping.getMapping((IPath)this.path)) != null) {
            mapping.getRepository().fireEvent((RepositoryEvent)new IndexChangedEvent(true));
        }
    }

    private boolean refreshRepositoryState(@NonNull Repository repo) {
        Path repositoryRoot = new Path(repo.getWorkTree().getPath());
        IPath relativePath = this.path.makeRelativeTo((IPath)repositoryRoot);
        IndexDiffCacheEntry indexDiffCacheForRepository = org.eclipse.egit.core.Activator.getDefault().getIndexDiffCache().getIndexDiffCacheEntry(repo);
        if (indexDiffCacheForRepository != null) {
            indexDiffCacheForRepository.refreshFiles(Collections.singleton(relativePath.toString()));
            return true;
        }
        return false;
    }

    public synchronized boolean isDirty() {
        return this.fDirty || this.sharedDocumentAdapter != null && this.sharedDocumentAdapter.hasBufferedContents();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISharedDocumentAdapter.class) {
            if (this.isSharedDocumentsEnable()) {
                return this.getSharedDocumentAdapter();
            }
            return null;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void setSharedDocumentListener(EditableSharedDocumentAdapter.ISharedDocumentAdapterListener sharedDocumentListener) {
        this.sharedDocumentListener = sharedDocumentListener;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.path.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        LocalNonWorkspaceTypedElement other = (LocalNonWorkspaceTypedElement)((Object)obj);
        return this.path.equals((Object)other.path);
    }

    private synchronized ISharedDocumentAdapter getSharedDocumentAdapter() {
        if (this.sharedDocumentAdapter == null) {
            this.sharedDocumentAdapter = new EditableSharedDocumentAdapter(new EditableSharedDocumentAdapter.ISharedDocumentAdapterListener(){

                public void handleDocumentConnected() {
                    LocalNonWorkspaceTypedElement.this.refreshTimestamp();
                    if (LocalNonWorkspaceTypedElement.this.sharedDocumentListener != null) {
                        LocalNonWorkspaceTypedElement.this.sharedDocumentListener.handleDocumentConnected();
                    }
                }

                public void handleDocumentFlushed() {
                    LocalNonWorkspaceTypedElement.this.fireContentChanged();
                    if (LocalNonWorkspaceTypedElement.this.sharedDocumentListener != null) {
                        LocalNonWorkspaceTypedElement.this.sharedDocumentListener.handleDocumentFlushed();
                    }
                }

                public void handleDocumentDeleted() {
                    LocalNonWorkspaceTypedElement.this.update();
                    if (LocalNonWorkspaceTypedElement.this.sharedDocumentListener != null) {
                        LocalNonWorkspaceTypedElement.this.sharedDocumentListener.handleDocumentDeleted();
                    }
                }

                public void handleDocumentSaved() {
                    LocalNonWorkspaceTypedElement.this.refreshTimestamp();
                    if (LocalNonWorkspaceTypedElement.this.sharedDocumentListener != null) {
                        LocalNonWorkspaceTypedElement.this.sharedDocumentListener.handleDocumentSaved();
                    }
                }

                public void handleDocumentDisconnected() {
                    if (LocalNonWorkspaceTypedElement.this.sharedDocumentListener != null) {
                        LocalNonWorkspaceTypedElement.this.sharedDocumentListener.handleDocumentDisconnected();
                    }
                }
            });
        }
        return this.sharedDocumentAdapter;
    }
}

