/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.server;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.n4js.tester.server.HttpServerManager;
import org.eclipse.n4js.tester.server.resources.HttpMethod;
import org.eclipse.n4js.tester.server.resources.ResourceRouterServlet;
import org.eclipse.n4js.tester.server.resources.ServletHolderBuilder;

@Singleton
public class JettyManager
implements HttpServerManager {
    private static final Logger LOGGER = Logger.getLogger(JettyManager.class);
    private static final String PREFLIGHT_MAX_AGE_VALUE = "728000";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String X_PING_OTHER = "X-PINGOTHER";
    private static final String X_REQUESTED_WITH = "X-Requested-With";
    private static final String ORIGIN = "Origin";
    private static final String ACCEPT = "Accept";
    private final ServletHolderBuilder servletHolderBuilder;
    private final boolean dumpServerOnStop;
    private final int minThreadCount;
    private final int maxThreadCount;
    private final int threadPoolCapacity;
    private final LoadingCache<Integer, Server> serverCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Integer, Server>(){

        public Server load(Integer port) throws Exception {
            Server server = null;
            try {
                server = new Server(this.configureThreadPool(port));
                ServerConnector connector = new ServerConnector(server);
                connector.setPort(port.intValue());
                server.setConnectors(new Connector[]{connector});
                ServletContextHandler contextHandler = new ServletContextHandler((HandlerContainer)server, "/n4js", true, false);
                ServletHolder servlet = JettyManager.this.servletHolderBuilder.build(ResourceRouterServlet.class);
                contextHandler.addServlet(servlet, "/testing/sessions/*");
                contextHandler.addFilter(this.configureCors(), "/testing/sessions/*", EnumSet.of(DispatcherType.REQUEST, DispatcherType.ASYNC));
                server.setDumpBeforeStop(JettyManager.this.dumpServerOnStop);
                server.start();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Cache failed to start new server instance at PORT=" + port), (Throwable)e);
                if (server != null && server.isRunning()) {
                    server.stop();
                }
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
            return server;
        }

        private ThreadPool configureThreadPool(int port) {
            QueuedThreadPool threadPool = new QueuedThreadPool(JettyManager.this.threadPoolCapacity);
            threadPool.setMinThreads(JettyManager.this.minThreadCount);
            threadPool.setMaxThreads(JettyManager.this.maxThreadCount);
            threadPool.setName("Jetty thread pool [" + port + "]");
            threadPool.setDetailedDump(true);
            return threadPool;
        }

        private FilterHolder configureCors() {
            FilterHolder filter = new FilterHolder((Filter)new CrossOriginFilter());
            filter.setInitParameter("allowedOrigins", "*");
            filter.setInitParameter("Access-Control-Allow-Credentials", String.valueOf(Boolean.TRUE));
            filter.setInitParameter("allowedMethods", Joiner.on((String)",").join((Object[])HttpMethod.values()));
            filter.setInitParameter("allowedHeaders", Joiner.on((String)",").join((Object)JettyManager.X_PING_OTHER, (Object)JettyManager.ORIGIN, new Object[]{JettyManager.X_REQUESTED_WITH, JettyManager.CONTENT_TYPE, JettyManager.ACCEPT}));
            filter.setInitParameter("preflightMaxAge", JettyManager.PREFLIGHT_MAX_AGE_VALUE);
            filter.setInitParameter("allowCredentials", String.valueOf(Boolean.TRUE));
            return filter;
        }
    });

    @Inject
    JettyManager(ServletHolderBuilder servletHolderBuilder, @Named(value="dumpServerOnStopKey") boolean dumpServerOnStop, @Named(value="minThreadCountKey") int minThreadCount, @Named(value="maxThreadCountKey") int maxThreadCount, @Named(value="threadPoolBlockingCapacityKey") int threadPoolCapacity) {
        this.servletHolderBuilder = servletHolderBuilder;
        this.dumpServerOnStop = dumpServerOnStop;
        this.minThreadCount = minThreadCount;
        this.maxThreadCount = maxThreadCount;
        this.threadPoolCapacity = threadPoolCapacity;
    }

    @Override
    public int startServer(Map<String, Object> config) {
        Optional<Integer> port = this.getPort(config);
        if (port.isPresent()) {
            try {
                if (!this.isValidPort((Integer)port.get())) {
                    throw new RuntimeException("Cannot instantiate Jetty instance. Reason: invalid port number: " + port.get());
                }
                Server server = (Server)this.serverCache.getIfPresent(port.get());
                if (server == null) {
                    int checkedPort = this.ensurePortIsAvailable((Integer)port.get());
                    if (checkedPort != (Integer)port.get()) {
                        LOGGER.warn((Object)("Original port was modified to: " + checkedPort + "."));
                        LOGGER.warn((Object)"LDE will not be able to send HTTP requests to this server by default. Please check used ports or reconfigure LDE to be compatible with this embedded Jetty server.");
                    }
                    server = (Server)this.serverCache.get((Object)checkedPort);
                    LOGGER.info((Object)("Jetty instance has successfully started on '" + checkedPort + "'."));
                    return checkedPort;
                }
                LOGGER.info((Object)("Jetty instance is already running on '" + port.get() + "'."));
                return (Integer)port.get();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error while starting Jetty server on '" + port.get() + "'."), (Throwable)e);
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        LOGGER.error((Object)"Due to missing HTTP port properties Jetty cannot be started.");
        throw new RuntimeException("Due to missing HTTP port properties Jetty cannot be started.");
    }

    @Override
    public void stopServer(int port) {
        for (int localPort : -1 == port ? this.getAllRunningServerPorts() : Collections.singletonList(port)) {
            if (!this.isRunning(localPort)) continue;
            try {
                Server server = (Server)this.serverCache.getIfPresent((Object)localPort);
                if (server == null) continue;
                server.stop();
                if (server.isStopped()) {
                    LOGGER.info((Object)("Jetty instance has successfully stopped on '" + localPort + "'."));
                    this.serverCache.invalidate((Object)localPort);
                    continue;
                }
                LOGGER.warn((Object)("Unexpected behavior while shutting down Jetty on '" + localPort + "'. Termination failed."));
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error while stopping Jetty server on '" + localPort + "'."), (Throwable)e);
            }
        }
    }

    @Override
    public boolean isRunning(int port) {
        if (!this.isValidPort(port)) {
            return false;
        }
        Server server = (Server)this.serverCache.getIfPresent((Object)port);
        if (server == null) {
            return false;
        }
        if (!server.isStarted()) {
            return false;
        }
        return this.isPortInUse(port);
    }

    private boolean isPortInUse(int port) {
        block26: {
            Throwable throwable = null;
            Object var3_8 = null;
            Socket so = new Socket("localhost", port);
            try {
                so.setReuseAddress(true);
                so.close();
                if (so == null) break block26;
            }
            catch (Throwable throwable2) {
                try {
                    if (so != null) {
                        so.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    try {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        block27: {
                            Throwable throwable4 = null;
                            var3_8 = null;
                            ServerSocket ss = new ServerSocket(port);
                            try {
                                ss.setReuseAddress(true);
                                ss.close();
                                if (ss == null) break block27;
                            }
                            catch (Throwable throwable5) {
                                try {
                                    if (ss != null) {
                                        ss.close();
                                    }
                                    throw throwable5;
                                }
                                catch (Throwable throwable6) {
                                    try {
                                        if (throwable4 == null) {
                                            throwable4 = throwable6;
                                        } else if (throwable4 != throwable6) {
                                            throwable4.addSuppressed(throwable6);
                                        }
                                        throw throwable4;
                                    }
                                    catch (IOException e) {
                                        return true;
                                    }
                                }
                            }
                            ss.close();
                        }
                        return false;
                    }
                }
            }
            so.close();
        }
        return true;
    }

    private boolean isValidPort(int port) {
        return port > 0 && 65535 >= port;
    }

    public int ensurePortIsAvailable(Integer port) {
        if (port == null) {
            int nextPort = this.getNextAvailablePort();
            LOGGER.warn((Object)("Port was null. Trying to use next available port: " + nextPort + "."));
            return nextPort;
        }
        if (!this.isValidPort(port)) {
            int nextPort = this.getNextAvailablePort();
            LOGGER.warn((Object)("Port was invalid: " + port + ". Trying to use next available port: " + nextPort + "."));
            return nextPort;
        }
        if (this.isPortInUse(port)) {
            int nextPort = this.getNextAvailablePort();
            LOGGER.warn((Object)("Port is already in use: " + port + ". Trying to use next available port: " + nextPort + "."));
            return nextPort;
        }
        return port;
    }

    private int getNextAvailablePort() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ServerSocket ss = new ServerSocket(0);){
                return ss.getLocalPort();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while trying to get next available port.", e);
        }
    }

    private int getLocalPort(Server server) {
        return ((ServerConnector)server.getConnectors()[0]).getLocalPort();
    }

    private Iterable<Integer> getAllRunningServerPorts() {
        return FluentIterable.from(this.serverCache.asMap().values()).filter(s -> !s.isStopped()).transform(s -> this.getLocalPort((Server)s));
    }

    private Optional<Integer> getPort(Map<String, Object> config) {
        Object portObject = config.get("http.port");
        if (portObject == null) {
            LOGGER.warn((Object)"HTTP port is not configured for the Jetty.");
            return Optional.absent();
        }
        try {
            int port = Integer.parseInt(String.valueOf(portObject));
            if (this.isValidPort(port)) {
                return Optional.fromNullable((Object)port);
            }
            LOGGER.error((Object)("Port number must be between 0 and 65535. Was: " + port));
            return Optional.absent();
        }
        catch (NumberFormatException e) {
            LOGGER.warn((Object)("Invalid HTTP port number. It was: '" + String.valueOf(portObject) + "'."));
            return Optional.absent();
        }
    }
}

