/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.methods;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import junit.framework.AssertionFailedError;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.n4js.tests.util.EclipseGracefulUIShutdownEnabler;
import org.eclipse.n4js.xpect.common.N4JSOffsetAdapter;
import org.eclipse.n4js.xpect.common.XpectCommentRemovalUtil;
import org.eclipse.n4js.xpect.config.Config;
import org.eclipse.n4js.xpect.config.VarDef;
import org.eclipse.n4js.xpect.config.XpEnvironmentData;
import org.eclipse.n4js.xpect.ui.common.QuickFixTestHelper;
import org.eclipse.n4js.xpect.ui.common.XtextResourceCleanUtil;
import org.eclipse.n4js.xpect.ui.methods.contentassist.N4ContentAssistProcessorTestBuilder;
import org.eclipse.n4js.xpect.ui.methods.contentassist.N4ContentAssistProcessorTestBuilderHelper;
import org.eclipse.n4js.xpect.ui.methods.contentassist.RegionWithCursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.expectation.CommaSeparatedValuesExpectation;
import org.eclipse.xpect.expectation.ICommaSeparatedValuesExpectation;
import org.eclipse.xpect.expectation.IStringDiffExpectation;
import org.eclipse.xpect.expectation.StringDiffExpectation;
import org.eclipse.xpect.parameter.ParameterParser;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xpect.xtext.lib.setup.ThisResource;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

@XpectImport(value={N4JSOffsetAdapter.class, XpEnvironmentData.class, VarDef.class, Config.class})
public class ProposalXpectMethod {
    private static Logger logger;
    @Inject
    private IParser parser;
    @Inject
    private Provider<ResourceSet> resourceSetProvider;
    @Inject
    private Provider<XtextResource> resourceProvider;
    @Inject
    private N4ContentAssistProcessorTestBuilderHelper n4ContentAssistProcessorTestBuilderHelper;

    static {
        EclipseGracefulUIShutdownEnabler.enableOnce();
        logger = Logger.getLogger(ProposalXpectMethod.class);
    }

    @ParameterParser(syntax="'at' arg2=STRING")
    @Xpect
    public void checkProposals(@CommaSeparatedValuesExpectation ICommaSeparatedValuesExpectation expectation, @ThisResource XtextResource resource, RegionWithCursor offset) throws Exception {
        N4ContentAssistProcessorTestBuilder fixture = this.n4ContentAssistProcessorTestBuilderHelper.createTestBuilderForResource(resource);
        final ICompletionProposal[] computeCompletionProposals = this.allProposalsAt(offset, fixture);
        final ArrayList proposalsWithError = Lists.newArrayList();
        int proposal = 0;
        while (proposal < computeCompletionProposals.length) {
            fixture = fixture.reset();
            String content = resource.getParseResult().getRootNode().getText();
            fixture = fixture.append(content);
            IXtextDocument document = fixture.getDocument(resource, content);
            final int index = proposal++;
            String newContent = this.applyProposal(computeCompletionProposals[index], document);
            IXtextDocument newXtextDocument = fixture.getDocument(this.getNewResource(newContent, resource.getURI()), content);
            newXtextDocument.readOnly((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

                public Object exec(XtextResource state) throws Exception {
                    EcoreUtil.resolveAll((Resource)state);
                    if (!state.getErrors().isEmpty()) {
                        proposalsWithError.add(computeCompletionProposals[index].getDisplayString());
                    } else if (!state.validateConcreteSyntax().isEmpty()) {
                        proposalsWithError.add(computeCompletionProposals[index].getDisplayString());
                    }
                    return null;
                }
            });
        }
        expectation.assertEquals((Iterable)proposalsWithError);
    }

    @ParameterParser(syntax="(arg3=STRING 'at' arg2=STRING)?")
    @Xpect
    public void proposalChange(@StringDiffExpectation IStringDiffExpectation expectation, @ThisResource XtextResource resource, RegionWithCursor arg2, String arg3) throws Exception {
        RegionWithCursor offset = arg2;
        String text = arg3;
        N4ContentAssistProcessorTestBuilder fixture = this.n4ContentAssistProcessorTestBuilderHelper.createTestBuilderForResource(resource);
        ICompletionProposal proposal = this.exactlyMatchingProposal(offset, fixture, text);
        String before = resource.getParseResult().getRootNode().getText();
        if (proposal != null) {
            IXtextDocument document = fixture.getDocument(XtextResourceCleanUtil.cleanXtextResource(resource), before);
            String after = this.applyProposal(proposal, document);
            before = XpectCommentRemovalUtil.removeAllXpectComments((String)before);
            after = XpectCommentRemovalUtil.removeAllXpectComments((String)after);
            expectation.assertDiffEquals(before, after);
        }
    }

    private ICompletionProposal exactlyMatchingProposal(RegionWithCursor offset, N4ContentAssistProcessorTestBuilder fixture, String selected) {
        ICompletionProposal[] computeCompletionProposals = this.allProposalsAt(offset, fixture);
        List<ICompletionProposal> candidates = Arrays.stream(computeCompletionProposals).filter(proposal -> proposal.getDisplayString().contains(selected)).collect(Collectors.toList());
        if (candidates.size() > 1) {
            throw new AssertionFailedError("The selection of contentassist is not precise enough more then one assist matched the selection '" + selected + "': " + QuickFixTestHelper.asString2(candidates) + " Please be more precise.");
        }
        if (candidates.size() < 1) {
            throw new AssertionFailedError("No content assist matching the selection '" + selected + "' found. Available are " + QuickFixTestHelper.asString2(Arrays.asList(computeCompletionProposals)));
        }
        ICompletionProposal proposal2 = (ICompletionProposal)candidates.get(0);
        return proposal2;
    }

    private ICompletionProposal[] allProposalsAt(RegionWithCursor offset, N4ContentAssistProcessorTestBuilder fixture) {
        AtomicReference w = new AtomicReference();
        Display.getDefault().syncExec(() -> {
            try {
                w.set(fixture.computeCompletionProposals(offset.getGlobalCursorOffset()));
            }
            catch (Exception e) {
                logger.warn((Object)"Cannot compute Completion Proposals", (Throwable)e);
            }
        });
        return (ICompletionProposal[])w.get();
    }

    private String applyProposal(final ICompletionProposal proposal, final IXtextDocument document) {
        return (String)document.modify((IUnitOfWork)new IUnitOfWork<String, XtextResource>(){

            public String exec(XtextResource state) throws Exception {
                state.setValidationDisabled(false);
                if (!(proposal instanceof TemplateProposal)) {
                    proposal.apply((IDocument)document);
                }
                return document.get();
            }
        });
    }

    private XtextResource getNewResource(String content, URI uri) {
        IParseResult parseResult = this.parser.parse((Reader)new StringReader(content));
        ResourceSet resourceSet2 = (ResourceSet)this.resourceSetProvider.get();
        XtextResource newXtextResource = (XtextResource)this.resourceProvider.get();
        newXtextResource.setURI(uri);
        resourceSet2.getResources().add((Object)newXtextResource);
        newXtextResource.setParseResult(parseResult);
        return newXtextResource;
    }
}

