/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesbuilder;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.PropertyGetterDeclaration;
import org.eclipse.n4js.n4JS.PropertyMethodDeclaration;
import org.eclipse.n4js.n4JS.PropertyNameOwner;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.PropertySetterDeclaration;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TStructField;
import org.eclipse.n4js.ts.types.TStructGetter;
import org.eclipse.n4js.ts.types.TStructMember;
import org.eclipse.n4js.ts.types.TStructMethod;
import org.eclipse.n4js.ts.types.TStructSetter;
import org.eclipse.n4js.ts.types.TStructuralType;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesbuilder.N4JSFormalParameterTypesBuilder;
import org.eclipse.n4js.typesbuilder.N4JSTypesBuilderHelper;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class N4JSObjectLiteralTypesBuilder {
    @Inject
    @Extension
    private N4JSTypesBuilderHelper _n4JSTypesBuilderHelper;
    @Inject
    @Extension
    private N4JSFormalParameterTypesBuilder _n4JSFormalParameterTypesBuilder;

    void createObjectLiteral(ObjectLiteral objectLiteral, TModule target, boolean preLinkingPhase) {
        BuiltInTypeScope builtInTypeScope = BuiltInTypeScope.get((ResourceSet)objectLiteral.eResource().getResourceSet());
        TStructuralType structType = TypesFactory.eINSTANCE.createTStructuralType();
        Functions.Function1 _function = it -> it.getName() != null || it.hasComputedPropertyName();
        Consumer<PropertyAssignment> _function_1 = it -> {
            TStructMember typeModelElement = this.createTypeModelElement(structType, objectLiteral, (PropertyAssignment)it, builtInTypeScope, preLinkingPhase);
            if (typeModelElement != null) {
                typeModelElement.setAstElement((EObject)it);
                EList _ownedMembers = structType.getOwnedMembers();
                _ownedMembers.add((Object)typeModelElement);
            }
        };
        IterableExtensions.filter((Iterable)objectLiteral.getPropertyAssignments(), (Functions.Function1)_function).forEach(_function_1);
        structType.setAstElement((EObject)objectLiteral);
        objectLiteral.setDefinedType((Type)structType);
        EList _internalTypes = target.getInternalTypes();
        _internalTypes.add((Object)structType);
    }

    private TStructMember _createTypeModelElement(TStructuralType structType, ObjectLiteral objectLiteral, PropertyAssignment assignment, BuiltInTypeScope builtInTypeScope, boolean preLinkingPhase) {
        return null;
    }

    private TStructField _createTypeModelElement(TStructuralType structType, ObjectLiteral objectLiteral, PropertyNameValuePair nameValuePair, BuiltInTypeScope builtInTypeScope, boolean preLinkingPhase) {
        boolean _tripleNotEquals;
        TStructField field = TypesFactory.eINSTANCE.createTStructField();
        this._n4JSTypesBuilderHelper.setMemberName((TMember)field, (PropertyNameOwner)nameValuePair);
        field.setOptional(nameValuePair.isDeclaredOptional());
        TypeRef _declaredTypeRef = nameValuePair.getDeclaredTypeRef();
        boolean bl = _tripleNotEquals = _declaredTypeRef != null;
        if (_tripleNotEquals) {
            if (!preLinkingPhase) {
                field.setTypeRef((TypeRef)TypeUtils.copyWithProxies((EObject)nameValuePair.getDeclaredTypeRef()));
            }
        } else {
            boolean _tripleNotEquals_1;
            Expression _expression = nameValuePair.getExpression();
            boolean bl2 = _tripleNotEquals_1 = _expression != null;
            if (_tripleNotEquals_1) {
                field.setTypeRef((TypeRef)TypeUtils.createDeferredTypeRef());
            } else {
                field.setTypeRef((TypeRef)builtInTypeScope.getAnyTypeRef());
            }
        }
        field.setAstElement((EObject)nameValuePair);
        nameValuePair.setDefinedField(field);
        return field;
    }

    private TStructGetter _createTypeModelElement(TStructuralType structType, ObjectLiteral objectLiteral, PropertyGetterDeclaration getterDecl, BuiltInTypeScope builtInTypeScope, boolean preLinkingPhase) {
        boolean _tripleNotEquals;
        TStructGetter getter = TypesFactory.eINSTANCE.createTStructGetter();
        this._n4JSTypesBuilderHelper.setMemberName((TMember)getter, (PropertyNameOwner)getterDecl);
        getter.setOptional(getterDecl.isDeclaredOptional());
        TypeRef _declaredTypeRef = getterDecl.getDeclaredTypeRef();
        boolean bl = _tripleNotEquals = _declaredTypeRef != null;
        if (_tripleNotEquals) {
            if (!preLinkingPhase) {
                getter.setDeclaredTypeRef((TypeRef)TypeUtils.copyWithProxies((EObject)getterDecl.getDeclaredTypeRef()));
            }
        } else {
            getter.setDeclaredTypeRef((TypeRef)TypeUtils.createDeferredTypeRef());
        }
        getter.setAstElement((EObject)getterDecl);
        getterDecl.setDefinedGetter((TGetter)getter);
        return getter;
    }

    private TStructSetter _createTypeModelElement(TStructuralType structType, ObjectLiteral objectLiteral, PropertySetterDeclaration setterDecl, BuiltInTypeScope builtInTypeScope, boolean preLinkingPhase) {
        boolean _tripleNotEquals;
        TStructSetter setter = TypesFactory.eINSTANCE.createTStructSetter();
        this._n4JSTypesBuilderHelper.setMemberName((TMember)setter, (PropertyNameOwner)setterDecl);
        setter.setOptional(setterDecl.isDeclaredOptional());
        TFormalParameter param = TypesFactory.eINSTANCE.createTFormalParameter();
        FormalParameter _fpar = setterDecl.getFpar();
        boolean bl = _tripleNotEquals = _fpar != null;
        if (_tripleNotEquals) {
            param.setName(setterDecl.getFpar().getName());
            TypeRef fparDeclTypeRef = setterDecl.getFpar().getDeclaredTypeRef();
            if (fparDeclTypeRef != null) {
                if (!preLinkingPhase) {
                    param.setTypeRef((TypeRef)TypeUtils.copyWithProxies((EObject)fparDeclTypeRef));
                }
            } else {
                param.setTypeRef((TypeRef)TypeUtils.createDeferredTypeRef());
            }
        } else {
            param.setTypeRef((TypeRef)TypeUtils.createDeferredTypeRef());
        }
        setter.setFpar(param);
        setter.setAstElement((EObject)setterDecl);
        setterDecl.setDefinedSetter((TSetter)setter);
        return setter;
    }

    private TStructMethod _createTypeModelElement(TStructuralType structType, ObjectLiteral objectLiteral, PropertyMethodDeclaration methodDecl, BuiltInTypeScope builtInTypeScope, boolean preLinkingPhase) {
        boolean _tripleNotEquals;
        TStructMethod result = TypesFactory.eINSTANCE.createTStructMethod();
        this._n4JSTypesBuilderHelper.setMemberName((TMember)result, (PropertyNameOwner)methodDecl);
        EList _fpars = result.getFpars();
        Functions.Function1 _function = it -> this._n4JSFormalParameterTypesBuilder.createFormalParameter((FormalParameter)it, builtInTypeScope, preLinkingPhase);
        List _map = ListExtensions.map((List)methodDecl.getFpars(), (Functions.Function1)_function);
        Iterables.addAll((Collection)_fpars, (Iterable)_map);
        TypeRef _returnTypeRef = methodDecl.getReturnTypeRef();
        boolean bl = _tripleNotEquals = _returnTypeRef != null;
        if (_tripleNotEquals) {
            if (!preLinkingPhase) {
                result.setReturnTypeRef((TypeRef)TypeUtils.copyWithProxies((EObject)methodDecl.getReturnTypeRef()));
            }
        } else {
            result.setReturnTypeRef((TypeRef)builtInTypeScope.getVoidTypeRef());
        }
        result.setAstElement((EObject)methodDecl);
        methodDecl.setDefinedType((Type)result);
        return result;
    }

    private TStructMember createTypeModelElement(TStructuralType structType, ObjectLiteral objectLiteral, PropertyAssignment getterDecl, BuiltInTypeScope builtInTypeScope, boolean preLinkingPhase) {
        if (getterDecl instanceof PropertyGetterDeclaration) {
            return this._createTypeModelElement(structType, objectLiteral, (PropertyGetterDeclaration)getterDecl, builtInTypeScope, preLinkingPhase);
        }
        if (getterDecl instanceof PropertyMethodDeclaration) {
            return this._createTypeModelElement(structType, objectLiteral, (PropertyMethodDeclaration)getterDecl, builtInTypeScope, preLinkingPhase);
        }
        if (getterDecl instanceof PropertyNameValuePair) {
            return this._createTypeModelElement(structType, objectLiteral, (PropertyNameValuePair)getterDecl, builtInTypeScope, preLinkingPhase);
        }
        if (getterDecl instanceof PropertySetterDeclaration) {
            return this._createTypeModelElement(structType, objectLiteral, (PropertySetterDeclaration)getterDecl, builtInTypeScope, preLinkingPhase);
        }
        if (getterDecl != null) {
            return this._createTypeModelElement(structType, objectLiteral, getterDecl, builtInTypeScope, preLinkingPhase);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(structType, objectLiteral, getterDecl, builtInTypeScope, preLinkingPhase).toString());
    }
}

