/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesbuilder;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.LiteralAnnotationArgument;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.n4JS.ModifiableElement;
import org.eclipse.n4js.n4JS.ModifierUtils;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4Modifier;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.PropertyNameKind;
import org.eclipse.n4js.n4JS.PropertyNameOwner;
import org.eclipse.n4js.n4JS.TypeRefAnnotationArgument;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.AccessibleTypeElement;
import org.eclipse.n4js.ts.types.DeclaredTypeWithAccessModifier;
import org.eclipse.n4js.ts.types.FieldAccessor;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TAnnotation;
import org.eclipse.n4js.ts.types.TAnnotationStringArgument;
import org.eclipse.n4js.ts.types.TAnnotationTypeRefArgument;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TypeAccessModifier;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
class N4JSTypesBuilderHelper {
    @Inject
    private JavaScriptVariantHelper jsVariantHelper;
    private static Logger logger = Logger.getLogger(N4JSTypesBuilderHelper.class);

    N4JSTypesBuilderHelper() {
    }

    protected <T extends AnnotableElement & ModifiableElement> void setTypeAccessModifier(AccessibleTypeElement classifier, T definition) {
        boolean isPlainJS = this.jsVariantHelper.isPlainJS((EObject)definition);
        if (isPlainJS) {
            classifier.setDeclaredTypeAccessModifier(TypeAccessModifier.PUBLIC);
        } else {
            classifier.setDeclaredTypeAccessModifier(ModifierUtils.convertToTypeAccessModifier((Collection)((ModifiableElement)definition).getDeclaredModifiers(), (List)definition.getAllAnnotations()));
        }
    }

    void setProvidedByRuntime(DeclaredTypeWithAccessModifier declaredType, AnnotableElement annotableElement, boolean preLinkingPhase) {
        declaredType.setDeclaredProvidedByRuntime(AnnotationDefinition.PROVIDED_BY_RUNTIME.hasAnnotation(annotableElement));
    }

    <T extends EObject> void addCopyOfReferences(List<? super T> target, List<T> values) {
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(values);
        if (_isNullOrEmpty) {
            return;
        }
        Functions.Function1 _function = it -> it != null && it.eIsProxy();
        boolean _exists = IterableExtensions.exists(values, (Functions.Function1)_function);
        if (_exists) {
            throw new IllegalStateException("There is a proxy in the list, cannot copy and set references");
        }
        Functions.Function1 _function_1 = it -> it == null;
        boolean _exists_1 = IterableExtensions.exists(values, (Functions.Function1)_function_1);
        if (_exists_1) {
            return;
        }
        Functions.Function1 _function_2 = it -> TypeUtils.copyWithProxies((EObject)it);
        List _map = ListExtensions.map(values, (Functions.Function1)_function_2);
        Iterables.addAll(target, (Iterable)_map);
    }

    void setMemberName(TMember tMember, PropertyNameOwner n4MemberOrPropertyAssignment) {
        tMember.setName(n4MemberOrPropertyAssignment.getName());
        LiteralOrComputedPropertyName _declaredName = n4MemberOrPropertyAssignment.getDeclaredName();
        PropertyNameKind _kind = null;
        if (_declaredName != null) {
            _kind = _declaredName.getKind();
        }
        boolean _tripleEquals = _kind == PropertyNameKind.COMPUTED;
        tMember.setHasComputedName(_tripleEquals);
    }

    void setMemberAccessModifier(Procedures.Procedure1<? super MemberAccessModifier> memberAccessModifierAssignment, Collection<? extends N4Modifier> modifiers, List<Annotation> annotations) {
        memberAccessModifierAssignment.apply((Object)ModifierUtils.convertToMemberAccessModifier(modifiers, annotations));
    }

    ParameterizedTypeRef createAnyTypeRef(EObject object) {
        ParameterizedTypeRef _xblockexpression = null;
        Resource _eResource = null;
        if (object != null) {
            _eResource = object.eResource();
        }
        ResourceSet _resourceSet = null;
        if (_eResource != null) {
            _resourceSet = _eResource.getResourceSet();
        }
        ResourceSet rs = _resourceSet;
        ParameterizedTypeRef _xifexpression = null;
        _xifexpression = rs != null ? BuiltInTypeScope.get((ResourceSet)rs).getAnyTypeRef() : null;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    void copyAnnotations(TAnnotableElement typeTarget, AnnotableElement ast, boolean preLinkingPhase) {
        EList _annotations = typeTarget.getAnnotations();
        Functions.Function1 _function = it -> AnnotationDefinition.isInTypeModel(it.getName());
        Functions.Function1 _function_1 = it -> {
            TAnnotation ta = TypesFactory.eINSTANCE.createTAnnotation();
            ta.setName(it.getName());
            Functions.Function1 _function_2 = it_1 -> {
                boolean _matched = false;
                if (it_1 instanceof LiteralAnnotationArgument) {
                    _matched = true;
                    TAnnotationStringArgument arg = TypesFactory.eINSTANCE.createTAnnotationStringArgument();
                    arg.setValue(((LiteralAnnotationArgument)it_1).getLiteral().getValueAsString());
                    return arg;
                }
                if (!_matched && it_1 instanceof TypeRefAnnotationArgument) {
                    _matched = true;
                    TAnnotationTypeRefArgument arg = TypesFactory.eINSTANCE.createTAnnotationTypeRefArgument();
                    arg.setTypeRef((TypeRef)TypeUtils.copyWithProxies((EObject)((TypeRefAnnotationArgument)it_1).getTypeRef()));
                    return arg;
                }
                return null;
            };
            ta.getArgs().addAll((Collection)ListExtensions.map((List)it.getArgs(), (Functions.Function1)_function_2));
            return ta;
        };
        Iterable _map = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)ast.getAllAnnotations(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        Iterables.addAll((Collection)_annotations, (Iterable)_map);
    }

    TClassifier getObjectType(EObject object) {
        TClassifier _xblockexpression = null;
        Resource _eResource = null;
        if (object != null) {
            _eResource = object.eResource();
        }
        ResourceSet _resourceSet = null;
        if (_eResource != null) {
            _resourceSet = _eResource.getResourceSet();
        }
        ResourceSet rs = _resourceSet;
        TClassifier _xifexpression = null;
        _xifexpression = rs != null ? BuiltInTypeScope.get((ResourceSet)rs).getObjectType() : null;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    boolean isDeclaredCovariantConstructor(N4ClassifierDeclaration classifierDecl) {
        boolean _hasAnnotation = AnnotationDefinition.COVARIANT_CONSTRUCTOR.hasAnnotation((AnnotableElement)classifierDecl);
        if (_hasAnnotation) {
            return true;
        }
        Functions.Function1 _function = it -> it.isConstructor();
        N4MemberDeclaration ctor = (N4MemberDeclaration)IterableExtensions.findFirst((Iterable)classifierDecl.getOwnedMembers(), (Functions.Function1)_function);
        return ctor != null && AnnotationDefinition.COVARIANT_CONSTRUCTOR.hasAnnotation((AnnotableElement)ctor);
    }

    protected void setDeclaredThisTypeFromAnnotation(TFunction functionType, FunctionDefinition functionDef, boolean preLinkingPhase) {
        if (!preLinkingPhase) {
            functionType.setDeclaredThisType((TypeRef)TypeUtils.copyWithProxies((EObject)this.internalGetDeclaredThisTypeFromAnnotation((AnnotableElement)functionDef)));
        }
    }

    protected void setDeclaredThisTypeFromAnnotation(FieldAccessor accessorType, org.eclipse.n4js.n4JS.FieldAccessor accessorDecl, boolean preLinkingPhase) {
        if (!preLinkingPhase) {
            accessorType.setDeclaredThisType((TypeRef)TypeUtils.copyWithProxies((EObject)this.internalGetDeclaredThisTypeFromAnnotation((AnnotableElement)accessorDecl)));
        }
    }

    private TypeRef internalGetDeclaredThisTypeFromAnnotation(AnnotableElement element) {
        Annotation annThis = AnnotationDefinition.THIS.getAnnotation(element);
        EList _args = null;
        if (annThis != null) {
            _args = annThis.getArgs();
        }
        Iterable _filter = null;
        if (_args != null) {
            _filter = Iterables.filter((Iterable)_args, TypeRefAnnotationArgument.class);
        }
        TypeRefAnnotationArgument _head = null;
        if (_filter != null) {
            _head = (TypeRefAnnotationArgument)IterableExtensions.head((Iterable)_filter);
        }
        TypeRef _typeRef = null;
        if (_head != null) {
            _typeRef = _head.getTypeRef();
        }
        return _typeRef;
    }

    protected void ensureEqualName(NamedElement astNode, IdentifiableElement moduleElement) {
        String nameInAST = astNode.getName();
        String nameInModule = moduleElement.getName();
        if (nameInAST != null) {
            boolean _not;
            boolean _equals = nameInAST.equals(nameInModule);
            boolean bl = _not = !_equals;
            if (_not) {
                Resource _eResource = astNode.eResource();
                URI _uRI = null;
                if (_eResource != null) {
                    _uRI = _eResource.getURI();
                }
                String msg = "inconsistency between newly loaded AST and to-be-linked TModule: nameInAST=" + nameInAST + ", " + "nameInModule=" + nameInModule + ", " + "in: " + _uRI;
                logger.error((Object)msg);
                throw new IllegalStateException(msg);
            }
        }
    }
}

