/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.internal.N4JSModel;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;

@Singleton
public class ProjectResolveHelper {
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private N4JSModel model;

    public IN4JSProject resolveProject(Resource resource) {
        return this.resolveProject(resource.getURI());
    }

    public IN4JSProject resolveProject(URI n4jsSourceURI) {
        Optional<? extends IN4JSProject> optionalProject = this.n4jsCore.findProject(n4jsSourceURI);
        if (!optionalProject.isPresent()) {
            throw new RuntimeException("Cannot handle resource without containing project. Resource URI was: " + n4jsSourceURI + ".");
        }
        return (IN4JSProject)optionalProject.get();
    }

    public String resolvePackageAndFileName(Resource resource) {
        return this.resolvePackageAndFileName(resource.getURI());
    }

    public String resolvePackageAndFileName(URI uri) {
        IN4JSProject project = (IN4JSProject)this.n4jsCore.findProject(uri).orNull();
        return this.resolvePackageAndFileName(uri, project);
    }

    public String resolvePackageAndFileName(URI uri, IN4JSProject project) {
        String msg = "Cannot locate source container for module " + uri + ".";
        if (project == null) {
            throw new RuntimeException(String.valueOf(msg) + " Provided project was null.");
        }
        if (!project.exists()) {
            throw new RuntimeException(String.valueOf(msg) + " Does project '" + project.getProjectName() + "' exists and opened in the workspace?");
        }
        Optional<? extends IN4JSSourceContainer> optionalSourceContainer = this.model.findN4JSExternalSourceContainer(project, uri);
        if (!optionalSourceContainer.isPresent()) {
            throw new RuntimeException(msg);
        }
        return uri.deresolve(((IN4JSSourceContainer)optionalSourceContainer.get()).getLocation().appendSegment("")).trimFileExtension().toString();
    }
}

