/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.ui.quickfix;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

public class XpectQuickfixProvider
extends DefaultQuickfixProvider {
    @Fix(value="org.eclipse.xpect.live_test_execution.expectation_delete")
    public void delete(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Delete", "Delete text to match actual test result.", null, new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument xtextDocument = context.getXtextDocument();
                xtextDocument.replace(issue.getOffset().intValue(), issue.getLength().intValue(), "");
            }
        });
    }

    @Fix(value="org.eclipse.xpect.live_test_execution.expectation_insert")
    public void insert(final Issue issue, IssueResolutionAcceptor acceptor) {
        final String newText = issue.getData()[0];
        acceptor.accept(issue, "Insert " + this.quote(newText), "Insert text to match actual test result.", null, new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument xtextDocument = context.getXtextDocument();
                xtextDocument.replace(issue.getOffset().intValue(), 0, newText);
            }
        });
    }

    @Fix(value="org.eclipse.xpect.live_test_execution.expectation_change")
    public void replace(final Issue issue, IssueResolutionAcceptor acceptor) {
        final String newText = issue.getData()[0];
        acceptor.accept(issue, "Replace with " + this.quote(newText), "Replace with actual test result.", null, new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument xtextDocument = context.getXtextDocument();
                xtextDocument.replace(issue.getOffset().intValue(), issue.getLength().intValue(), newText);
            }
        });
    }

    private String quote(String newText) {
        String label = newText;
        if (newText.length() > 20) {
            label = String.valueOf(newText.substring(0, 20)) + "...";
        }
        label = "'" + label.replace("\n", "\\n").replace("\r", "\\r") + "'";
        return label;
    }

    public boolean hasExplicitResolutionFor(String issueCode) {
        if (issueCode == null) {
            return false;
        }
        Iterable methods = this.collectMethods(((Object)((Object)this)).getClass(), issueCode);
        return methods.iterator().hasNext();
    }
}

