/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.generator.headless;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.generator.headless.BuildSet;
import org.eclipse.n4js.generator.headless.HeadlessHelper;
import org.eclipse.n4js.generator.headless.N4JSCompileException;
import org.eclipse.n4js.generator.headless.logging.IHeadlessLogger;
import org.eclipse.n4js.internal.N4JSProject;
import org.eclipse.n4js.utils.URIUtils;
import org.eclipse.n4js.utils.collections.Collections2;

public class BuildSetComputer {
    @Inject
    private HeadlessHelper headlessHelper;
    @Inject
    private IHeadlessLogger logger;

    public BuildSet createSingleFileBuildSet(File singleSourceFile, Set<String> shadowedProjectNames) throws N4JSCompileException {
        return this.createSingleFilesBuildSet(Arrays.asList(singleSourceFile), shadowedProjectNames);
    }

    public BuildSet createSingleFilesBuildSet(List<File> singleSourceFiles, Set<String> shadowedProjectNames) throws N4JSCompileException {
        return this.createSingleFilesBuildSet(Collections.emptyList(), singleSourceFiles, shadowedProjectNames);
    }

    public BuildSet createSingleFilesBuildSet(List<File> searchPaths, List<File> singleSourceFiles, Set<String> shadowedProjectNames) throws N4JSCompileException {
        return this.createBuildSet(searchPaths, Collections.emptyList(), singleSourceFiles, shadowedProjectNames);
    }

    public BuildSet createProjectsBuildSet(List<File> projectPaths, Set<String> shadowedProjectNames) throws N4JSCompileException {
        return this.createProjectsBuildSet(Arrays.asList(new File(".")), projectPaths, shadowedProjectNames);
    }

    public BuildSet createProjectsBuildSet(List<File> searchPaths, List<File> projectPaths, Set<String> shadowedProjectNames) throws N4JSCompileException {
        return this.createBuildSet(searchPaths, projectPaths, Collections.emptyList(), shadowedProjectNames);
    }

    public BuildSet createAllProjectsBuildSet(List<File> searchPaths, Set<String> shadowedProjectNames) throws N4JSCompileException {
        List<File> absProjectPaths = this.headlessHelper.toAbsoluteFileList(searchPaths);
        List<File> projectPaths = this.headlessHelper.collectAllProjectPaths(absProjectPaths);
        return this.createBuildSet(searchPaths, projectPaths, Collections.emptyList(), shadowedProjectNames);
    }

    public BuildSet createBuildSet(List<File> searchPaths, List<File> projectPaths, List<File> singleSourceFiles, Set<String> shadowedProjectNames) throws N4JSCompileException {
        this.logBuildSetComputerConfiguration(searchPaths, projectPaths, singleSourceFiles);
        return this.collectProjects(searchPaths, projectPaths, singleSourceFiles, shadowedProjectNames);
    }

    private void logBuildSetComputerConfiguration(List<File> searchPaths, List<File> projectPaths, List<File> singleSourceFiles) {
        if (this.logger.isCreateDebugOutput()) {
            this.logger.debug("Computing build set with the following arguments");
            this.logger.debug("  Search paths: " + Joiner.on((String)", ").join(searchPaths));
            this.logger.debug("  Projects    : " + Joiner.on((String)", ").join(projectPaths));
            this.logger.debug("  Source files: " + Joiner.on((String)", ").join(singleSourceFiles));
        }
    }

    private BuildSet collectProjects(List<File> searchPaths, List<File> projectPaths, List<File> singleSourceFiles, Set<String> shadowedProjectNames) throws N4JSCompileException {
        Predicate<URI> resourceFilter;
        List<File> absSearchPaths = this.headlessHelper.toAbsoluteFileList(searchPaths);
        List<File> absProjectPaths = this.headlessHelper.toAbsoluteFileList(projectPaths);
        List<File> absSingleSourceFiles = this.headlessHelper.toAbsoluteFileList(singleSourceFiles);
        List<File> discoveredProjectLocations = this.headlessHelper.collectAllProjectPaths(absSearchPaths);
        List<File> singleSourceProjectLocations = this.findProjectsForSingleFiles(absSingleSourceFiles);
        List absRequestedProjectLocations = Collections2.concatUnique(absProjectPaths, singleSourceProjectLocations);
        List<URI> requestedProjectURIs = this.headlessHelper.createFileURIs(absRequestedProjectLocations);
        List<URI> discoveredProjectURIs = this.headlessHelper.createFileURIs(discoveredProjectLocations);
        List<N4JSProject> requestedProjects = this.headlessHelper.getN4JSProjects(requestedProjectURIs);
        List<N4JSProject> discoveredProjects = this.headlessHelper.getN4JSProjects(discoveredProjectURIs);
        Predicate<N4JSProject> pred = p -> shadowedProjectNames.contains(p.getProjectName());
        requestedProjects.removeIf(pred);
        discoveredProjects.removeIf(pred);
        if (absSingleSourceFiles.isEmpty()) {
            resourceFilter = u -> true;
        } else {
            HashSet<URI> singleSourceURIs = new HashSet<URI>(this.headlessHelper.createFileURIs(absSingleSourceFiles));
            resourceFilter = u -> singleSourceURIs.contains(u);
        }
        return new BuildSet(requestedProjects, discoveredProjects, resourceFilter);
    }

    private List<File> findProjectsForSingleFiles(List<File> sourceFiles) throws N4JSCompileException {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (File sourceFile : sourceFiles) {
            URI sourceFileURI = URI.createFileURI((String)sourceFile.toString());
            URI projectURI = this.findProjectLocationRecursivelyByProjectDescriptionFile(sourceFileURI);
            if (projectURI == null) {
                throw new N4JSCompileException("No project for file '" + sourceFile.toString() + "' found.");
            }
            result.add(projectURI);
        }
        return result.stream().map(URIUtils::normalize).map(u -> new File(u.toFileString())).collect(Collectors.toList());
    }

    private URI findProjectLocationRecursivelyByProjectDescriptionFile(URI location) {
        URI nestedLocation = location;
        int segmentCount = 0;
        if (nestedLocation.isFile()) {
            File directory = new File(nestedLocation.toFileString());
            while (directory != null) {
                if (directory.isDirectory() && new File(directory, "package.json").exists()) {
                    URI projectLocation = URI.createFileURI((String)directory.getAbsolutePath());
                    return projectLocation;
                }
                nestedLocation = nestedLocation.trimSegments(segmentCount++);
                directory = directory.getParentFile();
            }
        }
        return null;
    }
}

