/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.nodemodel;

import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.n4js.utils.nodemodel.CommentInfo;
import org.eclipse.n4js.utils.nodemodel.LeafInfo;
import org.eclipse.n4js.utils.nodemodel.WhitespaceInfo;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class HiddenLeafs {
    private final int offset;
    private final List<LeafInfo> leafs = CollectionLiterals.newArrayList();

    public boolean isSingleWhitespace() {
        return this.leafs.isEmpty() || this.leafs.size() == 1 && IterableExtensions.head(this.leafs) instanceof WhitespaceInfo;
    }

    public int getLenght() {
        Functions.Function2 _function = (x, i) -> {
            int _xifexpression = 0;
            ILeafNode _node = i.getNode();
            boolean _tripleEquals = _node == null;
            _xifexpression = _tripleEquals ? 0 : i.getNode().getLength();
            return x + _xifexpression;
        };
        return (Integer)IterableExtensions.fold(this.leafs, (Object)0, (Functions.Function2)_function);
    }

    public int getNewLines() {
        Functions.Function2 _function = (x, i) -> {
            int _newLines = i.getNewLines();
            return x + _newLines;
        };
        return (Integer)IterableExtensions.fold(this.leafs, (Object)0, (Functions.Function2)_function);
    }

    public int getNewLinesInComments() {
        Functions.Function2 _function = (x, i) -> {
            int _newLines = i.getNewLines();
            return x + _newLines;
        };
        return (Integer)IterableExtensions.fold((Iterable)Iterables.filter(this.leafs, CommentInfo.class), (Object)0, (Functions.Function2)_function);
    }

    public boolean containsComment() {
        int _size = IterableExtensions.size((Iterable)Iterables.filter(this.leafs, CommentInfo.class));
        return _size > 0;
    }

    public HiddenLeafs(int offset) {
        this.offset = offset;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.offset;
        result = 31 * result + (this.leafs == null ? 0 : this.leafs.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HiddenLeafs other = (HiddenLeafs)obj;
        if (other.offset != this.offset) {
            return false;
        }
        return !(this.leafs == null ? other.leafs != null : !this.leafs.equals(other.leafs));
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("offset", (Object)this.offset);
        b.add("leafs", this.leafs);
        return b.toString();
    }

    @Pure
    public int getOffset() {
        return this.offset;
    }

    @Pure
    public List<LeafInfo> getLeafs() {
        return this.leafs;
    }
}

