/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysis;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.ControlFlowEdge;
import org.eclipse.n4js.flowgraphs.model.Node;

abstract class NextEdgesProvider {
    private final Map<ControlFlowEdge, Integer> loopEnterEdges = new HashMap<ControlFlowEdge, Integer>();

    NextEdgesProvider() {
    }

    abstract boolean isForward();

    protected abstract Node getNextNode(ControlFlowEdge var1);

    protected abstract Node getPrevNode(ControlFlowEdge var1);

    protected abstract NextEdgesProvider copy();

    protected abstract Node getStartNode(ComplexNode var1);

    protected abstract Node getEndNode(ComplexNode var1);

    protected abstract Collection<ControlFlowEdge> getPlainPrevEdges(Node var1);

    protected abstract Collection<ControlFlowEdge> getPlainNextEdges(Node var1);

    abstract int getMaxOccurences(ControlFlowType var1);

    protected void reset() {
        this.loopEnterEdges.clear();
    }

    protected void join(NextEdgesProvider edgesProvider) {
        for (Map.Entry<ControlFlowEdge, Integer> repeatCounter : edgesProvider.loopEnterEdges.entrySet()) {
            ControlFlowEdge edge = repeatCounter.getKey();
            Integer otherCount = repeatCounter.getValue();
            int myCount = this.getOccurences(edge);
            int newCount = Math.max(myCount, otherCount);
            this.loopEnterEdges.put(edge, newCount);
        }
    }

    protected List<ControlFlowEdge> getNextEdges(Node nextNode, ControlFlowType ... flowTypes) {
        Collection<ControlFlowEdge> nextEdges = this.getPlainNextEdges(nextNode);
        List<ControlFlowEdge> filteredEdges = this.filter(nextEdges, flowTypes);
        return filteredEdges;
    }

    protected List<ControlFlowEdge> filter(Iterable<ControlFlowEdge> edges, ControlFlowType ... flowTypes) {
        LinkedList<ControlFlowEdge> filteredEdges = new LinkedList<ControlFlowEdge>();
        for (ControlFlowEdge cfEdge : edges) {
            boolean copyEdge = true;
            int maxOccurences = this.getMaxOccurences(cfEdge.cfType);
            if (maxOccurences > 0) {
                copyEdge = this.getOccurences(cfEdge) < maxOccurences;
                this.incrOccurence(cfEdge);
            }
            if (!copyEdge || !cfEdge.cfType.isInOrEmpty(flowTypes)) continue;
            filteredEdges.add(cfEdge);
        }
        return filteredEdges;
    }

    private int getOccurences(ControlFlowEdge edge) {
        Integer count = this.loopEnterEdges.getOrDefault(edge, 0);
        return count;
    }

    private void incrOccurence(ControlFlowEdge edge) {
        int count = this.getOccurences(edge) + 1;
        this.loopEnterEdges.put(edge, count);
    }

    public static class Backward
    extends NextEdgesProvider {
        Backward() {
        }

        Backward(Map<ControlFlowEdge, Integer> repeatEdges) {
            ((NextEdgesProvider)this).loopEnterEdges.putAll(repeatEdges);
        }

        @Override
        protected boolean isForward() {
            return false;
        }

        @Override
        protected Node getPrevNode(ControlFlowEdge edge) {
            return edge.end;
        }

        @Override
        protected Node getNextNode(ControlFlowEdge edge) {
            return edge.start;
        }

        @Override
        protected Node getStartNode(ComplexNode cn) {
            return cn.getExit();
        }

        @Override
        protected Node getEndNode(ComplexNode cn) {
            return cn.getEntry();
        }

        @Override
        protected Collection<ControlFlowEdge> getPlainNextEdges(Node nextNode) {
            Set<ControlFlowEdge> nextEdges = nextNode.getPredecessorEdges();
            return nextEdges;
        }

        @Override
        protected Collection<ControlFlowEdge> getPlainPrevEdges(Node nextNode) {
            Set<ControlFlowEdge> nextEdges = nextNode.getSuccessorEdges();
            return nextEdges;
        }

        @Override
        protected Backward copy() {
            return new Backward(new HashMap<ControlFlowEdge, Integer>(((NextEdgesProvider)this).loopEnterEdges));
        }

        @Override
        int getMaxOccurences(ControlFlowType cfType) {
            switch (cfType) {
                case LoopRepeat: {
                    return 2;
                }
                case LoopReenter: {
                    return 1;
                }
                case LoopInfinite: {
                    return 1;
                }
            }
            return -1;
        }
    }

    static class Forward
    extends NextEdgesProvider {
        Forward() {
        }

        Forward(Map<ControlFlowEdge, Integer> repeatEdges) {
            ((NextEdgesProvider)this).loopEnterEdges.putAll(repeatEdges);
        }

        @Override
        protected boolean isForward() {
            return true;
        }

        @Override
        protected Node getPrevNode(ControlFlowEdge edge) {
            return edge.start;
        }

        @Override
        protected Node getNextNode(ControlFlowEdge edge) {
            return edge.end;
        }

        @Override
        protected Node getStartNode(ComplexNode cn) {
            return cn.getEntry();
        }

        @Override
        protected Node getEndNode(ComplexNode cn) {
            return cn.getExit();
        }

        @Override
        protected Collection<ControlFlowEdge> getPlainNextEdges(Node nextNode) {
            Set<ControlFlowEdge> nextEdges = nextNode.getSuccessorEdges();
            return nextEdges;
        }

        @Override
        protected Collection<ControlFlowEdge> getPlainPrevEdges(Node nextNode) {
            Set<ControlFlowEdge> nextEdges = nextNode.getPredecessorEdges();
            return nextEdges;
        }

        @Override
        protected Forward copy() {
            return new Forward(new HashMap<ControlFlowEdge, Integer>(((NextEdgesProvider)this).loopEnterEdges));
        }

        @Override
        int getMaxOccurences(ControlFlowType cfType) {
            switch (cfType) {
                case LoopEnter: {
                    return 2;
                }
                case LoopReenter: {
                    return 1;
                }
                case LoopInfinite: {
                    return 1;
                }
            }
            return -1;
        }
    }
}

