/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.runner;

import com.google.common.primitives.Primitives;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import junit.framework.AssertionFailedError;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xpect.XjmContribution;
import org.eclipse.xpect.XjmTestMethod;
import org.eclipse.xpect.XjmXpectMethod;
import org.eclipse.xpect.XpectArgument;
import org.eclipse.xpect.XpectFile;
import org.eclipse.xpect.XpectInvocation;
import org.eclipse.xpect.XpectJavaModel;
import org.eclipse.xpect.expectation.impl.TargetSyntaxSupport;
import org.eclipse.xpect.runner.ArgumentContributor;
import org.eclipse.xpect.runner.ValidatingSetup;
import org.eclipse.xpect.setup.ISetupInitializer;
import org.eclipse.xpect.setup.ThisArgumentType;
import org.eclipse.xpect.setup.ThisRootTestClass;
import org.eclipse.xpect.setup.ThisTestClass;
import org.eclipse.xpect.setup.ThisTestObject;
import org.eclipse.xpect.setup.XpectSetupFactory;
import org.eclipse.xpect.state.Configuration;
import org.eclipse.xpect.state.Managed;
import org.eclipse.xpect.state.ResolvedConfiguration;
import org.eclipse.xpect.state.StateContainer;
import org.eclipse.xpect.util.EnvironmentUtil;

public class TestExecutor {
    private static Object cast(Managed<?> value, XpectArgument expectedType) {
        Class javaType;
        if (value == null) {
            throw new RuntimeException("Could not create value for " + expectedType.toString(true, true));
        }
        Class exactType = expectedType.getJavaType();
        Class clazz = javaType = exactType.isPrimitive() ? Primitives.wrap(exactType) : exactType;
        if (javaType.isInstance(javaType)) {
            return javaType;
        }
        Object object = value.get();
        if (object != null && !javaType.isInstance(object)) {
            throw new RuntimeException("Object of type " + object.getClass().getName() + " is not assignable to argument " + expectedType.toString(true, true));
        }
        return object;
    }

    private static Configuration[] createArgumentConfigurations(XpectInvocation statement) {
        EList<XpectArgument> arguments = statement.getArguments();
        Configuration[] result = new Configuration[arguments.size()];
        int i = 0;
        while (i < arguments.size()) {
            XpectArgument argument = (XpectArgument)arguments.get(i);
            Configuration configuration = new Configuration(argument.toString(false, true));
            configuration.addDefaultValue(XpectArgument.class, argument);
            configuration.addValue(ThisArgumentType.class, argument.getJavaType());
            result[i] = configuration;
            ++i;
        }
        return result;
    }

    private static StateContainer[] createArgumentStateContainers(StateContainer state, ResolvedConfiguration[] configurations) {
        StateContainer[] result = new StateContainer[configurations.length];
        int i = 0;
        while (i < configurations.length) {
            result[i] = new StateContainer(state, configurations[i]);
            ++i;
        }
        return result;
    }

    private static Object[] createArgumentValues(StateContainer[] stateContainers, XpectInvocation invocation) {
        EList<XpectArgument> arguments = invocation.getArguments();
        Object[] result = new Object[stateContainers.length];
        int i = 0;
        while (i < stateContainers.length) {
            StateContainer state = stateContainers[i];
            XpectArgument argument = (XpectArgument)arguments.get(i);
            try {
                Class<?> keyType = argument.getJavaType();
                Annotation keyAnnotation = argument.getStateAnnotation();
                Managed<?> managed = keyAnnotation != null ? state.get(keyType, keyAnnotation) : state.get(keyType, new Object[0]);
                result[i] = TestExecutor.cast(managed, argument);
            }
            catch (Throwable t) {
                throw new RuntimeException("Error creating value for argument " + argument.toString(true, true), t);
            }
            ++i;
        }
        return result;
    }

    public static Configuration createTestConfiguration(XjmTestMethod method) {
        Configuration config = new Configuration(String.valueOf(method.getName()) + "()");
        config.addValue(ThisTestClass.class, Class.class, method.getTest().getJavaClass());
        config.addDefaultValue(XjmTestMethod.class, method);
        return config;
    }

    public static Configuration createXpectConfiguration(XpectInvocation invocation) {
        Configuration config = new Configuration(String.valueOf(invocation.getMethodName()) + "(...)");
        config.addValue(ThisTestClass.class, Class.class, invocation.getMethod().getTest().getJavaClass());
        config.addDefaultValue(XpectInvocation.class, invocation);
        config.addDefaultValue(XjmXpectMethod.class, invocation.getMethod());
        return config;
    }

    public static Configuration createFileConfiguration(XpectFile file) {
        Configuration config = new Configuration(file.eResource().getURI().lastSegment());
        config.addDefaultValue(XpectFile.class, file);
        config.addDefaultValue(ISetupInitializer.class, file.createSetupInitializer());
        return config;
    }

    public static Configuration createRootConfiguration(XpectJavaModel model) {
        Configuration config = new Configuration("Root");
        config.addValue(ThisRootTestClass.class, model.getTestOrSuite().getJavaClass());
        config.addFactory(ThisTestObject.TestObjectSetup.class);
        config.addFactory(ValidatingSetup.class);
        config.addFactory(TargetSyntaxSupport.class);
        config.addFactory(ArgumentContributor.class);
        config.addDefaultValue(XpectJavaModel.class, model);
        Iterable<XjmContribution> contributions = model.getContributions(XpectSetupFactory.class, EnvironmentUtil.ENVIRONMENT);
        for (XjmContribution contribution : contributions) {
            if (!contribution.isActive()) continue;
            config.addFactory(contribution.getJavaClass());
        }
        return config;
    }

    public static StateContainer createState(Configuration config) {
        return new StateContainer(new ResolvedConfiguration(config));
    }

    public static StateContainer createState(StateContainer state, Configuration config) {
        return new StateContainer(state, new ResolvedConfiguration(state.getConfiguration(), config));
    }

    private static ResolvedConfiguration[] resolveArgumentConfiguration(StateContainer state, Configuration[] configurations) {
        ResolvedConfiguration[] result = new ResolvedConfiguration[configurations.length];
        int i = 0;
        while (i < configurations.length) {
            result[i] = new ResolvedConfiguration(state.getConfiguration(), configurations[i]);
            ++i;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static void runTest(StateContainer state, XpectInvocation invocation) throws Throwable {
        block7: {
            test = state.get(Object.class, new Object[]{ThisTestObject.class}).get();
            fixmeMessage = false;
            try {
                contributor = state.get(ArgumentContributor.class, new Object[0]).get();
                configurations = TestExecutor.createArgumentConfigurations(invocation);
                contributor.contributeArguments(configurations);
                resolved = TestExecutor.resolveArgumentConfiguration(state, configurations);
                states = TestExecutor.createArgumentStateContainers(state, resolved);
                try {
                    args = TestExecutor.createArgumentValues(states, invocation);
                    invocation.getMethod().getJavaMethod().invoke(test, args);
                    if (invocation.isFixme()) {
                        fixmeMessage = true;
                        throw new InvocationTargetException((Throwable)new AssertionFailedError("Congrats, this FIXME test is suddenly fixed!"));
                    }
                }
                finally {
                    var13_13 = states;
                    var12_15 = states.length;
                    var11_17 = 0;
                    if (true) ** GOTO lbl28
                }
                {
                }
                do {
                    s = var13_13[var11_17];
                    s.invalidate();
                    ++var11_17;
lbl28:
                    // 2 sources

                } while (var11_17 < var12_15);
            }
            catch (InvocationTargetException e) {
                cause = e.getCause();
                if (invocation.isFixme() && !fixmeMessage) break block7;
                throw cause;
            }
        }
    }
}

