/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner.extension;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.n4js.runner.IRunner;
import org.eclipse.n4js.runner.extension.IRunnerDescriptor;
import org.eclipse.n4js.runner.extension.RuntimeEnvironment;

public class EclipseRunnerDescriptor
implements IRunnerDescriptor {
    private static final Logger log = Logger.getLogger(EclipseRunnerDescriptor.class);
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ENVIRONMENT = "environment";
    private static final String ATTR_CLASS = "class";
    private final IConfigurationElement configElem;
    private final String id;
    private final String name;
    private final RuntimeEnvironment environment;
    private IRunner runner;
    @Inject
    private Injector injector;

    public EclipseRunnerDescriptor(IConfigurationElement configElem) {
        this.configElem = configElem;
        if (this.configElem == null) {
            throw new IllegalArgumentException("configElem may not be null");
        }
        this.id = configElem.getAttribute(ATTR_ID);
        if (this.id == null || this.id.trim().isEmpty()) {
            throw new IllegalArgumentException("extension attribute 'id' may not be null or empty");
        }
        this.name = configElem.getAttribute(ATTR_NAME);
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new IllegalArgumentException("extension attribute 'name' may not be null or empty");
        }
        String environmentRaw = configElem.getAttribute(ATTR_ENVIRONMENT);
        if (environmentRaw == null || environmentRaw.trim().isEmpty()) {
            throw new IllegalArgumentException("extension attribute 'environment' may not be null or empty");
        }
        this.environment = RuntimeEnvironment.fromProjectName(environmentRaw);
        if (this.environment == null) {
            throw new IllegalArgumentException("unknown runtime environment: " + environmentRaw + " (valid values are: " + Stream.of(RuntimeEnvironment.values()).map(re -> re.getProjectName()).collect(Collectors.joining(", ")) + ")");
        }
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configElem;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RuntimeEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public IRunner getRunner() {
        if (this.runner == null) {
            try {
                this.runner = (IRunner)this.getConfigurationElement().createExecutableExtension(ATTR_CLASS);
                this.injector.injectMembers((Object)this.runner);
            }
            catch (CoreException ex) {
                log.error((Object)"error while creating executable extension from attribute 'class'", (Throwable)ex);
            }
        }
        return this.runner;
    }
}

