/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.projectDescription;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ModuleLoader implements Enumerator
{
    N4JS(0, "N4JS", "N4JS"),
    COMMONJS(1, "COMMONJS", "COMMONJS"),
    NODE_BUILTIN(2, "NODE_BUILTIN", "NODE_BUILTIN");

    public static final int N4JS_VALUE = 0;
    public static final int COMMONJS_VALUE = 1;
    public static final int NODE_BUILTIN_VALUE = 2;
    private static final ModuleLoader[] VALUES_ARRAY;
    public static final List<ModuleLoader> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ModuleLoader[]{N4JS, COMMONJS, NODE_BUILTIN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ModuleLoader get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModuleLoader result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModuleLoader getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModuleLoader result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModuleLoader get(int value) {
        switch (value) {
            case 0: {
                return N4JS;
            }
            case 1: {
                return COMMONJS;
            }
            case 2: {
                return NODE_BUILTIN;
            }
        }
        return null;
    }

    private ModuleLoader(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

