/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.factories;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.ASTIterator;
import org.eclipse.n4js.flowgraphs.factories.CFEFactoryDispatcher;
import org.eclipse.n4js.flowgraphs.factories.CFEMapper;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.Script;

public class ReentrantASTIterator {
    static final String ASSERTION_MSG_AST_ORDER = "DelegatingNode or AST order erroneous";
    private final Set<ControlFlowElement> cfContainers;
    private final Map<ControlFlowElement, ComplexNode> cnMap;
    private final ASTIterator astIt;
    private int astPositionCounter = 0;

    ReentrantASTIterator(Set<ControlFlowElement> cfContainers, Map<ControlFlowElement, ComplexNode> cnMap, Script script) {
        this.cfContainers = cfContainers;
        this.cnMap = cnMap;
        this.astIt = new ASTIterator((EObject)script);
    }

    public void visitAll() {
        this.visitUtil(null);
    }

    public void visitUtil(ControlFlowElement termNode) {
        termNode = CFEMapper.map(termNode);
        while (this.astIt.hasNext()) {
            ComplexNode cn;
            ControlFlowElement mappedCFE;
            ControlFlowElement cfe = this.astIt.next();
            if (cfe != (mappedCFE = CFEMapper.map(cfe))) continue;
            if (mappedCFE != null && !this.cnMap.containsKey(mappedCFE) && (cn = CFEFactoryDispatcher.build(this, (EObject)mappedCFE)) != null) {
                Preconditions.checkState((this.astPositionCounter - 1 == cn.getExit().astPosition ? 1 : 0) != 0, (Object)ASSERTION_MSG_AST_ORDER);
                this.cfContainers.add(cn.getControlFlowContainer());
                this.cnMap.put(mappedCFE, cn);
            }
            if (termNode != cfe && (termNode != mappedCFE || termNode == null)) continue;
            return;
        }
        Preconditions.checkState((termNode == null ? 1 : 0) != 0, (Object)ASSERTION_MSG_AST_ORDER);
    }

    public ControlFlowElement container() {
        return this.astIt.container();
    }

    public int pos() {
        return this.astPositionCounter++;
    }
}

