/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.validation.TypesKeywordProvider;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.xtext.ui.editor.hover.html.DefaultEObjectHoverProvider;

public class TypesHoverProvider
extends DefaultEObjectHoverProvider {
    @Inject
    private TypesKeywordProvider keywordProvider;
    private static final String CSS_STYLE_KEYWORD = "color:white;background-color:gray;border: 1px solid gray;padding-left:3px;padding-right:3px;border-radius:6px;";

    protected String getFirstLine(EObject obj) {
        String keyword = this.keywordProvider.keyword((Object)obj);
        String label = this.getLabel(obj);
        return TypesHoverProvider.composeFirstLine(keyword, label);
    }

    public String getLabel(EObject obj) {
        if (obj instanceof TFunction) {
            return UtilN4.sanitizeForHTML((String)((TFunction)obj).getFunctionAsString());
        }
        if (obj instanceof TMember) {
            return UtilN4.sanitizeForHTML((String)((TMember)obj).getMemberAsString());
        }
        if (obj instanceof TFormalParameter) {
            return UtilN4.sanitizeForHTML((String)((TFormalParameter)obj).getFormalParameterAsString());
        }
        if (obj instanceof Type) {
            return UtilN4.sanitizeForHTML((String)((Type)obj).getTypeAsString());
        }
        if (obj instanceof TypeRef) {
            return UtilN4.sanitizeForHTML((String)((TypeRef)obj).getTypeRefAsString());
        }
        if (obj instanceof TVariable) {
            return UtilN4.sanitizeForHTML((String)((TVariable)obj).getVariableAsString());
        }
        return super.getLabel(obj);
    }

    public boolean hasHover(EObject obj) {
        if (obj instanceof TMember || obj instanceof TFunction) {
            return true;
        }
        return super.hasHover(obj);
    }

    public static final String composeFirstLine(String keyword, String label) {
        String htmlLabel = label != null && !label.contains("<b>") ? "<b>" + label + "</b>" : label;
        return "<span style=\"color:white;background-color:gray;border: 1px solid gray;padding-left:3px;padding-right:3px;border-radius:6px;\">" + keyword + "</span>" + (htmlLabel != null ? " " + htmlLabel : "");
    }
}

