/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.external;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.log4j.Logger;
import org.eclipse.n4js.external.libraries.ExternalLibraryFolderUtils;

public interface TargetPlatformInstallLocationProvider {
    public static final Logger LOGGER = Logger.getLogger(TargetPlatformInstallLocationProvider.class);
    public static final String NODE_MODULES_FOLDER = "node_modules";

    public File getTargetPlatformInstallFolder();

    default public URI getTargetPlatformInstallURI() {
        File tpFolder = this.getTargetPlatformInstallFolder();
        return tpFolder == null ? null : tpFolder.toURI();
    }

    public URI getTargetPlatformFileLocation();

    default public URI getNodeModulesURI() {
        return this.getURIInTargetPlatformLocation(NODE_MODULES_FOLDER);
    }

    default public File getNodeModulesFolder() {
        return this.getFolderInTargetPlatformLocation(NODE_MODULES_FOLDER);
    }

    default public URI getURIInTargetPlatformLocation(String folderName) {
        return this.getFolderInTargetPlatformLocation(folderName).toURI();
    }

    default public File getFolderInTargetPlatformLocation(String folderName) {
        String string = folderName;
        synchronized (string) {
            File installLocation = this.getTargetPlatformInstallFolder();
            if (installLocation == null) {
                String message = "Target platform install location was not specified.";
                NullPointerException exception = new NullPointerException(message);
                LOGGER.error((Object)message, (Throwable)exception);
                exception.printStackTrace();
                throw exception;
            }
            Preconditions.checkState((boolean)installLocation.isDirectory(), (Object)("Cannot locate target platform install location: " + installLocation));
            File folder = new File(installLocation, folderName);
            if (!folder.exists()) {
                Preconditions.checkState((boolean)folder.mkdir(), (Object)("Error while creating " + folderName + " folder for target platform."));
            }
            Preconditions.checkState((boolean)folder.isDirectory(), (Object)("Cannot locate " + folderName + " folder in target platform location."));
            try {
                return folder.getCanonicalFile();
            }
            catch (IOException e) {
                throw new RuntimeException("Error while getting the canonical form of the " + folderName + " location.", e);
            }
        }
    }

    default public boolean repairNpmFolderState() {
        boolean success = true;
        File installLocation = this.getTargetPlatformInstallFolder();
        if (!installLocation.isDirectory()) {
            success &= installLocation.mkdir();
        }
        if (success) {
            File targetPlatformDefinitionFile = ExternalLibraryFolderUtils.createTargetPlatformDefinitionFile((File)installLocation);
            File npmFile = this.getNodeModulesFolder();
            success &= targetPlatformDefinitionFile != null && targetPlatformDefinitionFile.isFile();
            success &= npmFile != null && npmFile.isDirectory();
        }
        return success;
    }
}

