/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.ui.services;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xpect.Environment;
import org.eclipse.xpect.XpectFile;
import org.eclipse.xpect.registry.DefaultBinding;
import org.eclipse.xpect.runner.TestExecutor;
import org.eclipse.xpect.state.Configuration;
import org.eclipse.xpect.ui.services.LiveTestRunner;
import org.eclipse.xpect.ui.util.XpectFileAccess;
import org.eclipse.xpect.util.EnvironmentUtil;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class XtResourceValidator
implements IResourceValidator {
    @Inject
    @DefaultBinding
    private IResourceValidator delegate;
    @Inject
    private Injector injector;

    public IResourceValidator getDelegate() {
        return this.delegate;
    }

    public List<Issue> validate(Resource resource, CheckMode mode, CancelIndicator indicator) {
        List<Issue> xpectIssues;
        XpectFile xpectFile = XpectFileAccess.getXpectFile(resource);
        Configuration fileConfig = TestExecutor.createFileConfiguration((XpectFile)xpectFile);
        ArrayList issues = Lists.newArrayList();
        List<Issue> delegateIssues = this.validateDelegate(resource, mode, indicator, fileConfig);
        if (delegateIssues != null) {
            issues.addAll(delegateIssues);
        }
        if ((xpectIssues = this.validateXpect(resource, mode, indicator, fileConfig)) != null) {
            issues.addAll(xpectIssues);
        }
        if (EnvironmentUtil.ENVIRONMENT == Environment.WORKBENCH) {
            LiveTestRunner runner = (LiveTestRunner)this.injector.getInstance(LiveTestRunner.class);
            List<Issue> testResultIssues = runner.validateTests(resource, mode, indicator, fileConfig);
            issues.addAll(testResultIssues);
        }
        return issues;
    }

    public List<Issue> validateDelegate(Resource resource, CheckMode mode, CancelIndicator indicator, Configuration fileConfig) {
        List issues = this.delegate.validate(resource, mode, indicator);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)issues.size());
        for (Issue issue : issues) {
            if (issue == null) continue;
            result.add(issue);
        }
        return result;
    }

    public List<Issue> validateXpect(Resource resource, CheckMode mode, CancelIndicator indicator, Configuration fileConfig) {
        XtextResource xpectResource = XpectFileAccess.getXpectResource(resource);
        IResourceValidator validator = xpectResource.getResourceServiceProvider().getResourceValidator();
        return validator.validate((Resource)xpectResource, mode, indicator);
    }
}

