/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.factories;

import java.util.LinkedList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.FGUtils;
import org.eclipse.n4js.flowgraphs.factories.ASTUtils;
import org.eclipse.n4js.flowgraphs.factories.DelegatingNodeFactory;
import org.eclipse.n4js.flowgraphs.factories.ReentrantASTIterator;
import org.eclipse.n4js.flowgraphs.model.CatchToken;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.DelegatingNode;
import org.eclipse.n4js.flowgraphs.model.HelperNode;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.LabelledStatement;
import org.eclipse.n4js.n4JS.Statement;

class BlockFactory {
    BlockFactory() {
    }

    static ComplexNode buildComplexNode(ReentrantASTIterator astpp, Block block) {
        ComplexNode cNode = new ComplexNode(astpp.container(), (ControlFlowElement)block);
        HelperNode entryNode = new HelperNode("entry", astpp.pos(), (ControlFlowElement)block);
        LinkedList<Object> blockNodes = new LinkedList<Object>();
        EList stmts = block.getStatements();
        int i = 0;
        while (i < stmts.size()) {
            Statement statement = (Statement)stmts.get(i);
            DelegatingNode blockNode = DelegatingNodeFactory.create(astpp, "stmt_" + i, (ControlFlowElement)block, (ControlFlowElement)statement);
            blockNodes.add(blockNode);
            ++i;
        }
        HelperNode exitNode = new HelperNode("exit", astpp.pos(), (ControlFlowElement)block);
        cNode.addNode(entryNode);
        for (Node node : blockNodes) {
            cNode.addNode(node);
        }
        cNode.addNode(exitNode);
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.add(entryNode);
        linkedList.addAll(blockNodes);
        linkedList.add(exitNode);
        cNode.connectInternalSucc(linkedList);
        cNode.setEntryNode(entryNode);
        cNode.setExitNode(exitNode);
        if (FGUtils.isCFContainer((EObject)block)) {
            exitNode.addCatchToken(new CatchToken(ControlFlowType.CatchesAll));
        } else {
            LabelledStatement lblStmt = ASTUtils.getLabelledStatement((Statement)block);
            if (lblStmt != null) {
                exitNode.addCatchToken(new CatchToken(ControlFlowType.Break, lblStmt));
            }
        }
        return cNode;
    }
}

