/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec.adoc;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.jsdoc2spec.JSDoc2SpecProcessor;
import org.eclipse.n4js.jsdoc2spec.KeyUtils;
import org.eclipse.n4js.jsdoc2spec.SpecElementRef;
import org.eclipse.n4js.jsdoc2spec.SpecFile;
import org.eclipse.n4js.jsdoc2spec.SpecInfo;
import org.eclipse.n4js.jsdoc2spec.SubMonitorMsg;
import org.eclipse.n4js.jsdoc2spec.adoc.ADocFactory;
import org.eclipse.n4js.jsdoc2spec.adoc.IndicesCreator;
import org.eclipse.n4js.jsdoc2spec.adoc.RepoRelativePathHolder;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecIdentifiableElementSection;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecModuleFile;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecRequirementFile;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecRequirementSection;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecSection;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TN4Classifier;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.util.MemberList;
import org.eclipse.n4js.utils.ContainerTypesHelper;

public class JSDoc2ADocSpecProcessor
extends JSDoc2SpecProcessor {
    private File rootDir;
    @Inject
    private ADocFactory adocFactory;
    @Inject
    private RepoRelativePathHolder repoPathHolder;

    @Override
    public void setRootDir(File newRootDir) {
        this.rootDir = newRootDir;
    }

    @Override
    public Collection<SpecFile> computeUpdates(Collection<SpecInfo> specInfos, SubMonitorMsg monitor) throws IOException, InterruptedException {
        Collection<SpecFile> newSpecSet = this.createNewEntries(specInfos, monitor);
        List<SpecFile> indexChangeFiles = IndicesCreator.createIndexFiles(this.rootDir, newSpecSet);
        newSpecSet.addAll(indexChangeFiles);
        Collection<SpecFile> changeSpecSet = this.filterChangedFiles(newSpecSet);
        return changeSpecSet;
    }

    private Collection<SpecFile> createNewEntries(Collection<SpecInfo> specInfos, SubMonitorMsg monitor) throws InterruptedException {
        TreeMap<String, SpecFile> specChangeSet = new TreeMap<String, SpecFile>();
        HashMap<String, SpecSection> specsByKey = new HashMap<String, SpecSection>();
        SubMonitorMsg sub = monitor.convert(specInfos.size());
        for (SpecInfo specInfo : specInfos) {
            SpecElementRef specElementRef = specInfo.specElementRef;
            String specKey = KeyUtils.getSpecKey(this.repoPathHolder, specInfo);
            if (specsByKey.containsKey(specKey)) {
                throw new RuntimeException("Unexpected!");
            }
            SpecSection specSection = null;
            if (specElementRef.requirementID != null) {
                specSection = new SpecRequirementSection(specInfo, this.rootDir, this.repoPathHolder);
                specSection.generateADocText(this.adocFactory, specsByKey);
                specsByKey.put(specSection.getSpecKey(), specSection);
                SpecRequirementFile srf = new SpecRequirementFile((SpecRequirementSection)specSection);
                specChangeSet.put(specSection.getSpecModuleKey(), srf);
            }
            if (specElementRef.identifiableElement != null) {
                specSection = new SpecIdentifiableElementSection(specInfo, this.rootDir, this.repoPathHolder);
                SpecIdentifiableElementSection sies = (SpecIdentifiableElementSection)specSection;
                this.insertIntoSpecModuleFile(specChangeSet, specsByKey, sies);
                this.addMembers(sies.specInfo, specsByKey, specChangeSet);
            }
            sub.worked(1);
            this.checkUserCanceled(sub);
        }
        HashSet<SpecFile> changeEntries = new HashSet<SpecFile>();
        changeEntries.addAll(specChangeSet.values());
        return changeEntries;
    }

    private void addMembers(SpecInfo specInfo, Map<String, SpecSection> specsByKey, TreeMap<String, SpecFile> specChangeSet) {
        IdentifiableElement element = specInfo.specElementRef.identifiableElement;
        if (element instanceof TN4Classifier) {
            this.addMembers(specInfo, (TN4Classifier)element, specsByKey, specChangeSet);
            Type pfaElement = specInfo.specElementRef.polyfillAware;
            if (pfaElement instanceof TN4Classifier) {
                this.addMembers(specInfo, (TN4Classifier)pfaElement, specsByKey, specChangeSet);
            }
        }
    }

    private void addMembers(SpecInfo specInfo, TN4Classifier classifier, Map<String, SpecSection> specsByKey, TreeMap<String, SpecFile> specChangeSet) {
        ContainerTypesHelper.MemberCollector memberCollector = this.containerTypesHelper.fromContext((EObject)classifier);
        MemberList memberList = memberCollector.allMembers((ContainerType)classifier, false, false, false);
        Stream<? super TMember> nonPrivMembs = memberList.stream().filter(this.isNonPrivate());
        for (TMember member : nonPrivMembs::iterator) {
            SpecIdentifiableElementSection specSection = new SpecIdentifiableElementSection(specInfo, member, this.rootDir, this.repoPathHolder);
            if (specsByKey.containsKey(((SpecSection)specSection).getSpecKey())) continue;
            specSection.setTestInfosForMember(specInfo.getTestsForMember(member));
            this.insertIntoSpecModuleFile(specChangeSet, specsByKey, specSection);
        }
    }

    private void insertIntoSpecModuleFile(TreeMap<String, SpecFile> specFiles, Map<String, SpecSection> specsByKey, SpecIdentifiableElementSection specSection) {
        SpecFile scf;
        String specKey = specSection.getSpecKey();
        specsByKey.put(specKey, specSection);
        String moduleKey = specSection.getSpecModuleKey();
        if (!specFiles.containsKey(moduleKey)) {
            scf = new SpecModuleFile(specSection.getFile());
            specFiles.put(moduleKey, scf);
        }
        scf = specFiles.get(moduleKey);
        specSection.generateADocText(this.adocFactory, specsByKey);
        scf.add(specSection);
    }

    private Predicate<? super TMember> isNonPrivate() {
        return m -> m.getMemberAccessModifier() != MemberAccessModifier.PRIVATE;
    }

    private Collection<SpecFile> filterChangedFiles(Collection<SpecFile> newSpecSet) throws IOException {
        ArrayList<SpecFile> changedFiles = new ArrayList<SpecFile>();
        for (SpecFile scf : newSpecSet) {
            String newContent;
            String oldContent;
            boolean fileChanged;
            boolean fileExists = scf.getFile().exists();
            boolean bl = fileChanged = !fileExists;
            if (fileExists && !(oldContent = Files.toString((File)scf.getFile(), (Charset)Charsets.UTF_8).replace("\r\n", "\n")).equals(newContent = scf.getNewContent())) {
                fileChanged = true;
            }
            if (!fileChanged) continue;
            changedFiles.add(scf);
        }
        return changedFiles;
    }

    private void checkUserCanceled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled() || Thread.interrupted()) {
            throw new InterruptedException("User canceled Operation.");
        }
    }
}

