/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.binaries;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.io.File;
import java.net.URI;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.n4js.binaries.BinariesPreferenceStore;
import org.eclipse.n4js.binaries.BinariesProvider;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class BinariesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = BinariesPreferencePage.class.getName();
    private static final long VALIDATION_DELAY_MS = 300L;
    private static final int DESCRIPTION_H_HINT = 400;
    @Inject
    private BinariesPreferenceStore store;
    @Inject
    private BinariesProvider binariesProvider;

    public void init(IWorkbench workbench) {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite body = new Composite(parent, 0);
        body.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        body.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).align(4, 4).create());
        Iterable binaries = this.binariesProvider.getRegisteredBinaries();
        for (Binary binary : binaries) {
            Group binaryGroup = new Group(body, 16);
            binaryGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(true).create());
            binaryGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).align(4, 128).create());
            this.recursiveAddBinaryGroup((Composite)binaryGroup, binary);
        }
        for (Binary binary : binaries) {
            IStatus status = binary.validate();
            if (status.isOK()) continue;
            this.setErrorMessage(status.getMessage());
            break;
        }
        return body;
    }

    private void recursiveAddBinaryGroup(Composite parent, final Binary binary) {
        Group binaryGroup = new Group(parent, 16);
        binaryGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).create());
        binaryGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).align(4, 128).create());
        binaryGroup.setText(binary.getLabel());
        DirectoryFieldEditor editor = new DirectoryFieldEditor("", "Path:", (Composite)binaryGroup);
        URI path = this.store.getPath(binary);
        if (path != null) {
            File file = new File(path);
            editor.setStringValue(file.getAbsolutePath());
        }
        editor.setPropertyChangeListener(event -> {
            if (event != null && "field_editor_value".equals(event.getProperty())) {
                this.updateStoreState(binary, event.getNewValue());
            }
        });
        final Text text = editor.getTextControl((Composite)binaryGroup);
        ModifyListener modifyListener = new ModifyListener(){
            private Timer timer;

            public void modifyText(ModifyEvent e) {
                if (this.timer != null) {
                    this.timer.cancel();
                    this.timer = null;
                }
                this.timer = new Timer("'" + binary.getLabel() + "' binary validation thread");
                final String newValue = text.getText();
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        BinariesPreferencePage.this.updateStoreState(binary, newValue);
                    }
                }, 300L);
            }
        };
        text.addModifyListener(modifyListener);
        text.addDisposeListener(e -> text.removeModifyListener(modifyListener));
        String description = binary.getDescription();
        if (description != null) {
            Label descriptionLabel = new Label((Composite)binaryGroup, 64);
            descriptionLabel.setText(description);
            GridData gridData = new GridData(4, 128, true, false, 3, 1);
            gridData.widthHint = 400;
            descriptionLabel.setLayoutData((Object)gridData);
        }
        for (Binary child : binary.getChildren()) {
            this.recursiveAddBinaryGroup(parent, child);
        }
    }

    private void updateStoreState(Binary binary, Object newValue) {
        if (newValue instanceof String && !Strings.isNullOrEmpty((String)((String)newValue))) {
            File file = new File(String.valueOf(newValue));
            this.store.setPath(binary, file.toURI());
        } else {
            this.store.setPath(binary, null);
        }
        this.store.save();
        final IStatus status = binary.validate();
        UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Control control = BinariesPreferencePage.this.getControl();
                if (control != null && !control.isDisposed()) {
                    if (!status.isOK()) {
                        BinariesPreferencePage.this.setErrorMessage(status.getMessage());
                    } else {
                        BinariesPreferencePage.this.setErrorMessage(null);
                    }
                }
            }
        });
    }
}

