/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.compare.ApiImplMapping;
import org.eclipse.n4js.generator.AbstractSubGenerator;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.runner.extension.IRunnerDescriptor;
import org.eclipse.n4js.runner.extension.RunnerRegistry;
import org.eclipse.n4js.runner.extension.RuntimeEnvironment;
import org.eclipse.n4js.utils.FindArtifactHelper;
import org.eclipse.n4js.utils.RecursionGuard;
import org.eclipse.n4js.utils.ResourceNameComputer;
import org.eclipse.xtext.xbase.lib.Pair;

public class RunnerHelper {
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private FindArtifactHelper artifactHelper;
    @Inject
    private ResourceNameComputer compilerHelper;
    @Inject
    private RunnerRegistry runnerRegistry;

    public Map<Path, String> getCoreProjectPaths(Set<IN4JSProject> projects) {
        return projects.stream().map(project -> this.getProjectNameAndPath((IN4JSProject)project)).filter(nap -> nap != null).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    private Pair<Path, String> getProjectNameAndPath(IN4JSProject project) {
        if (!project.exists()) {
            return null;
        }
        String name = project.getProjectName();
        if (name == null) {
            return null;
        }
        Path path = project.getLocationPath();
        if (path == null) {
            return null;
        }
        Path pathNormalized = path.normalize().toAbsolutePath();
        if (pathNormalized.toString().isEmpty()) {
            return null;
        }
        return Pair.of((Object)pathNormalized, (Object)name);
    }

    public List<String> getInitModulePaths(List<IN4JSProject> extendedDeps) {
        return extendedDeps.stream().filter(p -> {
            ProjectType pt = p.getProjectType();
            return ProjectType.RUNTIME_LIBRARY.equals((Object)pt) || ProjectType.RUNTIME_ENVIRONMENT.equals((Object)pt);
        }).flatMap(p -> this.getInitModulesAsURIs((IN4JSProject)p).stream().map(bmURI -> this.getProjectRelativePath((IN4JSProject)p, this.compilerHelper.generateFileDescriptor(p, bmURI, "js")))).collect(Collectors.toList());
    }

    public Optional<String> getExecModuleURI(List<IN4JSProject> extendedDeps) {
        List execModules = extendedDeps.stream().filter(p -> ProjectType.RUNTIME_ENVIRONMENT.equals((Object)p.getProjectType())).map(re -> {
            Optional oExecModuleSpecifier = re.getExecModule().transform(bootstrapModule -> bootstrapModule.getModuleSpecifier());
            if (!oExecModuleSpecifier.isPresent()) {
                return null;
            }
            return this.getProjectRelativePath((IN4JSProject)re, String.valueOf((String)oExecModuleSpecifier.get()) + "." + "js");
        }).filter(s -> !Strings.isNullOrEmpty((String)s)).collect(Collectors.toList());
        if (execModules.size() >= 1) {
            return Optional.of((Object)((String)execModules.get(0)));
        }
        return Optional.absent();
    }

    private String getProjectRelativePath(IN4JSProject project, String subPath) {
        return String.valueOf(AbstractSubGenerator.calculateProjectBasedOutputDirectory((IN4JSProject)project)) + "/" + subPath;
    }

    public ApiUsage getProjectExtendedDeps(String runnerId, URI moduleToRun) {
        IRunnerDescriptor runnerDesc = this.runnerRegistry.getDescriptor(runnerId);
        return this.getProjectExtendedDepsAndApiImplMapping(runnerDesc.getEnvironment(), moduleToRun, null, false);
    }

    public void recursiveExtendedREsCollector(IN4JSProject sourceContainer, Collection<IN4JSProject> addHere) {
        this.recursiveExtendedREsCollector(sourceContainer, addHere, this.n4jsCore.findAllProjects());
    }

    public void recursiveExtendedREsCollector(IN4JSProject project, Collection<IN4JSProject> addHere, Iterable<IN4JSProject> projects) {
        if (project.getProjectType().equals((Object)ProjectType.RUNTIME_ENVIRONMENT)) {
            addHere.add(project);
            project.getProvidedRuntimeLibraries().forEach(rl -> {
                boolean bl = addHere.add((IN4JSProject)rl);
            });
            Optional ep = project.getExtendedRuntimeEnvironmentId();
            Optional<IN4JSProject> extendedRE = Optional.absent();
            if (ep.isPresent()) {
                extendedRE = this.findRuntimeEnvironemtnWithName((String)ep.get(), projects);
            }
            if (extendedRE.isPresent()) {
                IN4JSProject e = (IN4JSProject)extendedRE.get();
                this.recursiveExtendedREsCollector(e, addHere, projects);
            }
        }
    }

    public Collection<IN4JSProject> recursiveDependencyCollector(IN4JSProject sourceContainerAware) {
        if (sourceContainerAware == null) {
            return Collections.emptyList();
        }
        ArrayList dependencies = Lists.newArrayList();
        RecursionGuard guard = new RecursionGuard();
        this.recursiveDependencyCollector(sourceContainerAware, dependencies, (RecursionGuard<URI>)guard);
        return dependencies;
    }

    private List<URI> getInitModulesAsURIs(IN4JSProject project) {
        return project.getInitModules().stream().map(bm -> this.artifactHelper.findArtifact(project, bm.getModuleSpecifier(), Optional.of((Object)".js"))).filter(module -> module != null).collect(Collectors.toList());
    }

    private void recursiveDependencyCollector(IN4JSProject project, Collection<IN4JSProject> addHere, RecursionGuard<URI> guard) {
        if (project.exists()) {
            addHere.add(project);
        }
        for (IN4JSProject dep : project.getAllDirectDependencies()) {
            if (!guard.tryNext((Object)dep.getLocation())) continue;
            this.recursiveDependencyCollector(dep, addHere, guard);
        }
    }

    private Optional<IN4JSProject> getCustomRuntimeEnvironmentProject(RuntimeEnvironment runEnv) {
        if (runEnv != null) {
            String projectName = runEnv.getProjectName();
            return this.findRuntimeEnvironemtnWithName(projectName);
        }
        return Optional.absent();
    }

    public Optional<IN4JSProject> findRuntimeEnvironemtnWithName(String projectName, Iterable<IN4JSProject> projects) {
        for (IN4JSProject project : projects) {
            if (project.getProjectType() != ProjectType.RUNTIME_ENVIRONMENT || !project.getProjectName().equals(projectName)) continue;
            return Optional.of((Object)project);
        }
        return Optional.absent();
    }

    private Optional<IN4JSProject> findRuntimeEnvironemtnWithName(String projectName) {
        return this.findRuntimeEnvironemtnWithName(projectName, this.n4jsCore.findAllProjects());
    }

    public String computeConfigurationName(String runnerId, URI moduleToRun) {
        String modulePath = moduleToRun.path();
        if ((modulePath = RunnerHelper.stripStart(modulePath, "/", "resource/", "plugin/")).startsWith("@")) {
            modulePath = modulePath.substring(1);
        }
        String moduleName = modulePath.replace('/', '-').replace(':', '-');
        String runnerName = this.runnerRegistry.getDescriptor(runnerId).getName();
        return String.valueOf(moduleName) + " (" + runnerName + ")";
    }

    private static final String stripStart(String str, String ... prefixesToStrip) {
        String[] stringArray = prefixesToStrip;
        int n = prefixesToStrip.length;
        int n2 = 0;
        while (n2 < n) {
            String currPrefix = stringArray[n2];
            if (str.startsWith(currPrefix)) {
                str = str.substring(currPrefix.length());
            }
            ++n2;
        }
        return str;
    }

    public ApiUsage getProjectExtendedDepsAndApiImplMapping(RuntimeEnvironment runtimeEnvironment, URI moduleToRun, String implementationId, boolean throwOnError) {
        ApiImplMapping apiImplMapping;
        LinkedHashSet<IN4JSProject> deps = new LinkedHashSet<IN4JSProject>();
        Optional project = this.n4jsCore.findProject(moduleToRun);
        if (!project.isPresent()) {
            throw new RuntimeException("can't obtain containing project for moduleToRun: " + moduleToRun);
        }
        this.recursiveDependencyCollector((IN4JSProject)project.get(), deps, (RecursionGuard<URI>)new RecursionGuard());
        Optional<IN4JSProject> reProject = this.getCustomRuntimeEnvironmentProject(runtimeEnvironment);
        if (reProject.isPresent()) {
            IN4JSProject re = (IN4JSProject)reProject.get();
            this.recursiveExtendedREsCollector(re, deps);
            this.recursiveDependencyCollector(re, deps, (RecursionGuard<URI>)new RecursionGuard());
        }
        if ((apiImplMapping = ApiImplMapping.of(deps, (Iterable)this.n4jsCore.findAllProjects())).hasErrors() && throwOnError) {
            throw new IllegalStateException("the workspace setup contains errors related to API / implementation projects (check manifests of related projects):\n    " + Joiner.on((String)"\n    ").join((Iterable)apiImplMapping.getErrorMessages()));
        }
        if (apiImplMapping.isEmpty()) {
            return ApiUsage.of(new ArrayList<IN4JSProject>(deps), Collections.emptyMap(), apiImplMapping);
        }
        if (implementationId == null) {
            List allImplIds = apiImplMapping.getAllImplIds();
            if (allImplIds.size() != 1) {
                if (throwOnError) {
                    throw new IllegalStateException("no implementationId specified while several are available in the workspace: " + allImplIds);
                }
                return ApiUsage.of(new ArrayList<IN4JSProject>(deps), Collections.emptyMap(), apiImplMapping, true);
            }
            implementationId = (String)allImplIds.get(0);
        }
        LinkedHashMap<IN4JSProject, IN4JSProject> apiImplProjectMapping = new LinkedHashMap<IN4JSProject, IN4JSProject>();
        ArrayList<String> missing = new ArrayList<String>();
        for (IN4JSProject dep : deps) {
            String depId;
            if (dep == null || (depId = dep.getProjectName()) == null || !apiImplMapping.isApi(depId)) continue;
            IN4JSProject impl = apiImplMapping.getImpl(depId, implementationId);
            if (impl != null) {
                apiImplProjectMapping.put(dep, impl);
                continue;
            }
            missing.add(depId);
        }
        if (!missing.isEmpty() && throwOnError) {
            throw new IllegalStateException("no implementation for implementation ID \"" + implementationId + "\" found for the following projects: " + Joiner.on((String)", ").join(missing));
        }
        LinkedHashSet<IN4JSProject> processedDepProjects = deps;
        LinkedHashSet<IN4JSProject> tobeInspectedApiImplProjects = new LinkedHashSet<IN4JSProject>();
        apiImplProjectMapping.entrySet().forEach(p -> {
            IN4JSProject v = (IN4JSProject)p.getValue();
            if (!processedDepProjects.contains(v)) {
                tobeInspectedApiImplProjects.add(v);
            }
        });
        LinkedHashMap<IN4JSProject, IN4JSProject> joinedApiImplProjectMapping = new LinkedHashMap<IN4JSProject, IN4JSProject>(apiImplProjectMapping);
        while (!tobeInspectedApiImplProjects.isEmpty()) {
            LinkedHashSet<IN4JSProject> batchedPivotDependencies = new LinkedHashSet<IN4JSProject>();
            RecursionGuard guard = new RecursionGuard();
            for (IN4JSProject pivotProject : tobeInspectedApiImplProjects) {
                this.recursiveDependencyCollector(pivotProject, batchedPivotDependencies, (RecursionGuard<URI>)guard);
            }
            tobeInspectedApiImplProjects.clear();
            List batchedPivotNewDepList = batchedPivotDependencies.stream().filter(p -> p != null && !processedDepProjects.contains(p)).collect(Collectors.toList());
            apiImplMapping.enhance(batchedPivotNewDepList, this.n4jsCore.findAllProjects());
            for (IN4JSProject pivNewDep : batchedPivotNewDepList) {
                String depId = pivNewDep.getProjectName();
                if (apiImplMapping.isApi(depId)) {
                    if (joinedApiImplProjectMapping.containsKey(pivNewDep)) continue;
                    IN4JSProject pivImpl = apiImplMapping.getImpl(depId, implementationId);
                    if (pivImpl != null) {
                        joinedApiImplProjectMapping.put(pivNewDep, pivImpl);
                        tobeInspectedApiImplProjects.add(pivImpl);
                        continue;
                    }
                    missing.add(depId);
                    continue;
                }
                if (processedDepProjects.contains(pivNewDep)) continue;
                processedDepProjects.add(pivNewDep);
            }
        }
        if (!missing.isEmpty() && throwOnError) {
            throw new IllegalStateException("no implementation for implementation ID \"" + implementationId + "\" found for the following projects: " + Joiner.on((String)", ").join(missing));
        }
        return ApiUsage.of(implementationId, new ArrayList<IN4JSProject>(deps), apiImplProjectMapping, apiImplMapping, missing);
    }

    public static class ApiUsage {
        public final String implementationId;
        public final List<IN4JSProject> projects;
        public final Map<IN4JSProject, IN4JSProject> concreteApiImplProjectMapping;
        public final ApiImplMapping apiImplMapping;
        public final List<String> missingImplementationIds;
        public final boolean implementationIdRequired;

        private ApiUsage(String implementationatId, List<IN4JSProject> projects, Map<IN4JSProject, IN4JSProject> concreteApiImplProjectMapping, ApiImplMapping apiImplMapping, List<String> missingImplementationIds, boolean implementationIdRequired) {
            this.implementationId = implementationatId;
            this.apiImplMapping = apiImplMapping;
            this.concreteApiImplProjectMapping = concreteApiImplProjectMapping;
            this.projects = projects;
            this.missingImplementationIds = missingImplementationIds;
            this.implementationIdRequired = implementationIdRequired;
        }

        public boolean isInErrorState() {
            return !this.missingImplementationIds.isEmpty() || this.apiImplMapping.hasErrors() || this.implementationIdRequired && this.implementationId == null;
        }

        private static ApiUsage of(String implementationId, List<IN4JSProject> projects, Map<IN4JSProject, IN4JSProject> concreteApiImplProjectMapping, ApiImplMapping apiImplMapping, List<String> missingImplementationIds) {
            return new ApiUsage(implementationId, projects, concreteApiImplProjectMapping, apiImplMapping, missingImplementationIds, true);
        }

        private static ApiUsage of(List<IN4JSProject> projects, Map<IN4JSProject, IN4JSProject> concreteApiImplProjectMapping, ApiImplMapping apiImplMapping) {
            return new ApiUsage(null, projects, concreteApiImplProjectMapping, apiImplMapping, Collections.emptyList(), false);
        }

        private static ApiUsage of(List<IN4JSProject> projects, Map<IN4JSProject, IN4JSProject> concreteApiImplProjectMapping, ApiImplMapping apiImplMapping, boolean implementationIdRequired) {
            return new ApiUsage(null, projects, concreteApiImplProjectMapping, apiImplMapping, Collections.emptyList(), implementationIdRequired);
        }
    }
}

