/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.expectation.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.xpect.XpectArgument;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.expectation.ILinesExpectation;
import org.eclipse.xpect.expectation.LinesExpectation;
import org.eclipse.xpect.expectation.impl.AbstractExpectation;
import org.eclipse.xpect.expectation.impl.ActualCollection;
import org.eclipse.xpect.expectation.impl.ExpectationCollection;
import org.eclipse.xpect.expectation.impl.ExpectationRegionProvider;
import org.eclipse.xpect.expectation.impl.TargetSyntaxSupport;
import org.eclipse.xpect.setup.XpectSetupFactory;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.text.Text;
import org.eclipse.xpect.util.ReflectionUtil;
import org.eclipse.xtext.util.Pair;
import org.junit.Assert;
import org.junit.ComparisonFailure;

@XpectSetupFactory
@XpectImport(value={ExpectationRegionProvider.class})
public class LinesExpectationImpl
extends AbstractExpectation
implements ILinesExpectation {
    private final LinesExpectation annotation;

    public LinesExpectationImpl(XpectArgument argument, TargetSyntaxSupport targetSyntax) {
        super(argument, targetSyntax);
        this.annotation = argument.getAnnotationOrDefault(LinesExpectation.class);
    }

    @Override
    public void assertEquals(Iterable<?> actual) {
        this.assertEquals("", actual);
    }

    @Override
    public void assertEquals(String message, Iterable<?> actual) {
        Assert.assertNotNull(actual);
        ExpectationCollection exp = new ExpectationCollection();
        exp.setCaseSensitive(this.annotation.caseSensitive());
        exp.setOrdered(this.annotation.ordered());
        exp.setQuoted(this.annotation.quoted());
        exp.setSeparator('\n');
        exp.setWhitespaceSensitive(this.annotation.whitespaceSensitive());
        exp.setExpectationFormatter(ReflectionUtil.newInstanceUnchecked(this.annotation.expectationFormatter()));
        exp.init(this.getExpectation());
        ActualCollection act = new ActualCollection();
        act.setTargetLiteralSupport(this.getTargetSyntaxLiteral());
        act.setCaseSensitive(this.annotation.caseSensitive());
        act.setOrdered(this.annotation.ordered());
        act.setQuoted(this.annotation.quoted());
        act.setSeparator('\n');
        act.setWhitespaceSensitive(this.annotation.whitespaceSensitive());
        act.setItemFormatter(ReflectionUtil.newInstanceUnchecked(this.annotation.itemFormatter()));
        act.init(actual);
        if (!exp.matches(act)) {
            ArrayList expString = Lists.newArrayList();
            ArrayList actString = Lists.newArrayList();
            for (Pair<Collection<ExpectationCollection.ExpectationItem>, ActualCollection.ActualItem> pair : exp.map(act)) {
                if (pair.getFirst() != null && !((Collection)pair.getFirst()).isEmpty()) {
                    if (pair.getSecond() != null) {
                        expString.add(((ActualCollection.ActualItem)pair.getSecond()).getEscaped());
                    } else {
                        expString.add(((ExpectationCollection.ExpectationItem)((Collection)pair.getFirst()).iterator().next()).getEscaped());
                    }
                }
                if (pair.getSecond() == null) continue;
                actString.add(((ActualCollection.ActualItem)pair.getSecond()).getEscaped());
            }
            String nl = new Text(this.getRegion().getDocument()).getNL();
            String expDoc = this.replaceInDocument(Joiner.on((String)nl).join((Iterable)expString));
            String actDoc = this.replaceInDocument(Joiner.on((String)nl).join((Iterable)actString));
            throw new ComparisonFailure(message, expDoc, actDoc);
        }
    }

    @Creates
    public ILinesExpectation create() {
        return this;
    }

    public LinesExpectation getAnnotation() {
        return this.annotation;
    }
}

