/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.util;

import com.google.common.base.Joiner;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.xpect.Environment;
import org.eclipse.xpect.runner.XpectRunner;

public class EnvironmentUtil {
    public static final Environment ENVIRONMENT = EnvironmentUtil.detectEnvironement();

    private static Environment detectEnvironement() {
        if (XpectRunner.testClassloader != null) {
            if (EcorePlugin.IS_ECLIPSE_RUNNING) {
                return Environment.PLUGIN_TEST;
            }
            return Environment.STANDALONE_TEST;
        }
        if (EcorePlugin.IS_ECLIPSE_RUNNING) {
            return Environment.WORKBENCH;
        }
        throw new IllegalStateException("not (yet) supported environment: standalone, but without JUnit.");
    }

    public static void requireEnvironment(Environment ... environments) {
        Environment[] environmentArray = environments;
        int n = environments.length;
        int n2 = 0;
        while (n2 < n) {
            Environment env = environmentArray[n2];
            if (ENVIRONMENT == env) {
                return;
            }
            ++n2;
        }
        StringBuilder msg = new StringBuilder();
        msg.append("This class in only applicable in environment(s) ");
        Joiner.on((String)" or ").appendTo(msg, (Object[])environments);
        msg.append(", but environment ");
        msg.append((Object)ENVIRONMENT);
        msg.append(" has been found.");
        throw new RuntimeException(msg.toString());
    }
}

