/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs;

import java.util.LinkedList;
import java.util.List;

public enum ControlFlowType {
    Successor,
    IfTrue,
    IfFalse,
    Return,
    Throw,
    Break,
    Continue,
    LoopEnter,
    LoopExit,
    LoopRepeat,
    LoopReenter,
    LoopInfinite,
    DeadCode,
    CatchesErrors,
    CatchesAll;

    public static final ControlFlowType[] NonRepeatTypes;
    public static final ControlFlowType[] NonDeadTypes;

    static {
        NonRepeatTypes = new ControlFlowType[]{Successor, Break, Continue, Throw, Return, LoopEnter, LoopExit};
        NonDeadTypes = new ControlFlowType[]{Successor, IfTrue, IfFalse, Break, Continue, Throw, Return, LoopEnter, LoopExit, LoopRepeat, LoopReenter, LoopInfinite};
    }

    public static List<ControlFlowType> filter(Iterable<ControlFlowType> list, ControlFlowType ... onlyThese) {
        LinkedList<ControlFlowType> result = new LinkedList<ControlFlowType>();
        for (ControlFlowType cft : list) {
            ControlFlowType[] controlFlowTypeArray = onlyThese;
            int n = onlyThese.length;
            int n2 = 0;
            while (n2 < n) {
                ControlFlowType onlyThis = controlFlowTypeArray[n2];
                if (onlyThis == cft) {
                    result.add(cft);
                }
                ++n2;
            }
        }
        return result;
    }

    public boolean isInOrEmpty(ControlFlowType[] flowTypes) {
        if (flowTypes == null || flowTypes.length == 0) {
            return true;
        }
        ControlFlowType[] controlFlowTypeArray = flowTypes;
        int n = flowTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ControlFlowType cft = controlFlowTypeArray[n2];
            if (this == cft) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isBackwards() {
        switch (this) {
            case LoopRepeat: 
            case LoopReenter: 
            case LoopInfinite: {
                return true;
            }
        }
        return false;
    }
}

