/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.results;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.n4js.xpect.ui.results.ExecutionResults;
import org.eclipse.n4js.xpect.ui.results.ExecutionStatus;
import org.eclipse.n4js.xpect.ui.results.TraceConsole;
import org.eclipse.n4js.xpect.ui.results.XpectContentProvider;
import org.eclipse.n4js.xpect.ui.results.XpectLabelProvider;
import org.eclipse.n4js.xpect.ui.runner.N4IDEXpectFileNameUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

public class N4IDEXpectView
extends ViewPart {
    private static final String NO_TRACE_MSG = "No trace";
    Composite container;
    TreeViewer testTreeViewer;
    TraceConsole stacktraceConsole;
    TextConsoleViewer stacktraceConsoleViewer;
    Label stacktraceLabel;
    Description dataRoot;
    ExecutionResults testsExecutionStatus = new ExecutionResults();
    public static final String ID = "org.eclipse.n4js.xpect.ui.runner.N4IDEXpectView";
    private static final String VIEW_CONTEXT_ID = "org.eclipse.n4js.xpect.ui.runner.N4IDEXpectView.context";

    public void createPartControl(Composite parent) {
        FillLayout fillLayout = new FillLayout(512);
        fillLayout.marginHeight = 5;
        fillLayout.marginWidth = 5;
        parent.setLayout((Layout)fillLayout);
        this.container = new Composite(parent, 2048);
        this.container.setLayout((Layout)new FillLayout());
        Composite stacktraceDataContainer = new Composite(parent, 2048);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 5;
        formLayout.marginWidth = 5;
        formLayout.spacing = 5;
        stacktraceDataContainer.setLayout((Layout)formLayout);
        Composite stackLabelContainer = new Composite(stacktraceDataContainer, 48);
        stackLabelContainer.setLayout((Layout)new GridLayout());
        FormData stackLabelFormData = new FormData();
        stackLabelFormData.top = new FormAttachment(0);
        stackLabelFormData.left = new FormAttachment(0);
        stackLabelFormData.right = new FormAttachment(100);
        stackLabelFormData.bottom = new FormAttachment(20);
        stackLabelContainer.setLayoutData((Object)stackLabelFormData);
        Composite stackTraceContainer = new Composite(stacktraceDataContainer, 48);
        stackTraceContainer.setLayout((Layout)new FillLayout());
        FormData stackTraceFormData = new FormData();
        stackTraceFormData.top = new FormAttachment((Control)stackLabelContainer);
        stackTraceFormData.left = new FormAttachment(0);
        stackTraceFormData.right = new FormAttachment(100);
        stackTraceFormData.bottom = new FormAttachment(100);
        stackTraceContainer.setLayoutData((Object)stackTraceFormData);
        this.testTreeViewer = new TreeViewer(this.container);
        this.testTreeViewer.setContentProvider((IContentProvider)new XpectContentProvider());
        this.testTreeViewer.setLabelProvider((IBaseLabelProvider)new XpectLabelProvider(this.testsExecutionStatus));
        this.testTreeViewer.setInput(null);
        this.stacktraceLabel = new Label(stackLabelContainer, 8);
        FontData fontData = this.stacktraceLabel.getFont().getFontData()[0];
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        Font font = new Font((Device)display, new FontData(fontData.getName(), fontData.getHeight(), 1));
        this.stacktraceLabel.setFont(font);
        this.stacktraceLabel.setText(NO_TRACE_MSG);
        MessageConsole messageConsole = new MessageConsole("trace", null);
        this.stacktraceConsole = new TraceConsole(messageConsole);
        this.stacktraceConsoleViewer = new TextConsoleViewer(stackTraceContainer, (TextConsole)messageConsole);
        this.getSite().setSelectionProvider((ISelectionProvider)this.testTreeViewer);
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)this.testTreeViewer);
        Control control = this.testTreeViewer.getControl();
        Menu menu = contextMenu.createContextMenu(control);
        control.setMenu(menu);
        this.activateContext();
        this.createSelectionActions();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext(VIEW_CONTEXT_ID);
    }

    private void createSelectionActions() {
        this.testTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection;
                Description desc;
                if (event.getSelection().isEmpty()) {
                    N4IDEXpectView.this.stacktraceConsole.clear();
                    N4IDEXpectView.this.stacktraceLabel.setText(N4IDEXpectView.NO_TRACE_MSG);
                    N4IDEXpectView.this.stacktraceLabel.getParent().layout(true);
                    return;
                }
                N4IDEXpectView.this.stacktraceConsole.clear();
                N4IDEXpectView.this.stacktraceLabel.setText(N4IDEXpectView.NO_TRACE_MSG);
                N4IDEXpectView.this.stacktraceLabel.getParent().layout(true);
                if (event.getSelection() instanceof IStructuredSelection && (desc = (Description)(selection = (IStructuredSelection)event.getSelection()).getFirstElement()).isTest() && N4IDEXpectView.this.testsExecutionStatus.hasFailed(desc)) {
                    Throwable failureException = N4IDEXpectView.this.testsExecutionStatus.getFailure(desc).getException();
                    StringWriter stackTraceWriter = new StringWriter();
                    failureException.printStackTrace(new PrintWriter(stackTraceWriter));
                    String testName = N4IDEXpectFileNameUtil.getTestName(desc);
                    if (testName.startsWith("initializationError")) {
                        N4IDEXpectView.this.stacktraceLabel.setText("test initializaiton stack trace error");
                        N4IDEXpectView.this.stacktraceLabel.getParent().layout(true);
                        N4IDEXpectView.this.stacktraceConsole.write(stackTraceWriter.toString());
                        return;
                    }
                    N4IDEXpectView.this.stacktraceLabel.setText("Stack trace of exception for " + testName);
                    N4IDEXpectView.this.stacktraceLabel.getParent().layout(true);
                    N4IDEXpectView.this.stacktraceConsole.write(stackTraceWriter.toString());
                }
            }
        });
    }

    public void setFocus() {
        this.testTreeViewer.getControl().setFocus();
    }

    public void notifySessionStarted(Description description) {
        this.dataRoot = description;
        this.testsExecutionStatus.initResults(description);
        this.stacktraceLabel.setText(NO_TRACE_MSG);
        this.stacktraceLabel.getParent().layout(true);
        this.stacktraceConsole.clear();
        this.testTreeViewer.setInput((Object)this.dataRoot);
    }

    public void notifySessionFinished() {
        this.testTreeViewer.setInput((Object)this.dataRoot);
        this.testTreeViewer.setSelection(this.testTreeViewer.getSelection());
    }

    public void notifyFailedExecutionOf(Failure failure) {
        this.testsExecutionStatus.executionFailed(failure);
        this.testTreeViewer.setInput((Object)this.dataRoot);
    }

    public void notifyStartedExecutionOf(Description description) {
        this.testsExecutionStatus.executionStarted(description);
        this.testTreeViewer.setInput((Object)this.dataRoot);
    }

    public void notifyIgnoredExecutionOf(Description description) {
        this.testsExecutionStatus.executionIgnored(description);
        this.testTreeViewer.setInput((Object)this.dataRoot);
    }

    public void notifyFinishedExecutionOf(Description description) {
        if (this.testsExecutionStatus.getStatus(description) == ExecutionStatus.STARTED) {
            this.testsExecutionStatus.testPassed(description);
        }
        this.testTreeViewer.setInput((Object)this.dataRoot);
    }
}

