/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.projectModel.dependencies;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.NpmLogger;
import org.eclipse.n4js.internal.N4JSModel;
import org.eclipse.n4js.internal.N4JSProject;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectDescription.ProjectReference;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.dependencies.DependencyInfo;
import org.eclipse.n4js.semver.Semver.NPMVersionRequirement;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.semver.SemverMatcher;
import org.eclipse.n4js.semver.SemverUtils;
import org.eclipse.n4js.semver.model.SemverSerializer;

public class ProjectDependenciesHelper {
    private static final Logger LOGGER = Logger.getLogger(ProjectDependenciesHelper.class);
    @Inject
    private IN4JSCore core;
    @Inject
    private N4JSModel model;
    @Inject
    private ExternalLibraryWorkspace externalWS;
    @Inject
    private NpmLogger logger;

    public Map<String, NPMVersionRequirement> computeDependenciesOfWorkspace() {
        LinkedList<N4JSProject> wsProjects = new LinkedList<N4JSProject>();
        for (IN4JSProject prj : this.core.findAllProjects()) {
            if (prj.isExternal()) continue;
            wsProjects.add((N4JSProject)prj);
        }
        return this.calculateDependenciesOfProjects(wsProjects);
    }

    public Map<String, NPMVersionRequirement> calculateDependenciesOfProjects(Collection<N4JSProject> projects) {
        List<ProjectDescription> projectsDescriptions = this.getProjectsDescriptions(projects);
        Map<String, NPMVersionRequirement> versionedPackages = ProjectDependenciesHelper.updateMissingDependenciesMap(projectsDescriptions);
        this.logResult(versionedPackages);
        return versionedPackages;
    }

    private List<ProjectDescription> getProjectsDescriptions(Collection<N4JSProject> projects) {
        LinkedList<ProjectDescription> pds = new LinkedList<ProjectDescription>();
        for (IN4JSProject iN4JSProject : projects) {
            ProjectDescription projectDescription;
            URI prjLocation = iN4JSProject.getLocation();
            if (prjLocation == null || (projectDescription = this.model.getProjectDescription(prjLocation)) == null) continue;
            pds.add(projectDescription);
        }
        return pds;
    }

    private void logResult(Map<String, NPMVersionRequirement> versionedPackages) {
        if (LOGGER.isDebugEnabled()) {
            StringJoiner messages = new StringJoiner(System.lineSeparator());
            messages.add("dependencies to install: ");
            versionedPackages.forEach((id, v) -> {
                StringJoiner stringJoiner2 = messages.add(" - " + id + v);
            });
            LOGGER.debug((Object)messages);
        }
    }

    public void fixDependenciesToInstall(Map<String, NPMVersionRequirement> dependenciesToInstall) {
        Map<String, VersionNumber> projectNamesOfShippedCode = this.externalWS.getProjectNameVersionMap();
        this.removeDependenciesToShippedCodeIfVersionMatches(dependenciesToInstall, projectNamesOfShippedCode);
        this.addDependenciesForRemainingShippedCode(dependenciesToInstall, projectNamesOfShippedCode.keySet());
        this.logShippedCodeInstallationStatus(dependenciesToInstall, projectNamesOfShippedCode.keySet());
    }

    private void removeDependenciesToShippedCodeIfVersionMatches(Map<String, NPMVersionRequirement> dependenciesToInstall, Map<String, VersionNumber> projectNamesOfShippedCode) {
        HashSet<String> prjNames = new HashSet<String>(dependenciesToInstall.keySet());
        for (String projectName : prjNames) {
            NPMVersionRequirement versionRequirement;
            VersionNumber availableVersionInShippedCode = projectNamesOfShippedCode.get(projectName);
            if (availableVersionInShippedCode == null || (versionRequirement = dependenciesToInstall.get(projectName)) == null || !SemverMatcher.matchesStrict((VersionNumber)availableVersionInShippedCode, (NPMVersionRequirement)versionRequirement)) continue;
            dependenciesToInstall.remove(projectName);
        }
    }

    private void addDependenciesForRemainingShippedCode(Map<String, NPMVersionRequirement> dependenciesToInstall, Set<String> projectNamesOfShippedCode) {
        Map versionRequirementsOfShippedCodeToInstall;
        NPMVersionRequirement versionConstraint;
        HashSet<String> projectNamesOfShippedCodeToInstall = new HashSet<String>(dependenciesToInstall.keySet());
        projectNamesOfShippedCodeToInstall.retainAll(projectNamesOfShippedCode);
        if (!projectNamesOfShippedCodeToInstall.isEmpty() && projectNamesOfShippedCodeToInstall.size() < projectNamesOfShippedCode.size() && (versionConstraint = (NPMVersionRequirement)(versionRequirementsOfShippedCodeToInstall = projectNamesOfShippedCodeToInstall.stream().map(id -> (NPMVersionRequirement)dependenciesToInstall.get(id)).collect(Collectors.toMap(SemverSerializer::serialize, Function.identity(), (vr1, vr2) -> vr1))).values().stream().findFirst().orElse(null)) != null) {
            if (versionRequirementsOfShippedCodeToInstall.size() > 1) {
                this.logger.logInfo("WARNING: differing version requirements for shipped code: " + Joiner.on((String)", ").join(versionRequirementsOfShippedCodeToInstall.values()) + "; using: " + versionConstraint);
            }
            for (String id2 : projectNamesOfShippedCode) {
                if (projectNamesOfShippedCodeToInstall.contains(id2)) continue;
                dependenciesToInstall.put(id2, versionConstraint);
            }
        }
    }

    private void logShippedCodeInstallationStatus(Map<String, NPMVersionRequirement> dependenciesToInstall, Set<String> projectNamesOfShippedCode) {
        HashMap<String, NPMVersionRequirement> shippedCodeToInstall = new HashMap<String, NPMVersionRequirement>(dependenciesToInstall);
        HashSet<String> nonShadowedShippedCode = new HashSet<String>(projectNamesOfShippedCode);
        shippedCodeToInstall.keySet().retainAll(projectNamesOfShippedCode);
        nonShadowedShippedCode.removeAll(shippedCodeToInstall.keySet());
        if (shippedCodeToInstall.isEmpty()) {
            this.logger.logInfo("Not going to shadow any shipped code with installed packages.");
        } else {
            String separator = "\n\t";
            this.logger.logInfo("The following installed packages will shadow shipped code:" + separator + shippedCodeToInstall.entrySet().stream().map(e -> String.valueOf((String)e.getKey()) + "@" + e.getValue()).collect(Collectors.joining(separator)));
            if (nonShadowedShippedCode.isEmpty()) {
                this.logger.logInfo("The entire shipped code will be shadowed.");
            } else {
                this.logger.logInfo("WARNING: shipped code will be shadowed only partially; non-shadowed shipped projects:" + separator + Joiner.on((String)separator).join(nonShadowedShippedCode));
            }
        }
    }

    private static Map<String, NPMVersionRequirement> updateMissingDependenciesMap(List<ProjectDescription> projectDescriptions) {
        HashMap<String, NPMVersionRequirement> versionedPackages = new HashMap<String, NPMVersionRequirement>();
        projectDescriptions.forEach(pd -> {
            if (pd != null) {
                ProjectDependenciesHelper.updateFromProjectDescription(versionedPackages, pd);
            }
        });
        for (ProjectDescription pd2 : projectDescriptions) {
            versionedPackages.remove(pd2.getProjectName());
        }
        return versionedPackages;
    }

    private static void updateFromProjectDescription(Map<String, NPMVersionRequirement> dependencies, ProjectDescription pd) {
        if (pd == null) {
            return;
        }
        Stream.of(pd.getProjectDependencies().stream().map(DependencyInfo::create), pd.getProvidedRuntimeLibraries().stream().map(DependencyInfo::create), ProjectDependenciesHelper.getVersionedExtendedRuntimeEnvironment(pd), pd.getImplementedProjects().stream().map(DependencyInfo::create)).reduce(Stream::concat).orElseGet(Stream::empty).forEach(info -> {
            NPMVersionRequirement nPMVersionRequirement = dependencies.merge(info.name, info.version, ProjectDependenciesHelper::resolve);
        });
    }

    private static NPMVersionRequirement resolve(NPMVersionRequirement vr1, NPMVersionRequirement vr2) {
        if (vr1 == null || SemverUtils.isEmptyVersionRequirement((NPMVersionRequirement)vr1) || SemverUtils.isWildcardVersionRequirement((NPMVersionRequirement)vr1)) {
            return vr2;
        }
        return vr1;
    }

    private static Stream<DependencyInfo> getVersionedExtendedRuntimeEnvironment(ProjectDescription description) {
        ProjectReference re = description.getExtendedRuntimeEnvironment();
        return re != null ? Stream.of(re).map(DependencyInfo::create) : Stream.empty();
    }
}

