/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.internal;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.Collections;
import org.eclipse.n4js.tester.TesterFacade;
import org.eclipse.n4js.tester.domain.TestTree;
import org.eclipse.n4js.tester.fsm.TestFsmRegistry;
import org.eclipse.n4js.tester.internal.InternalTestTreeRegistry;
import org.eclipse.n4js.tester.server.HttpServerManager;
import org.eclipse.n4js.tester.server.JettyManager;

@Singleton
public class TesterFacadeImpl
implements TesterFacade {
    private final TestFsmRegistry fsmRegistry;
    private final HttpServerManager serverManager;
    private final InternalTestTreeRegistry treeRegistry;
    private final int port;
    private int actualPort = -1;

    @Inject
    TesterFacadeImpl(TestFsmRegistry fsmRegistry, HttpServerManager serverManager, InternalTestTreeRegistry treeRegistry, @Named(value="httpServerPortKey") int port) {
        this.fsmRegistry = fsmRegistry;
        this.serverManager = serverManager;
        this.treeRegistry = treeRegistry;
        this.port = port;
        this.actualPort = port;
    }

    @Override
    public int prepareTestSession(TestTree tree) {
        if (!this.serverManager.isRunning(this.actualPort)) {
            this.actualPort = ((JettyManager)this.serverManager).ensurePortIsAvailable(this.port);
            this.serverManager.startServer(Collections.singletonMap("http.port", this.actualPort));
        }
        String sessionId = tree.getSessionId().getValue();
        this.fsmRegistry.getTestFsm(sessionId);
        this.treeRegistry.registerTestTree(tree);
        return this.actualPort;
    }

    @Override
    public void shutdownFramework() {
        this.serverManager.stopServer(this.actualPort);
    }
}

