/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.ui.shared.target.IUContentProvider;

public class TargetLocationContentProvider
implements ITreeContentProvider {
    private boolean showContent = false;

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ITargetDefinition) {
            ITargetLocation[] containers = ((ITargetDefinition)parentElement).getTargetLocations();
            return containers != null ? containers : new Object[]{};
        }
        if (parentElement instanceof ITargetLocation) {
            ITargetLocation location = (ITargetLocation)parentElement;
            if (location.isResolved()) {
                IStatus status = location.getStatus();
                if (!status.isOK() && !status.isMultiStatus()) {
                    return new Object[]{status};
                }
                if (this.isShowLocationContent()) {
                    TargetBundle[] bundles = location.getBundles();
                    return bundles != null ? bundles : new Object[]{};
                }
                if (!status.isOK()) {
                    if (status.isMultiStatus()) {
                        return status.getChildren();
                    }
                } else {
                    ITreeContentProvider provider = (ITreeContentProvider)Platform.getAdapterManager().getAdapter(parentElement, ITreeContentProvider.class);
                    if (provider != null) {
                        Object[] provided = provider.getChildren(parentElement);
                        return provided != null ? provided : new Object[]{};
                    }
                }
            } else {
                HashMap targetFlagMap = TargetPlatformHelper.getTargetDefinitionMap();
                for (List targetDefinitionValues : targetFlagMap.values()) {
                    ITargetLocation[] locs;
                    if (targetDefinitionValues.size() <= 0 || (locs = ((TargetDefinition)targetDefinitionValues.get(0)).getTargetLocations()) == null) continue;
                    ITargetLocation[] iTargetLocationArray = locs;
                    int n = locs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStatus status;
                        ITargetLocation loc = iTargetLocationArray[n2];
                        if (location.equals(loc) && (status = loc.getStatus()) != null && !status.isOK() && !status.isMultiStatus()) {
                            return new Object[]{status};
                        }
                        ++n2;
                    }
                }
            }
        } else {
            if (parentElement instanceof IStatus) {
                return ((IStatus)parentElement).getChildren();
            }
            ITreeContentProvider provider = (ITreeContentProvider)Platform.getAdapterManager().getAdapter(parentElement, ITreeContentProvider.class);
            if (provider != null) {
                Object[] provided = provider.getChildren(parentElement);
                return provided != null ? provided : new Object[]{};
            }
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IUContentProvider.IUWrapper) {
            return ((IUContentProvider.IUWrapper)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof ITargetDefinition) {
            IStatus status;
            boolean hasContainerStatus = false;
            ArrayList<Object> result = new ArrayList<Object>();
            ITargetLocation[] containers = ((ITargetDefinition)inputElement).getTargetLocations();
            if (containers != null) {
                int i = 0;
                while (i < containers.length) {
                    result.add(containers[i]);
                    if (containers[i].getStatus() != null && !containers[i].getStatus().isOK()) {
                        hasContainerStatus = true;
                    }
                    ++i;
                }
            }
            if (!hasContainerStatus && (status = ((ITargetDefinition)inputElement).getStatus()) != null && !status.isOK()) {
                result.add(status);
            }
            return result.toArray();
        }
        if (inputElement instanceof String) {
            return new Object[]{inputElement};
        }
        return new Object[0];
    }

    public boolean isShowLocationContent() {
        return this.showContent;
    }

    public void setShowLocationContent(boolean showContent) {
        this.showContent = showContent;
    }
}

