/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.imports;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4idl.versioning.VersionHelper;
import org.eclipse.n4js.resource.N4JSEObjectDescription;
import org.eclipse.n4js.scoping.accessModifiers.AbstractTypeVisibilityChecker;
import org.eclipse.n4js.scoping.accessModifiers.InvisibleTypeOrVariableDescription;
import org.eclipse.n4js.scoping.accessModifiers.TypeVisibilityChecker;
import org.eclipse.n4js.scoping.accessModifiers.VariableVisibilityChecker;
import org.eclipse.n4js.scoping.builtin.GlobalObjectScope;
import org.eclipse.n4js.scoping.builtin.NoPrimitiveTypesScope;
import org.eclipse.n4js.scoping.imports.AmbiguousImportDescription;
import org.eclipse.n4js.scoping.imports.IEODesc2ISpec;
import org.eclipse.n4js.scoping.imports.ImportedElementsMap;
import org.eclipse.n4js.scoping.imports.OriginAwareScope;
import org.eclipse.n4js.scoping.imports.PlainAccessOfAliasedImportDescription;
import org.eclipse.n4js.scoping.imports.PlainAccessOfNamespacedImportDescription;
import org.eclipse.n4js.scoping.members.MemberScope;
import org.eclipse.n4js.scoping.utils.MergedScope;
import org.eclipse.n4js.scoping.utils.ScopesHelper;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.Versionable;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.ModuleNamespaceVirtualType;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TExportableElement;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.versions.VersionableUtils;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.AliasedEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

@Singleton
public class ImportedElementsScopingHelper {
    @Inject
    private IResourceScopeCache cache;
    @Inject
    private TypeVisibilityChecker typeVisibilityChecker;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private VariableVisibilityChecker variableVisibilityChecker;
    @Inject
    private ImportedElementsMap.Provider elementsMapProvider;
    @Inject
    private MemberScope.MemberScopeFactory memberScopeFactory;
    @Inject
    private ScopesHelper scopesHelper;
    @Inject
    private JavaScriptVariantHelper variantHelper;
    @Inject
    private VersionHelper versionHelper;

    public IScope getImportedIdentifiables(IScope parentScope, Script script) {
        Pair _mappedTo = Pair.of((Object)script, (Object)"importedIdentifiables");
        Provider _function = () -> {
            BuiltInTypeScope _get = BuiltInTypeScope.get((ResourceSet)script.eResource().getResourceSet());
            NoPrimitiveTypesScope builtInTypes = new NoPrimitiveTypesScope((IScope)_get);
            MergedScope _mergedScope = new MergedScope(parentScope, (IScope)builtInTypes);
            IScope globalObjectScope = this.getGlobalObjectProperties((IScope)_mergedScope, (EObject)script);
            IScope result = this.findImportedElements(script, globalObjectScope, true);
            return result;
        };
        IScope scriptScope = (IScope)this.cache.get((Object)_mappedTo, script.eResource(), _function);
        return scriptScope;
    }

    public IScope getImportedTypes(IScope parentScope, Script script) {
        Pair _mappedTo = Pair.of((Object)script, (Object)"importedTypes");
        Provider _function = () -> {
            IScope result = this.findImportedElements(script, parentScope, false);
            return result;
        };
        IScope scriptScope = (IScope)this.cache.get((Object)_mappedTo, script.eResource(), _function);
        return scriptScope;
    }

    private QualifiedName createQualifiedNameForAlias(NamedImportSpecifier specifier, TExportableElement importedElement) {
        String _xifexpression = null;
        boolean _isDefaultImport = specifier.isDefaultImport();
        if (_isDefaultImport) {
            _xifexpression = specifier.getImportedElementAsText();
        } else {
            String _name;
            String _exportedName;
            String _elvis = null;
            String _elvis_1 = null;
            String _alias = specifier.getAlias();
            _elvis_1 = _alias != null ? _alias : (_exportedName = importedElement.getExportedName());
            _elvis = _elvis_1 != null ? _elvis_1 : (_name = importedElement.getName());
            _xifexpression = _elvis;
        }
        String importedName = _xifexpression;
        return QualifiedName.create((String)importedName);
    }

    private QualifiedName createImportedQualifiedTypeName(Type type) {
        return QualifiedName.create((String)this.getImportedName(type));
    }

    private String getImportedName(Type type) {
        String _name;
        String _elvis = null;
        String _exportedName = type.getExportedName();
        _elvis = _exportedName != null ? _exportedName : (_name = type.getName());
        return _elvis;
    }

    private QualifiedName createImportedQualifiedTypeName(String namespace, Type type) {
        return QualifiedName.create((String[])new String[]{namespace, this.getImportedName(type)});
    }

    private IScope findImportedElements(Script script, IScope parentScope, boolean includeVariables) {
        Resource contextResource = script.eResource();
        Iterable imports = Iterables.filter((Iterable)script.getScriptElements(), ImportDeclaration.class);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)imports);
        if (_isEmpty) {
            return parentScope;
        }
        ImportedElementsMap invalidImports = this.elementsMapProvider.get((EObject)script);
        ImportedElementsMap validImports = this.elementsMapProvider.get((EObject)script);
        IEODesc2ISpec originatorMap = new IEODesc2ISpec();
        for (ImportDeclaration imp : imports) {
            boolean _tripleNotEquals;
            TModule _module = null;
            if (imp != null) {
                _module = imp.getModule();
            }
            boolean bl = _tripleNotEquals = _module != null;
            if (!_tripleNotEquals) continue;
            EList _importSpecifiers = imp.getImportSpecifiers();
            for (ImportSpecifier specifier : _importSpecifiers) {
                boolean _matched = false;
                if (specifier instanceof NamedImportSpecifier) {
                    _matched = true;
                    this.processNamedImportSpecifier((NamedImportSpecifier)specifier, imp, contextResource, originatorMap, validImports, invalidImports, includeVariables);
                }
                if (_matched || !(specifier instanceof NamespaceImportSpecifier)) continue;
                _matched = true;
                this.processNamespaceSpecifier((NamespaceImportSpecifier)specifier, imp, script, contextResource, originatorMap, validImports, invalidImports, includeVariables);
            }
        }
        Iterable<IEObjectDescription> _values = invalidImports.values();
        SimpleScope invalidLocalScope = new SimpleScope(_values);
        MergedScope localBaseScope = new MergedScope((IScope)invalidLocalScope, parentScope);
        IScope localValidScope = this.scopesHelper.mapBasedScopeFor((EObject)script, (IScope)localBaseScope, validImports.values());
        return new OriginAwareScope(localValidScope, originatorMap);
    }

    protected void processNamedImportSpecifier(NamedImportSpecifier specifier, ImportDeclaration imp, Resource contextResource, IEODesc2ISpec originatorMap, ImportedElementsMap validImports, ImportedElementsMap invalidImports, boolean importVariables) {
        TExportableElement element = specifier.getImportedElement();
        if (element != null && !element.eIsProxy()) {
            if (!importVariables && this.isVariableFrom((IdentifiableElement)element, imp)) {
                return;
            }
            QualifiedName importedQName = this.createQualifiedNameForAlias(specifier, element);
            AbstractTypeVisibilityChecker.TypeVisibility typeVisibility = this.isVisible(contextResource, (IdentifiableElement)element);
            if (typeVisibility.visibility) {
                this.addNamedImports(specifier, element, importedQName, originatorMap, validImports);
                QualifiedName originalName = QualifiedName.create((String)element.getName());
                if (specifier.getAlias() != null && !invalidImports.containsElement(originalName)) {
                    this.handleAliasedAccess((IdentifiableElement)element, originalName, importedQName.toString(), invalidImports, originatorMap, (ImportSpecifier)specifier);
                }
            } else {
                this.handleInvisible((IdentifiableElement)element, invalidImports, importedQName, typeVisibility.accessModifierSuggestion, originatorMap, (ImportSpecifier)specifier);
            }
        }
    }

    private void addNamedImports(NamedImportSpecifier specifier, TExportableElement element, QualifiedName importedName, IEODesc2ISpec originatorMap, ImportedElementsMap validImports) {
        if (this.variantHelper.allowVersionedTypes((EObject)specifier) && VersionableUtils.isTVersionable((EObject)element)) {
            Consumer<Type> _function = type -> {
                IEObjectDescription description = this.putOrError(validImports, (IdentifiableElement)type, importedName, "IMP_AMBIGUOUS");
                this.putWithOrigin(originatorMap, description, (ImportSpecifier)specifier);
            };
            this.versionHelper.findTypeVersions((Type)element).forEach(_function);
        } else {
            IEObjectDescription ieod = this.putOrError(validImports, (IdentifiableElement)element, importedName, "IMP_AMBIGUOUS");
            this.putWithOrigin(originatorMap, ieod, (ImportSpecifier)specifier);
        }
    }

    private void processNamespaceSpecifier(NamespaceImportSpecifier specifier, ImportDeclaration imp, Script script, Resource contextResource, IEODesc2ISpec originatorMap, ImportedElementsMap validImports, ImportedElementsMap invalidImports, boolean importVariables) {
        boolean _tripleEquals;
        String _alias = specifier.getAlias();
        boolean bl = _tripleEquals = _alias == null;
        if (_tripleEquals) {
            return;
        }
        String namespaceName = specifier.getAlias();
        QualifiedName namespaceQName = QualifiedName.create((String)namespaceName);
        EList _internalTypes = script.getModule().getInternalTypes();
        EList _exposedInternalTypes = script.getModule().getExposedInternalTypes();
        Functions.Function1 _function = interType -> interType instanceof ModuleNamespaceVirtualType && ((ModuleNamespaceVirtualType)interType).getModule() == imp.getModule();
        Type namespaceType = (Type)IterableExtensions.findFirst((Iterable)Iterables.concat((Iterable)_internalTypes, (Iterable)_exposedInternalTypes), (Functions.Function1)_function);
        IEObjectDescription ieodx = this.putOrError(validImports, (IdentifiableElement)namespaceType, namespaceQName, "IMP_AMBIGUOUS");
        this.putWithOrigin(originatorMap, ieodx, (ImportSpecifier)specifier);
        if (importVariables) {
            EList _variables = imp.getModule().getVariables();
            for (TVariable importedVar : _variables) {
                boolean _not;
                AbstractTypeVisibilityChecker.TypeVisibility varVisibility = this.variableVisibilityChecker.isVisible(contextResource, importedVar);
                String varName = importedVar.getExportedName();
                QualifiedName qn = QualifiedName.create((String[])new String[]{namespaceName, varName});
                if (!varVisibility.visibility) continue;
                QualifiedName originalName = QualifiedName.create((String)varName);
                boolean _containsElement = invalidImports.containsElement(originalName);
                boolean bl2 = _not = !_containsElement;
                if (!_not) continue;
                this.handleNamespacedAccess((IdentifiableElement)importedVar, originalName, qn, invalidImports, originatorMap, (ImportSpecifier)specifier);
            }
        }
        EList _topLevelTypes = imp.getModule().getTopLevelTypes();
        for (Type importedType : _topLevelTypes) {
            boolean _not;
            AbstractTypeVisibilityChecker.TypeVisibility typeVisibility = this.typeVisibilityChecker.isVisible(contextResource, importedType);
            QualifiedName qn = this.createImportedQualifiedTypeName(namespaceName, importedType);
            if (!typeVisibility.visibility) continue;
            QualifiedName originalName = this.createImportedQualifiedTypeName(importedType);
            boolean _containsElement = invalidImports.containsElement(originalName);
            boolean bl3 = _not = !_containsElement;
            if (!_not) continue;
            this.handleNamespacedAccess((IdentifiableElement)importedType, originalName, qn, invalidImports, originatorMap, (ImportSpecifier)specifier);
        }
    }

    private void handleAliasedAccess(IdentifiableElement element, QualifiedName originalName, String importedName, ImportedElementsMap invalidImports, IEODesc2ISpec originatorMap, ImportSpecifier specifier) {
        IEObjectDescription _create = N4JSEObjectDescription.create(originalName, (EObject)element);
        PlainAccessOfAliasedImportDescription invalidAccess = new PlainAccessOfAliasedImportDescription(_create, importedName);
        invalidImports.put(originalName, (IEObjectDescription)invalidAccess);
    }

    private void handleNamespacedAccess(IdentifiableElement importedType, QualifiedName originalName, QualifiedName qn, ImportedElementsMap invalidImports, IEODesc2ISpec originatorMap, ImportSpecifier specifier) {
        IEObjectDescription _create = N4JSEObjectDescription.create(originalName, (EObject)importedType);
        String _string = qn.toString();
        PlainAccessOfNamespacedImportDescription invalidAccess = new PlainAccessOfNamespacedImportDescription(_create, _string);
        invalidImports.put(originalName, (IEObjectDescription)invalidAccess);
    }

    private boolean handleInvisible(IdentifiableElement importedElement, ImportedElementsMap invalidImports, QualifiedName qn, String visibilitySuggestion, IEODesc2ISpec originatorMap, ImportSpecifier specifier) {
        boolean _xblockexpression = false;
        IEObjectDescription invalidAccess = this.putOrError(invalidImports, importedElement, qn, null);
        this.addAccessModifierSuggestion(invalidAccess, visibilitySuggestion);
        _xblockexpression = this.putWithOrigin(originatorMap, invalidAccess, specifier);
        return _xblockexpression;
    }

    private boolean putWithOrigin(HashMap<IEObjectDescription, ImportSpecifier> originiatorMap, IEObjectDescription description, ImportSpecifier specifier) {
        boolean _xblockexpression = false;
        originiatorMap.put(description, specifier);
        boolean _switchResult = false;
        boolean _matched = false;
        if (description instanceof AmbiguousImportDescription) {
            _matched = true;
            boolean _xblockexpression_1 = false;
            ((AmbiguousImportDescription)description).getOriginatingImports().add(specifier);
            ImportSpecifier firstPlaceSpec = originiatorMap.get(((AmbiguousImportDescription)description).delegate());
            boolean _xifexpression = false;
            if (firstPlaceSpec != null && !((AmbiguousImportDescription)description).getOriginatingImports().contains(firstPlaceSpec)) {
                _xifexpression = ((AmbiguousImportDescription)description).getOriginatingImports().add(firstPlaceSpec);
            }
            _switchResult = _xblockexpression_1 = _xifexpression;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    private boolean isVariableFrom(IdentifiableElement element, ImportDeclaration imp) {
        boolean _tripleNotEquals;
        boolean res = false;
        boolean _and = false;
        TModule _module = null;
        if (imp != null) {
            _module = imp.getModule();
        }
        boolean bl = _tripleNotEquals = _module != null;
        if (!_tripleNotEquals) {
            _and = false;
        } else {
            boolean _contains;
            TModule _module_1 = null;
            if (imp != null) {
                _module_1 = imp.getModule();
            }
            _and = _contains = _module_1.getVariables().contains((Object)element);
        }
        if (_and) {
            res = true;
        }
        return res;
    }

    private AbstractTypeVisibilityChecker.TypeVisibility isVisible(Resource contextResource, IdentifiableElement element) {
        AbstractTypeVisibilityChecker.TypeVisibility _xifexpression = null;
        if (element instanceof Type) {
            _xifexpression = this.typeVisibilityChecker.isVisible(contextResource, (Type)element);
        } else {
            AbstractTypeVisibilityChecker.TypeVisibility _xifexpression_1 = null;
            if (!(element instanceof TVariable)) {
                return new AbstractTypeVisibilityChecker.TypeVisibility(false);
            }
            _xifexpression_1 = this.variableVisibilityChecker.isVisible(contextResource, (TVariable)element);
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    protected boolean isAmbiguous(IEObjectDescription existing, IdentifiableElement element) {
        if (existing.getEObjectOrProxy() instanceof Versionable && element instanceof Versionable) {
            int _version_1;
            EObject _eObjectOrProxy = existing.getEObjectOrProxy();
            int _version = ((Versionable)_eObjectOrProxy).getVersion();
            return _version == (_version_1 = ((Versionable)element).getVersion());
        }
        return true;
    }

    private IEObjectDescription putOrError(ImportedElementsMap result, IdentifiableElement element, QualifiedName importedName, String issueCode) {
        Object ret = null;
        Iterable<IEObjectDescription> existing = result.getElements(importedName);
        if (!IterableExtensions.isEmpty(existing) && IterableExtensions.findFirst(existing, it -> this.isAmbiguous((IEObjectDescription)it, element)) != null) {
            if (issueCode != null) {
                boolean _matched = false;
                if (existing instanceof AmbiguousImportDescription) {
                    _matched = true;
                    List<IdentifiableElement> _elements = ((AmbiguousImportDescription)((Object)existing)).getElements();
                    _elements.add(element);
                    ret = (AmbiguousImportDescription)((Object)existing);
                }
                if (!_matched) {
                    IEObjectDescription _head = (IEObjectDescription)IterableExtensions.head(existing);
                    AmbiguousImportDescription error = new AmbiguousImportDescription(_head, issueCode, (EObject)element);
                    result.put(importedName, (IEObjectDescription)error);
                    List<IdentifiableElement> _elements = error.getElements();
                    _elements.add(element);
                    ret = error;
                }
            }
        } else if (issueCode == null) {
            ret = this.createDescription(importedName, element);
            InvisibleTypeOrVariableDescription _invisibleTypeOrVariableDescription = new InvisibleTypeOrVariableDescription((IEObjectDescription)ret);
            ret = _invisibleTypeOrVariableDescription;
            result.put(importedName, (IEObjectDescription)ret);
        } else {
            ret = this.createDescription(importedName, element);
            result.put(importedName, (IEObjectDescription)ret);
        }
        return ret;
    }

    private IEObjectDescription createDescription(QualifiedName name, IdentifiableElement element) {
        String _name;
        boolean _notEquals;
        String _lastSegment = name.getLastSegment();
        boolean bl = _notEquals = !Objects.equal((Object)_lastSegment, (Object)(_name = element.getName()));
        if (_notEquals) {
            IEObjectDescription _create = N4JSEObjectDescription.create(this.qualifiedNameProvider.getFullyQualifiedName((EObject)element), (EObject)element);
            return new AliasedEObjectDescription(name, _create);
        }
        return N4JSEObjectDescription.create(name, (EObject)element);
    }

    private IScope getGlobalObjectProperties(IScope parent, EObject context) {
        IScope _xblockexpression = null;
        TClass globalObject = GlobalObjectScope.get(context.eResource().getResourceSet()).getGlobalObject();
        _xblockexpression = this.memberScopeFactory.create(parent, (ContainerType<?>)globalObject, context, false, false);
        return _xblockexpression;
    }

    private void addAccessModifierSuggestion(IEObjectDescription description, String suggestion) {
        if (description instanceof InvisibleTypeOrVariableDescription) {
            ((InvisibleTypeOrVariableDescription)description).setAccessModifierSuggestion(suggestion);
        }
    }
}

