/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.TypeDefiningElement;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.assistants.TypeAssistant;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class FunctionDeclarationTransformation
extends Transformation {
    @Inject
    private TypeAssistant typeAssistant;

    public void assertPreConditions() {
    }

    public void assertPostConditions() {
        Functions.Function1 _function = it -> this.typeAssistant.isTopLevel((TypeDefiningElement)it);
        this.assertFalse("there should not be any top-level FunctionDeclarations in the intermediate model", IteratorExtensions.exists((Iterator)Iterators.filter((Iterator)this.getState().im.eAllContents(), FunctionDeclaration.class), (Functions.Function1)_function));
    }

    public void analyze() {
    }

    public void transform() {
        Consumer<FunctionDeclaration> _function = it -> this.doTransform((FunctionDeclaration)it);
        this.collectNodes((EObject)this.getState().im, FunctionDeclaration.class, false).forEach(_function);
    }

    private void doTransform(FunctionDeclaration funDecl) {
        String name = funDecl.getName();
        FunctionExpression __FunExpr = TranspilerBuilderBlocks._FunExpr((boolean)funDecl.isAsync(), (String)name, (FormalParameter[])((FormalParameter[])Conversions.unwrapArray((Object)funDecl.getFpars(), FormalParameter.class)), (Block)funDecl.getBody());
        Procedures.Procedure1 _function = it -> {
            it.setGenerator(funDecl.isGenerator());
            if (funDecl.getAnnotationList() != null && funDecl.getAnnotationList().getAnnotations().size() > 0) {
                it.setAnnotationList(TranspilerBuilderBlocks._ExprAnnoList((Annotation[])((Annotation[])Conversions.unwrapArray((Object)funDecl.getAnnotationList().getAnnotations(), Annotation.class))));
            }
        };
        FunctionExpression _doubleArrow = (FunctionExpression)ObjectExtensions.operator_doubleArrow((Object)__FunExpr, (Procedures.Procedure1)_function);
        VariableDeclaration varDecl = TranspilerBuilderBlocks._VariableDeclaration((String)name, (Expression)_doubleArrow);
        this.replace(funDecl, varDecl);
        this.getState().info.markAsToHoist(varDecl);
    }
}

