/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysers;

import java.util.Iterator;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.analysers.SymbolDeclaration;
import org.eclipse.n4js.flowgraphs.dataflow.Assumption;
import org.eclipse.n4js.flowgraphs.dataflow.DataFlowVisitor;
import org.eclipse.n4js.flowgraphs.dataflow.EffectInfo;
import org.eclipse.n4js.flowgraphs.dataflow.PartialResult;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.Symbol;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;

public class TaintedValueAnalyser
extends DataFlowVisitor {
    final N4JSTypeSystem ts;

    public TaintedValueAnalyser(N4JSTypeSystem ts) {
        this.ts = ts;
    }

    public void visitEffect(EffectInfo effect, ControlFlowElement cfe) {
        IsUntainted isUntainted;
        if (this.isUntaintedArgument(effect.symbol, cfe)) {
            isUntainted = new IsUntainted(cfe, effect.symbol);
            this.assume(isUntainted);
        }
        if (this.isUntaintedAssignee(effect.symbol, cfe)) {
            isUntainted = new IsUntainted(cfe, effect.symbol);
            this.assume(isUntainted);
        }
    }

    boolean isUntaintedArgument(Symbol symbol, ControlFlowElement cfe) {
        if (cfe instanceof ParameterizedCallExpression) {
            ParameterizedCallExpression pce = (ParameterizedCallExpression)cfe;
            for (Argument arg : pce.getArguments()) {
                FormalParameter fp;
                Iterator iterator;
                TypeRef typeRef;
                if (!symbol.is(arg.getExpression()) || !((typeRef = this.ts.tau((TypableElement)arg, (EObject)arg)) instanceof FormalParameter) || !(iterator = (fp = (FormalParameter)arg).getAnnotations().iterator()).hasNext()) continue;
                Annotation ann = (Annotation)iterator.next();
                String name = ann.getName();
                return "Untainted".equals(name);
            }
        }
        return false;
    }

    boolean isUntaintedAssignee(Symbol symbol, ControlFlowElement cfe) {
        AssignmentExpression ae;
        Expression lhs;
        if (cfe instanceof AssignmentExpression && symbol.is(lhs = (ae = (AssignmentExpression)cfe).getLhs())) {
            return this.assignedSymbolIsAnnotatedWith(symbol, "Untainted");
        }
        return false;
    }

    private boolean assignedSymbolIsAnnotatedWith(Symbol assignedSymbol, String annotationName) {
        Iterator iterator;
        EObject decl = SymbolDeclaration.get(assignedSymbol, this.ts);
        EList annotations = ECollections.emptyEList();
        if (decl instanceof N4FieldDeclaration) {
            N4FieldDeclaration fieldDecl = (N4FieldDeclaration)decl;
            annotations = fieldDecl.getAnnotations();
        }
        if (decl instanceof VariableDeclaration) {
            VariableDeclaration varDecl = (VariableDeclaration)decl;
            annotations = varDecl.getAnnotations();
        }
        if ((iterator = annotations.iterator()).hasNext()) {
            Annotation ann = (Annotation)iterator.next();
            String name = ann.getName();
            return annotationName.equals(name);
        }
        return false;
    }

    class IsUntainted
    extends Assumption {
        IsUntainted(ControlFlowElement cfe, Symbol symbol) {
            super(cfe, symbol);
        }

        IsUntainted(IsUntainted copy) {
            super((Assumption)copy);
        }

        public Assumption copy() {
            return new IsUntainted(this);
        }

        public PartialResult holdsOnDataflow(Symbol lhs, Symbol rSymbol, Expression rValue) {
            if (!TaintedValueAnalyser.this.assignedSymbolIsAnnotatedWith(rSymbol, "Tainted")) {
                return PartialResult.Passed;
            }
            return PartialResult.Unclear;
        }
    }
}

